/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.typeinference;

import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.evaluation.types.IClassType;
import org.eclipse.dltk.ti.types.IEvaluatedType;
import org.eclipse.php.core.compiler.PHPFlags;

public class PHPNamespaceType
implements IClassType {
    private String namespace;

    public PHPNamespaceType(String typeName) {
        if (typeName != null && typeName.startsWith("\\")) {
            typeName = "\\" + typeName;
        }
        this.namespace = typeName;
    }

    public String getTypeName() {
        return this.namespace;
    }

    public boolean subtypeOf(IEvaluatedType type) {
        return false;
    }

    public String getModelKey() {
        return this.namespace;
    }

    public static PHPNamespaceType fromIType(IType type) {
        String elementName = type.getElementName();
        try {
            if (PHPFlags.isNamespace(type.getFlags())) {
                return new PHPNamespaceType(elementName);
            }
        }
        catch (ModelException modelException) {}
        return null;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.namespace == null ? 0 : this.namespace.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PHPNamespaceType other = (PHPNamespaceType)obj;
        return !(this.namespace == null ? other.namespace != null : !this.namespace.equals(other.namespace));
    }
}

