/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.ast.nodes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.php.core.PHPVersion;
import org.eclipse.php.core.ast.match.ASTMatcher;
import org.eclipse.php.core.ast.nodes.AST;
import org.eclipse.php.core.ast.nodes.ASTNode;
import org.eclipse.php.core.ast.nodes.ChildPropertyDescriptor;
import org.eclipse.php.core.ast.nodes.Expression;
import org.eclipse.php.core.ast.nodes.SimplePropertyDescriptor;
import org.eclipse.php.core.ast.nodes.StructuralPropertyDescriptor;
import org.eclipse.php.core.ast.visitor.Visitor;

public class CastExpression
extends Expression {
    public static final int TYPE_INT = 0;
    public static final int TYPE_REAL = 1;
    public static final int TYPE_STRING = 2;
    public static final int TYPE_ARRAY = 3;
    public static final int TYPE_OBJECT = 4;
    public static final int TYPE_BOOL = 5;
    public static final int TYPE_UNSET = 6;
    private Expression expression;
    private int castingType;
    public static final ChildPropertyDescriptor EXPRESSION_PROPERTY = new ChildPropertyDescriptor(CastExpression.class, "expression", Expression.class, true, true);
    public static final SimplePropertyDescriptor CASTING_TYPE_PROPERTY = new SimplePropertyDescriptor(CastExpression.class, "castingType", Integer.class, true);
    private static final List<StructuralPropertyDescriptor> PROPERTY_DESCRIPTORS;

    static {
        ArrayList<StructuralPropertyDescriptor> properyList = new ArrayList<StructuralPropertyDescriptor>(3);
        properyList.add(EXPRESSION_PROPERTY);
        properyList.add(CASTING_TYPE_PROPERTY);
        PROPERTY_DESCRIPTORS = Collections.unmodifiableList(properyList);
    }

    public CastExpression(int start, int end, AST ast, Expression expr, int castType) {
        super(start, end, ast);
        if (expr == null) {
            throw new IllegalArgumentException();
        }
        this.setExpression(expr);
        this.setCastingType(castType);
    }

    public CastExpression(AST ast) {
        super(ast);
    }

    @Override
    public void accept0(Visitor visitor) {
        boolean visit = visitor.visit(this);
        if (visit) {
            this.childrenAccept(visitor);
        }
        visitor.endVisit(this);
    }

    public static String getCastType(int type) {
        switch (type) {
            case 0: {
                return "int";
            }
            case 1: {
                return "real";
            }
            case 2: {
                return "string";
            }
            case 3: {
                return "array";
            }
            case 4: {
                return "object";
            }
            case 5: {
                return "bool";
            }
            case 6: {
                return "unset";
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void childrenAccept(Visitor visitor) {
        this.expression.accept(visitor);
    }

    @Override
    public void traverseTopDown(Visitor visitor) {
        this.accept(visitor);
        this.expression.traverseTopDown(visitor);
    }

    @Override
    public void traverseBottomUp(Visitor visitor) {
        this.expression.traverseBottomUp(visitor);
        this.accept(visitor);
    }

    @Override
    public void toString(StringBuffer buffer, String tab) {
        buffer.append(tab).append("<CastExpression");
        this.appendInterval(buffer);
        buffer.append(" castType='").append(CastExpression.getCastType(this.castingType)).append("'>\n");
        this.expression.toString(buffer, "\t" + tab);
        buffer.append("\n").append(tab).append("</CastExpression>");
    }

    @Override
    public int getType() {
        return 8;
    }

    public int getCastingType() {
        return this.castingType;
    }

    public void setCastingType(int castingType) {
        if (CastExpression.getCastType(castingType) == null) {
            throw new IllegalArgumentException("Invalid type");
        }
        this.preValueChange(CASTING_TYPE_PROPERTY);
        this.castingType = castingType;
        this.postValueChange(CASTING_TYPE_PROPERTY);
    }

    @Override
    int internalGetSetIntProperty(SimplePropertyDescriptor property, boolean get, int value) {
        if (property == CASTING_TYPE_PROPERTY) {
            if (get) {
                return this.getCastingType();
            }
            this.setCastingType(value);
            return 0;
        }
        return super.internalGetSetIntProperty(property, get, value);
    }

    public Expression getExpression() {
        return this.expression;
    }

    public void setExpression(Expression expression) {
        if (expression == null) {
            throw new IllegalArgumentException();
        }
        Expression oldChild = this.expression;
        this.preReplaceChild(oldChild, expression, EXPRESSION_PROPERTY);
        this.expression = expression;
        this.postReplaceChild(oldChild, expression, EXPRESSION_PROPERTY);
    }

    @Override
    final Object internalGetSetObjectProperty(SimplePropertyDescriptor property, boolean get, Object value) {
        if (property == CASTING_TYPE_PROPERTY) {
            if (get) {
                return this.getCastingType();
            }
            this.setCastingType((Integer)value);
            return null;
        }
        return super.internalGetSetObjectProperty(property, get, value);
    }

    @Override
    final ASTNode internalGetSetChildProperty(ChildPropertyDescriptor property, boolean get, ASTNode child) {
        if (property == EXPRESSION_PROPERTY) {
            if (get) {
                return this.getExpression();
            }
            this.setExpression((Expression)child);
            return null;
        }
        return super.internalGetSetChildProperty(property, get, child);
    }

    @Override
    public boolean subtreeMatch(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    @Override
    ASTNode clone0(AST target) {
        Expression clone = ASTNode.copySubtree(target, this.getExpression());
        CastExpression result = new CastExpression(this.getStart(), this.getEnd(), target, clone, this.getCastingType());
        return result;
    }

    @Override
    List<StructuralPropertyDescriptor> internalStructuralPropertiesForType(PHPVersion apiLevel) {
        return PROPERTY_DESCRIPTORS;
    }
}

