/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.builder;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.pde.api.tools.internal.model.ApiType;
import org.eclipse.pde.api.tools.internal.model.ProjectComponent;
import org.eclipse.pde.api.tools.internal.problems.ApiProblemFactory;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.builder.IApiProblemDetector;
import org.eclipse.pde.api.tools.internal.provisional.builder.IReference;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiComponent;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiField;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiMember;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiMethod;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiType;
import org.eclipse.pde.api.tools.internal.provisional.problems.IApiProblem;
import org.eclipse.pde.api.tools.internal.util.Signatures;
import org.eclipse.pde.api.tools.internal.util.Util;

public abstract class AbstractProblemDetector
implements IApiProblemDetector {
    public static final String METHOD_REFERENCE = "::";
    public static final String CONSTRUCTOR_NEW = "new";
    private List<IReference> fPotentialProblems = new LinkedList<IReference>();

    protected void retainReference(IReference reference) {
        this.fPotentialProblems.add(reference);
    }

    protected List<IReference> getRetainedReferences() {
        return this.fPotentialProblems;
    }

    @Override
    public boolean considerReference(IReference reference) {
        return reference != null && (reference.getReferenceKind() & this.getReferenceKinds()) > 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected IApiProblem createProblem(IReference reference, IJavaProject javaProject) {
        IProject project = javaProject.getProject();
        if (ApiPlugin.getDefault().getSeverityLevel(this.getSeverityKey(), project) == 0) {
            return null;
        }
        try {
            IApiMember member = reference.getMember();
            String lookupName = this.getTypeName(member).replace('$', '.');
            IType type = javaProject.findType(lookupName, (IProgressMonitor)new NullProgressMonitor());
            if (type == null) {
                return null;
            }
            ICompilationUnit compilationUnit = type.getCompilationUnit();
            if (compilationUnit == null) {
                return null;
            }
            IResource resource = Util.getResource(project, type);
            if (resource == null) {
                return null;
            }
            int charStart = -1;
            int charEnd = -1;
            int lineNumber = reference.getLineNumber();
            ICompilationUnit element = compilationUnit;
            if (!Util.isManifest(resource.getProjectRelativePath()) && !type.isBinary()) {
                IDocument document = Util.getDocument(compilationUnit);
                if (lineNumber > 0) {
                    --lineNumber;
                }
                if ((reference.getReferenceKind() & 0x1000003B) != 0) {
                    IApiType enclosingType = member.getEnclosingType();
                    if (lineNumber > 0 && enclosingType != null && enclosingType.isAnonymous()) {
                        String superclass = enclosingType.getSuperclassName();
                        String name = null;
                        if ("java.lang.Object".equals(superclass)) {
                            String[] superinterfaces = enclosingType.getSuperInterfaceNames();
                            if (superinterfaces != null) {
                                String superinterface = superinterfaces[0];
                                name = superinterface.substring(superinterface.lastIndexOf(46) + 1);
                            } else {
                                name = superclass.substring(superclass.lastIndexOf(46) + 1);
                            }
                        } else if (superclass != null) {
                            name = superclass.substring(superclass.lastIndexOf(46) + 1);
                        }
                        if (name != null) {
                            try {
                                IRegion lineInformation = document.getLineInformation(lineNumber);
                                String lineContents = document.get(lineInformation.getOffset(), lineInformation.getLength());
                                charStart = lineInformation.getOffset() + lineContents.indexOf(name);
                                charEnd = charStart + name.length();
                            }
                            catch (BadLocationException e) {
                                ApiPlugin.log(e);
                                return null;
                            }
                        }
                    }
                }
                if (charStart == -1) {
                    try {
                        Position pos = this.getSourceRange(type, document, reference);
                        if (pos != null && (charStart = pos.getOffset()) != -1) {
                            charEnd = charStart + pos.getLength();
                            lineNumber = document.getLineOfOffset(charStart);
                        }
                    }
                    catch (CoreException e) {
                        ApiPlugin.log(e);
                        return null;
                    }
                    catch (BadLocationException e) {
                        ApiPlugin.log(e);
                        return null;
                    }
                }
                if (charStart > -1) {
                    element = compilationUnit.getElementAt(charStart);
                }
            }
            return ApiProblemFactory.newApiUsageProblem(resource.getProjectRelativePath().toPortableString(), type.getFullyQualifiedName(), this.getMessageArgs(reference), new String[]{"org.eclipse.jdt.internal.core.JavaModelManager.handleId", "apiMarkerID"}, new Object[]{element == null ? compilationUnit.getHandleIdentifier() : element.getHandleIdentifier(), 3}, lineNumber, charStart, charEnd, this.getElementType(reference), this.getProblemKind(), this.getProblemFlags(reference));
        }
        catch (CoreException e) {
            ApiPlugin.log(e);
            return null;
        }
    }

    protected abstract Position getSourceRange(IType var1, IDocument var2, IReference var3) throws CoreException, BadLocationException;

    protected abstract int getElementType(IReference var1);

    protected abstract int getProblemFlags(IReference var1);

    protected abstract String[] getMessageArgs(IReference var1) throws CoreException;

    protected abstract String[] getQualifiedMessageArgs(IReference var1) throws CoreException;

    protected abstract int getProblemKind();

    protected abstract String getSeverityKey();

    protected String getTypeName(IApiMember member) throws CoreException {
        switch (member.getType()) {
            case 2: {
                IApiType type = (IApiType)member;
                if (type.isAnonymous()) {
                    return this.getTypeName(member.getEnclosingType());
                }
                if (type.isLocal()) {
                    return this.getTypeName(member.getEnclosingType());
                }
                return member.getName();
            }
        }
        return this.getTypeName(member.getEnclosingType());
    }

    protected String getQualifiedTypeName(IApiMember member) throws CoreException {
        switch (member.getType()) {
            case 2: {
                IApiType type = (IApiType)member;
                if (type.isAnonymous()) {
                    return this.getQualifiedTypeName(member.getEnclosingType());
                }
                if (type.isLocal()) {
                    String name = this.getTypeName(member.getEnclosingType());
                    int idx = name.indexOf(36);
                    if (idx > -1) {
                        return name.substring(0, idx);
                    }
                    return name;
                }
                return Signatures.getQualifiedTypeSignature((IApiType)member);
            }
        }
        return this.getQualifiedTypeName(member.getEnclosingType());
    }

    protected String getSimpleTypeName(IApiMember member) throws CoreException {
        switch (member.getType()) {
            case 2: {
                IApiType type = (IApiType)member;
                if (type.isAnonymous()) {
                    return this.getSimpleTypeName(type.getEnclosingType());
                }
                if (type.isLocal()) {
                    String name = this.getSimpleTypeName(member.getEnclosingType());
                    int idx = name.indexOf(36);
                    if (idx > -1) {
                        return name.substring(0, idx);
                    }
                    return name;
                }
                return Signatures.getTypeName(Signatures.getTypeSignature(type));
            }
        }
        return this.getSimpleTypeName(member.getEnclosingType());
    }

    protected Position defaultSourcePosition(IType type, IReference reference) throws CoreException {
        ISourceRange range;
        if (type != null && (range = type.getNameRange()) != null) {
            return new Position(range.getOffset(), range.getLength());
        }
        return null;
    }

    protected int findMethodNameStart(String namepart, String line, int index) {
        if (namepart.startsWith(METHOD_REFERENCE)) {
            int offset = index;
            char c = line.charAt(offset);
            while (!Character.isJavaIdentifierPart((int)c)) {
                c = line.charAt(--offset);
            }
            while (Character.isJavaIdentifierPart((int)c)) {
                if ((c = line.charAt(--offset)) != '<') continue;
                c = line.charAt(--offset);
            }
            return ++offset;
        }
        int start = line.indexOf(namepart, index);
        if (start < 0) {
            return -1;
        }
        int offset = start + namepart.length();
        char c = line.charAt(offset);
        while (c == ' ') {
            c = line.charAt(++offset);
        }
        if (c == '(' || c == '<') {
            return start;
        }
        if (line.contains(METHOD_REFERENCE)) {
            if (c == ';' || c == '\r' || c == ')') {
                return start;
            }
            if (c == ':' && line.charAt(offset + 1) == ':' && line.contains(CONSTRUCTOR_NEW)) {
                return start;
            }
        }
        return this.findMethodNameStart(namepart, line, offset);
    }

    @Override
    public List<IApiProblem> createProblems(IProgressMonitor monitor) {
        List<IReference> references = this.getRetainedReferences();
        if (references.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        LinkedList<IApiProblem> problems = new LinkedList<IApiProblem>();
        Iterator<IReference> iterator = references.iterator();
        SubMonitor loopMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)references.size());
        while (iterator.hasNext()) {
            loopMonitor.split(1);
            IReference reference = iterator.next();
            if (reference.getResolvedReference() == null || !this.isProblem(reference)) continue;
            try {
                IApiProblem problem = null;
                IApiComponent component = reference.getMember().getApiComponent();
                if (component instanceof ProjectComponent) {
                    ProjectComponent ppac = (ProjectComponent)component;
                    IJavaProject project = ppac.getJavaProject();
                    problem = this.createProblem(reference, project);
                } else {
                    problem = this.createProblem(reference);
                }
                if (problem == null) continue;
                problems.add(problem);
            }
            catch (CoreException e) {
                ApiPlugin.log(e.getStatus());
            }
        }
        return problems;
    }

    protected boolean isProblem(IReference reference) {
        IApiMember member = reference.getResolvedReference();
        if (member != null) {
            IApiMember local = reference.getMember();
            try {
                IApiComponent lcomp = local.getApiComponent();
                if (lcomp != null && lcomp.isFragment()) {
                    return !lcomp.getHost().equals(member.getApiComponent());
                }
            }
            catch (CoreException ce) {
                ApiPlugin.log(ce);
            }
        }
        return true;
    }

    protected boolean isReferenceFromComponent(IReference reference, String componentId) {
        if (componentId != null) {
            IApiComponent apiComponent = reference.getResolvedReference().getApiComponent();
            if (apiComponent.getSymbolicName().equals(componentId)) {
                return true;
            }
            try {
                IApiComponent host = apiComponent.getHost();
                return host != null && host.getSymbolicName().equals(componentId);
            }
            catch (CoreException e) {
                ApiPlugin.log(e);
            }
        }
        return false;
    }

    protected IMethod findMethodInType(IType type, IApiMethod method) throws JavaModelException, CoreException {
        String[] parameterTypes = Signature.getParameterTypes((String)method.getSignature());
        int i = 0;
        while (i < parameterTypes.length) {
            parameterTypes[i] = parameterTypes[i].replace('/', '.');
            ++i;
        }
        String methodname = method.getName();
        if (method.isConstructor()) {
            IApiType enclosingType = method.getEnclosingType();
            if (enclosingType.isMemberType() && !Flags.isStatic((int)enclosingType.getModifiers())) {
                int length = parameterTypes.length - 1;
                String[] stringArray = parameterTypes;
                parameterTypes = new String[length];
                System.arraycopy(stringArray, 1, parameterTypes, 0, length);
            }
            methodname = enclosingType.getSimpleName();
        }
        IMethod Qmethod = type.getMethod(methodname, parameterTypes);
        IMethod[] methods = type.getMethods();
        IMethod match = null;
        IMethod[] iMethodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod m = iMethodArray[n2];
            if (m.isSimilar(Qmethod)) {
                match = m;
                break;
            }
            ++n2;
        }
        return match;
    }

    protected IField findFieldInType(IType type, IApiField field) throws JavaModelException {
        IField match = null;
        match = type.getField(field.getName());
        if (!match.exists()) {
            IField[] fields;
            IField[] iFieldArray = fields = type.getFields();
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                IField loopField = iFieldArray[n2];
                if (loopField.getElementName().equals(field.getName())) {
                    match = loopField;
                    break;
                }
                ++n2;
            }
        }
        return match;
    }

    protected IType findTypeInType(IType type, IApiType apitype, IReference reference, IDocument doc) throws CoreException, JavaModelException {
        String tname;
        if (apitype.isLocal()) {
            IMethod method;
            String name = apitype.getSimpleName();
            ICompilationUnit cunit = type.getCompilationUnit();
            if (cunit.isWorkingCopy()) {
                cunit.reconcile(8, false, null, null);
            }
            if ((method = this.getEnclosingMethod(type, reference, doc)) != null) {
                return method.getType(name, 1);
            }
        }
        if ((tname = type.getElementName()).equals(apitype.getName()) || tname.equals(apitype.getSimpleName())) {
            return type;
        }
        IType match = null;
        IType[] iTypeArray = type.getTypes();
        int n = iTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IType t = iTypeArray[n2];
            if (t.getElementName().equals(apitype.getName())) {
                match = t;
                break;
            }
            ++n2;
        }
        return match;
    }

    protected IMethod getEnclosingMethod(IType jtype, IReference reference, IDocument document) throws CoreException {
        IApiMember member = reference.getMember();
        if (member.getType() == 2) {
            ApiType type = (ApiType)member;
            IApiMethod apimethod = type.getEnclosingMethod();
            if (apimethod != null) {
                String signature = Signatures.processMethodSignature(apimethod);
                String methodname = Signatures.getMethodName(apimethod);
                IMethod method = jtype.getMethod(methodname, Signature.getParameterTypes((String)signature));
                if (method.exists()) {
                    return method;
                }
            } else {
                IMethod method = null;
                if (reference.getLineNumber() > -1) {
                    try {
                        int offset = document.getLineOffset(reference.getLineNumber());
                        method = this.quickLookup(jtype, document, reference, offset);
                    }
                    catch (BadLocationException badLocationException) {}
                }
                if (method == null) {
                    ISourceRange range = jtype.getCompilationUnit().getSourceRange();
                    ASTParser parser = ASTParser.newParser((int)8);
                    parser.setSource(jtype.getCompilationUnit());
                    parser.setSourceRange(range.getOffset(), range.getLength());
                    parser.setResolveBindings(true);
                    ASTNode ptype = parser.createAST(null);
                    MethodFinder finder = new MethodFinder(type, jtype);
                    ptype.accept((ASTVisitor)finder);
                    method = finder.method;
                }
                if (method != null && method.exists()) {
                    ApiType etype = (ApiType)type.getEnclosingType();
                    IApiMethod[] methods = etype.getMethods();
                    String msig = null;
                    IApiMethod[] iApiMethodArray = methods;
                    int n = methods.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IApiMethod m = iApiMethodArray[n2];
                        msig = m.getSignature();
                        if (Signatures.getMethodName(m).equals(method.getElementName()) && Signatures.matchesSignatures(msig.replace('/', '.'), method.getSignature())) {
                            type.setEnclosingMethodInfo(m.getName(), msig);
                        }
                        ++n2;
                    }
                    return method;
                }
            }
        }
        return null;
    }

    protected IMethod quickLookup(IType jtype, IDocument document, IReference reference, int offset) throws JavaModelException {
        IJavaElement ancestor;
        IJavaElement element;
        if (offset > -1 && (element = jtype.getCompilationUnit().getElementAt(offset)) != null && (ancestor = element.getAncestor(9)) != null) {
            return (IMethod)ancestor;
        }
        return null;
    }

    protected Position getSourceRangeForMethod(IType type, IReference reference, IApiMethod method) throws CoreException, JavaModelException {
        ISourceRange range;
        IMethod match = this.findMethodInType(type, method);
        Position pos = null;
        if (match != null && (range = match.getNameRange()) != null) {
            pos = new Position(range.getOffset(), range.getLength());
        }
        if (pos == null) {
            return this.defaultSourcePosition(type, reference);
        }
        return pos;
    }

    protected Position getSourceRangeForField(IType type, IReference reference, IApiField field) throws JavaModelException, CoreException {
        ISourceRange range;
        IField javaField = type.getField(field.getName());
        Position pos = null;
        if (javaField.exists() && (range = javaField.getNameRange()) != null) {
            pos = new Position(range.getOffset(), range.getLength());
        }
        if (pos == null) {
            return this.defaultSourcePosition(type, reference);
        }
        return pos;
    }

    protected Position getFieldNameRange(IApiField field, IDocument document, IReference reference) throws BadLocationException, CoreException {
        return this.getFieldNameRange(field.getEnclosingType().getName(), field.getName(), document, reference);
    }

    protected Position getFieldNameRange(String typeName, String fieldName, IDocument document, IReference reference) throws BadLocationException {
        int linenumber = reference.getLineNumber();
        if (linenumber > 0) {
            --linenumber;
        }
        if (linenumber > 0) {
            String qname;
            int offset = document.getLineOffset(linenumber);
            String line = document.get(offset, document.getLineLength(linenumber));
            int first = line.indexOf(qname = String.valueOf(typeName) + "." + fieldName);
            if (first < 0) {
                qname = "super." + fieldName;
                first = line.indexOf(qname);
            }
            if (first < 0) {
                qname = "this." + fieldName;
                first = line.indexOf(qname);
            }
            if (first < 0) {
                int idx = line.indexOf(fieldName);
                while (idx > -1) {
                    if (line.charAt(idx - 1) == '.') {
                        first = idx;
                        qname = fieldName;
                        break;
                    }
                    idx = line.indexOf(fieldName, idx + 1);
                }
            }
            Position pos = null;
            pos = first > -1 ? new Position(offset + first, qname.length()) : new Position(offset, line.length());
            return pos;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected Position getMethodNameRange(boolean isContructor, String name, IDocument document, IReference reference) throws CoreException, BadLocationException {
        int offset;
        String line;
        int start;
        String methodname;
        int idx;
        block13: {
            block12: {
                int linenumber = reference.getLineNumber();
                if (linenumber > 0) {
                    --linenumber;
                }
                if ((idx = (methodname = name).indexOf(36)) > -1) {
                    methodname = methodname.substring(0, idx);
                }
                if ((idx = methodname.indexOf(Signatures.getLT())) > -1) {
                    methodname = methodname.substring(0, idx);
                }
                if ((start = (line = document.get(offset = document.getLineOffset(linenumber), document.getLineLength(linenumber))).indexOf(61)) >= 0) break block12;
                if (isContructor) {
                    start = line.indexOf("::new");
                    if (start >= 0) {
                        int first = this.findMethodNameStart("::new", line, start);
                        return new Position(offset + first, start - first + 5);
                    }
                    line.indexOf(CONSTRUCTOR_NEW);
                    if (start < 0) {
                        start = 0;
                    }
                    break block13;
                } else {
                    start = 0;
                }
                break block13;
            }
            char charat = line.charAt(start - 1);
            if (line.charAt(start + 1) == '=' || charat == '!' || charat == '<' || charat == '>') {
                start = 0;
            }
        }
        int first = this.findMethodNameStart(methodname, line, start);
        if (line.contains(METHOD_REFERENCE) && line.contains(CONSTRUCTOR_NEW) && isContructor) {
            String afterReference = line.substring(line.indexOf(METHOD_REFERENCE));
            methodname = afterReference.substring(afterReference.indexOf(METHOD_REFERENCE) + 2, afterReference.indexOf(CONSTRUCTOR_NEW) + 3);
        }
        if (first < 0) {
            methodname = "super";
            first = this.findMethodNameStart(methodname, line, start);
        }
        if (first <= -1) {
            return null;
        }
        idx = line.indexOf(METHOD_REFERENCE, first);
        if (idx > -1 && isContructor) {
            return new Position(offset + first, idx - first + 2 + methodname.length());
        }
        return new Position(offset + first, methodname.length());
    }

    boolean isEnclosedBy(String signature, Set<String> typenames) {
        if (signature == null || typenames == null) {
            return false;
        }
        if (typenames.contains(signature)) {
            return true;
        }
        StringTokenizer tokenizer = new StringTokenizer(signature, "$");
        while (tokenizer.hasMoreTokens()) {
            if (!typenames.contains(tokenizer.nextToken())) continue;
            return true;
        }
        return false;
    }

    public IApiProblem createProblem(IReference reference) throws CoreException {
        int lineNumber = reference.getLineNumber();
        if (lineNumber > 0) {
            --lineNumber;
        }
        String ltypename = this.getTypeName(reference.getMember());
        return ApiProblemFactory.newApiUsageProblem(null, ltypename, this.getQualifiedMessageArgs(reference), new String[]{"apiMarkerID"}, new Object[]{3}, lineNumber, -1, -1, this.getElementType(reference), this.getProblemKind(), this.getProblemFlags(reference));
    }

    public IApiProblem checkAndCreateProblem(IReference reference) throws CoreException {
        if (!this.isProblem(reference)) {
            return null;
        }
        return this.createProblem(reference);
    }

    class MethodFinder
    extends ASTVisitor {
        IMethod method = null;
        private IType jtype = null;
        private ApiType type = null;

        public MethodFinder(ApiType type, IType jtype) {
            this.type = type;
            this.jtype = jtype;
        }

        public boolean visit(AnonymousClassDeclaration node) {
            if (this.method == null) {
                ITypeBinding binding = node.resolveBinding();
                String binaryName = binding.getBinaryName();
                if (this.type.getName().endsWith(binaryName)) {
                    try {
                        IJavaElement ancestor;
                        IJavaElement element = this.jtype.getCompilationUnit().getElementAt(node.getStartPosition());
                        if (element != null && (ancestor = element.getAncestor(9)) != null) {
                            this.method = (IMethod)ancestor;
                        }
                    }
                    catch (JavaModelException javaModelException) {}
                    return false;
                }
            }
            return true;
        }

        public boolean visit(TypeDeclaration node) {
            if (this.method == null && node.isLocalTypeDeclaration()) {
                ITypeBinding binding = node.resolveBinding();
                String binaryName = binding.getBinaryName();
                if (this.type.getName().endsWith(binaryName)) {
                    try {
                        IType ltype;
                        IJavaElement parent;
                        IJavaElement element = this.jtype.getCompilationUnit().getElementAt(node.getStartPosition());
                        if (element.getElementType() == 7 && (parent = (ltype = (IType)element).getParent()).getElementType() == 9) {
                            this.method = (IMethod)parent;
                        }
                    }
                    catch (JavaModelException javaModelException) {}
                    return false;
                }
            }
            return true;
        }
    }
}

