/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.service.types.command;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.commands.ConfigureElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.uml.service.types.element.UMLElementTypes;
import org.eclipse.papyrus.uml.service.types.utils.ElementUtil;
import org.eclipse.uml2.uml.DestructionOccurrenceSpecification;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.ExecutionOccurrenceSpecification;
import org.eclipse.uml2.uml.ExecutionSpecification;
import org.eclipse.uml2.uml.Gate;
import org.eclipse.uml2.uml.Interaction;
import org.eclipse.uml2.uml.Lifeline;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.MessageEnd;
import org.eclipse.uml2.uml.MessageOccurrenceSpecification;
import org.eclipse.uml2.uml.MessageSort;
import org.eclipse.uml2.uml.OccurrenceSpecification;
import org.eclipse.uml2.uml.UMLFactory;

public class ConfigureMessageEventCommand
extends ConfigureElementCommand {
    private ConfigureRequest request;

    public ConfigureMessageEventCommand(ConfigureRequest request) {
        super(request);
        this.request = request;
    }

    protected Element getSource(ConfigureRequest req) {
        Element result = null;
        Object paramObject = req.getParameter("CreateRelationshipRequest.source");
        if (paramObject instanceof Element) {
            result = (Element)paramObject;
        }
        return result;
    }

    public static MessageEnd createMessageEnd(Message message, Lifeline lifeline, MessageEnd previous) {
        MessageOccurrenceSpecification messageOccurrenceSpecification = UMLFactory.eINSTANCE.createMessageOccurrenceSpecification();
        if (previous == null) {
            messageOccurrenceSpecification.setCovered(lifeline);
        } else {
            lifeline.getCoveredBys().add(lifeline.getCoveredBys().indexOf((Object)previous) + 1, (Object)messageOccurrenceSpecification);
        }
        messageOccurrenceSpecification.setMessage(message);
        messageOccurrenceSpecification.setMessage(message);
        ((Interaction)message.getOwner()).getFragments().add((Object)messageOccurrenceSpecification);
        return messageOccurrenceSpecification;
    }

    public static MessageEnd createDestroyMessageEnd(Message message, Lifeline lifeline) {
        DestructionOccurrenceSpecification messageOccurrenceSpecification = UMLFactory.eINSTANCE.createDestructionOccurrenceSpecification();
        messageOccurrenceSpecification.setCovered(lifeline);
        messageOccurrenceSpecification.setMessage(message);
        ((Interaction)message.getOwner()).getFragments().add((Object)messageOccurrenceSpecification);
        return messageOccurrenceSpecification;
    }

    protected Element getTarget(ConfigureRequest req) {
        Element result = null;
        Object paramObject = req.getParameter("CreateRelationshipRequest.target");
        if (paramObject instanceof Element) {
            result = (Element)paramObject;
        }
        return result;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        Message message = (Message)this.request.getElementToConfigure();
        Element source = this.getSource(this.request);
        Element target = this.getTarget(this.request);
        MessageEnd previousSentEvent = (MessageEnd)this.request.getParameters().get("previous event");
        MessageEnd previousReceiveEvent = (MessageEnd)this.request.getParameters().get("second previous event");
        ExecutionOccurrenceSpecification toReplacebyMessageSent = (ExecutionOccurrenceSpecification)this.request.getParameters().get("MESSAGE_SENTEVENT_REPLACE_EXECUTIONEVENT");
        ExecutionOccurrenceSpecification toReplacebyMessageReceive = (ExecutionOccurrenceSpecification)this.request.getParameters().get("MESSAGE_RECEIVEEVENT_REPLACE_EXECUTIONEVENT");
        IElementType elementType = this.request.getTypeToConfigure();
        if (ElementUtil.isTypeOf(elementType, (IElementType)UMLElementTypes.COMPLETE_ASYNCH_CALL)) {
            this.createSendEvent(message, source, previousSentEvent);
            this.createReceiveEvent(message, target, previousReceiveEvent);
            message.setMessageSort(MessageSort.ASYNCH_CALL_LITERAL);
        } else if (ElementUtil.isTypeOf(elementType, (IElementType)UMLElementTypes.COMPLETE_ASYNCH_SIGNAL)) {
            this.createSendEvent(message, source, previousSentEvent);
            this.createReceiveEvent(message, target, previousReceiveEvent);
            message.setMessageSort(MessageSort.ASYNCH_SIGNAL_LITERAL);
        } else if (ElementUtil.isTypeOf(elementType, (IElementType)UMLElementTypes.COMPLETE_CREATE_MESSAGE)) {
            this.createSendEvent(message, source, previousSentEvent);
            this.createReceiveEvent(message, target, previousReceiveEvent);
            message.setMessageSort(MessageSort.CREATE_MESSAGE_LITERAL);
        } else if (ElementUtil.isTypeOf(elementType, (IElementType)UMLElementTypes.COMPLETE_DELETE_MESSAGE)) {
            this.createSendEvent(message, source, previousSentEvent);
            this.createDestroyReceiveEvent(message, target);
            message.setMessageSort(MessageSort.DELETE_MESSAGE_LITERAL);
        } else if (ElementUtil.isTypeOf(elementType, (IElementType)UMLElementTypes.COMPLETE_REPLY)) {
            this.createSendEvent(message, source, previousSentEvent);
            this.createReceiveEvent(message, target, previousReceiveEvent);
            message.setMessageSort(MessageSort.REPLY_LITERAL);
        } else if (ElementUtil.isTypeOf(elementType, (IElementType)UMLElementTypes.COMPLETE_SYNCH_CALL)) {
            this.createSendEvent(message, source, previousSentEvent);
            this.createReceiveEvent(message, target, previousReceiveEvent);
            message.setMessageSort(MessageSort.SYNCH_CALL_LITERAL);
        } else if (ElementUtil.isTypeOf(elementType, (IElementType)UMLElementTypes.FOUND_ASYNCH_CALL)) {
            this.createReceiveEvent(message, target, previousReceiveEvent);
            message.setMessageSort(MessageSort.ASYNCH_CALL_LITERAL);
        } else if (ElementUtil.isTypeOf(elementType, (IElementType)UMLElementTypes.FOUND_ASYNCH_SIGNAL)) {
            this.createReceiveEvent(message, target, previousReceiveEvent);
            message.setMessageSort(MessageSort.ASYNCH_SIGNAL_LITERAL);
        } else if (ElementUtil.isTypeOf(elementType, (IElementType)UMLElementTypes.FOUND_CREATE_MESSAGE)) {
            this.createReceiveEvent(message, target, previousReceiveEvent);
            message.setMessageSort(MessageSort.CREATE_MESSAGE_LITERAL);
        } else if (ElementUtil.isTypeOf(elementType, (IElementType)UMLElementTypes.FOUND_DELETE_MESSAGE)) {
            this.createDestroyReceiveEvent(message, target);
            message.setMessageSort(MessageSort.DELETE_MESSAGE_LITERAL);
        } else if (ElementUtil.isTypeOf(elementType, (IElementType)UMLElementTypes.FOUND_REPLY)) {
            this.createReceiveEvent(message, target, previousReceiveEvent);
            message.setMessageSort(MessageSort.REPLY_LITERAL);
        } else if (ElementUtil.isTypeOf(elementType, (IElementType)UMLElementTypes.LOST_ASYNCH_CALL)) {
            this.createSendEvent(message, source, previousSentEvent);
            message.setMessageSort(MessageSort.ASYNCH_CALL_LITERAL);
        } else if (ElementUtil.isTypeOf(elementType, (IElementType)UMLElementTypes.LOST_ASYNCH_SIGNAL)) {
            this.createSendEvent(message, source, previousSentEvent);
            message.setMessageSort(MessageSort.ASYNCH_SIGNAL_LITERAL);
        } else if (ElementUtil.isTypeOf(elementType, (IElementType)UMLElementTypes.LOST_CREATE_MESSAGE)) {
            this.createSendEvent(message, source, previousSentEvent);
            message.setMessageSort(MessageSort.CREATE_MESSAGE_LITERAL);
        } else if (ElementUtil.isTypeOf(elementType, (IElementType)UMLElementTypes.LOST_DELETE_MESSAGE)) {
            this.createSendEvent(message, source, previousSentEvent);
            message.setMessageSort(MessageSort.DELETE_MESSAGE_LITERAL);
        } else if (ElementUtil.isTypeOf(elementType, (IElementType)UMLElementTypes.LOST_REPLY)) {
            this.createSendEvent(message, source, previousSentEvent);
            message.setMessageSort(MessageSort.REPLY_LITERAL);
        }
        if (toReplacebyMessageSent != null) {
            if (toReplacebyMessageSent.getExecution() != null) {
                if (toReplacebyMessageSent.getExecution().getStart().equals(toReplacebyMessageSent)) {
                    toReplacebyMessageSent.getExecution().setStart((OccurrenceSpecification)message.getSendEvent());
                } else {
                    toReplacebyMessageSent.getExecution().setFinish((OccurrenceSpecification)message.getSendEvent());
                }
            }
            if (toReplacebyMessageReceive != null) {
                ICommand destroyCommand;
                DestroyElementRequest destroyRequest;
                IElementEditService provider;
                if (toReplacebyMessageReceive.getOwner() != null && (provider = ElementEditServiceUtils.getCommandProvider((EObject)toReplacebyMessageSent)) != null) {
                    destroyRequest = new DestroyElementRequest((EObject)toReplacebyMessageSent, false);
                    destroyCommand = provider.getEditCommand((IEditCommandRequest)destroyRequest);
                    destroyCommand.execute((IProgressMonitor)new NullProgressMonitor(), null);
                }
                if (toReplacebyMessageReceive.getExecution() != null) {
                    if (toReplacebyMessageReceive.getExecution().getStart().equals(toReplacebyMessageReceive)) {
                        toReplacebyMessageReceive.getExecution().setStart((OccurrenceSpecification)message.getReceiveEvent());
                    } else {
                        toReplacebyMessageReceive.getExecution().setFinish((OccurrenceSpecification)message.getReceiveEvent());
                    }
                }
                if (toReplacebyMessageReceive.getOwner() != null && (provider = ElementEditServiceUtils.getCommandProvider((EObject)toReplacebyMessageReceive)) != null) {
                    destroyRequest = new DestroyElementRequest((EObject)toReplacebyMessageReceive, false);
                    destroyCommand = provider.getEditCommand((IEditCommandRequest)destroyRequest);
                    destroyCommand.execute((IProgressMonitor)new NullProgressMonitor(), null);
                }
            }
        }
        return CommandResult.newOKCommandResult((Object)message);
    }

    private void createDestroyReceiveEvent(Message message, Element source) {
        MessageEnd sendEvent = ConfigureMessageEventCommand.createDestroyMessageEnd(message, (Lifeline)source);
        sendEvent.setName(String.valueOf(message.getName()) + "ReceiveDestroyEvent");
        message.setReceiveEvent(sendEvent);
    }

    private void createSendEvent(Message message, Element source, MessageEnd previous) {
        if (source instanceof Gate) {
            message.setSendEvent((MessageEnd)((Gate)source));
        } else if (source instanceof ExecutionSpecification) {
            if (((ExecutionSpecification)source).getCovereds().size() > 0) {
                Lifeline lifeline = (Lifeline)((ExecutionSpecification)source).getCovereds().get(0);
                MessageEnd sendEvent = ConfigureMessageEventCommand.createMessageEnd(message, lifeline, previous);
                sendEvent.setName(String.valueOf(message.getName()) + "SendEvent");
                message.setSendEvent(sendEvent);
            }
        } else if (source instanceof Lifeline) {
            MessageEnd sendEvent = ConfigureMessageEventCommand.createMessageEnd(message, (Lifeline)source, previous);
            sendEvent.setName(String.valueOf(message.getName()) + "SendEvent");
            message.setSendEvent(sendEvent);
        }
    }

    private void createReceiveEvent(Message message, Element target, MessageEnd previous) {
        if (target instanceof Gate) {
            message.setReceiveEvent((MessageEnd)((Gate)target));
        } else if (target instanceof ExecutionSpecification) {
            if (((ExecutionSpecification)target).getCovereds().size() > 0) {
                Lifeline lifeline = (Lifeline)((ExecutionSpecification)target).getCovereds().get(0);
                MessageEnd receiveEvent = ConfigureMessageEventCommand.createMessageEnd(message, lifeline, previous);
                receiveEvent.setName(String.valueOf(message.getName()) + "ReceiveEvent");
                message.setReceiveEvent(receiveEvent);
            }
        } else if (target instanceof Lifeline) {
            MessageEnd receiveEvent = ConfigureMessageEventCommand.createMessageEnd(message, (Lifeline)target, previous);
            receiveEvent.setName(String.valueOf(message.getName()) + "ReceiveEvent");
            message.setReceiveEvent(receiveEvent);
        }
    }
}

