/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.ui.emf.utils;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.papyrus.emf.facet.custom.core.ICustomizationManager;
import org.eclipse.papyrus.infra.core.language.ILanguageService;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.emf.utils.HistoryUtil;
import org.eclipse.papyrus.infra.ui.emf.providers.EMFGraphicalContentProvider;
import org.eclipse.papyrus.infra.ui.emf.providers.strategy.ContainmentBrowseStrategy;
import org.eclipse.papyrus.infra.ui.emf.providers.strategy.SemanticEMFContentProvider;
import org.eclipse.papyrus.infra.ui.internal.emf.Activator;
import org.eclipse.papyrus.infra.ui.providers.ISemanticContentProviderFactory;
import org.eclipse.papyrus.infra.widgets.strategy.ProviderBasedBrowseStrategy;
import org.eclipse.papyrus.infra.widgets.strategy.StrategyBasedContentProvider;
import org.eclipse.papyrus.infra.widgets.strategy.TreeBrowseStrategy;

public class ProviderHelper {
    public static ICustomizationManager getCustomizationManager() {
        return Activator.getDefault().getCustomizationManager();
    }

    public static EMFGraphicalContentProvider encapsulateProvider(ITreeContentProvider provider, ResourceSet resourceSet, String historyId) {
        ProviderBasedBrowseStrategy browseStrategy = new ProviderBasedBrowseStrategy(provider);
        ContainmentBrowseStrategy revealStrategy = new ContainmentBrowseStrategy(provider);
        StrategyBasedContentProvider strategyProvider = new StrategyBasedContentProvider((TreeBrowseStrategy)browseStrategy, (TreeBrowseStrategy)revealStrategy);
        EMFGraphicalContentProvider graphicalProvider = new EMFGraphicalContentProvider((IStructuredContentProvider)strategyProvider, resourceSet, historyId);
        return graphicalProvider;
    }

    public static EMFGraphicalContentProvider encapsulateProvider(ITreeContentProvider provider, EObject editedEObject, EStructuralFeature feature) {
        ResourceSet rs = editedEObject == null ? null : (editedEObject.eResource() == null ? null : editedEObject.eResource().getResourceSet());
        return ProviderHelper.encapsulateProvider(provider, rs, HistoryUtil.getHistoryID((EObject)editedEObject, (EStructuralFeature)feature));
    }

    public static ISemanticContentProviderFactory getContentProviderFactory(ResourceSet resourceSet) {
        List models = resourceSet instanceof ModelSet ? ILanguageService.getLanguageModels((ModelSet)((ModelSet)resourceSet)) : Collections.emptyList();
        return models.stream().map(m -> (ISemanticContentProviderFactory)m.getAdapter(ISemanticContentProviderFactory.class)).filter(Objects::nonNull).reduce(ISemanticContentProviderFactory::compose).orElse(SemanticEMFContentProvider::new);
    }

    public static ITreeContentProvider getContentProvider(ResourceSet resourceSet) {
        return ProviderHelper.getContentProviderFactory(resourceSet).createSemanticContentProvider(resourceSet);
    }
}

