/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.xtext.completeocl.as2cs;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CompletePackage;
import org.eclipse.ocl.pivot.Constraint;
import org.eclipse.ocl.pivot.DataType;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.Enumeration;
import org.eclipse.ocl.pivot.ExpressionInOCL;
import org.eclipse.ocl.pivot.LanguageExpression;
import org.eclipse.ocl.pivot.Model;
import org.eclipse.ocl.pivot.NamedElement;
import org.eclipse.ocl.pivot.Namespace;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.Parameter;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.internal.manager.PivotMetamodelManager;
import org.eclipse.ocl.pivot.internal.prettyprint.PrettyPrintOptions;
import org.eclipse.ocl.pivot.internal.prettyprint.PrettyPrinter;
import org.eclipse.ocl.pivot.util.Visitable;
import org.eclipse.ocl.pivot.util.Visitor;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.ocl.xtext.base.as2cs.AS2CSConversion;
import org.eclipse.ocl.xtext.base.as2cs.AliasAnalysis;
import org.eclipse.ocl.xtext.base.utilities.BaseCSResource;
import org.eclipse.ocl.xtext.basecs.BaseCSFactory;
import org.eclipse.ocl.xtext.basecs.BaseCSPackage;
import org.eclipse.ocl.xtext.basecs.ConstraintCS;
import org.eclipse.ocl.xtext.basecs.ElementCS;
import org.eclipse.ocl.xtext.basecs.ParameterCS;
import org.eclipse.ocl.xtext.basecs.PathNameCS;
import org.eclipse.ocl.xtext.basecs.RootCS;
import org.eclipse.ocl.xtext.basecs.SpecificationCS;
import org.eclipse.ocl.xtext.basecs.TypedRefCS;
import org.eclipse.ocl.xtext.completeoclcs.ClassifierContextDeclCS;
import org.eclipse.ocl.xtext.completeoclcs.CompleteOCLCSPackage;
import org.eclipse.ocl.xtext.completeoclcs.CompleteOCLDocumentCS;
import org.eclipse.ocl.xtext.completeoclcs.ContextDeclCS;
import org.eclipse.ocl.xtext.completeoclcs.OperationContextDeclCS;
import org.eclipse.ocl.xtext.completeoclcs.PackageDeclarationCS;
import org.eclipse.ocl.xtext.completeoclcs.PathNameDeclCS;
import org.eclipse.ocl.xtext.completeoclcs.PropertyContextDeclCS;
import org.eclipse.ocl.xtext.essentialocl.as2cs.EssentialOCLDeclarationVisitor;
import org.eclipse.ocl.xtext.essentialoclcs.EssentialOCLCSFactory;
import org.eclipse.ocl.xtext.essentialoclcs.EssentialOCLCSPackage;
import org.eclipse.ocl.xtext.essentialoclcs.ExpSpecificationCS;

public class CompleteOCLDeclarationVisitor
extends EssentialOCLDeclarationVisitor {
    public CompleteOCLDeclarationVisitor(@NonNull AS2CSConversion context) {
        super(context);
    }

    protected TypedRefCS convertTypeRef(@NonNull TypedElement object) {
        Type type = object.getType();
        if (type == null) {
            return null;
        }
        TypedRefCS typeRef = (TypedRefCS)((AS2CSConversion)this.context).visitReference(TypedRefCS.class, (EObject)type, null);
        return typeRef;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected void gatherPackages(@NonNull List<@NonNull Package> allPackages, @NonNull List<@NonNull Package> nestedPackages) {
        allPackages.addAll(nestedPackages);
        for (Package nestedPackage : nestedPackages) {
            @NonNull List nestedNestedPackages = ClassUtil.nullFree((List)nestedPackage.getOwnedPackages());
            assert (nestedNestedPackages != null);
            this.gatherPackages(allPackages, nestedNestedPackages);
        }
    }

    protected void importPackage(@NonNull Package aPackage) {
        ((AS2CSConversion)this.context).importNamespace((Namespace)aPackage, null);
        Package nestingPackage = null;
        while ((nestingPackage = aPackage.getOwningPackage()) != null) {
            aPackage = nestingPackage;
            ((AS2CSConversion)this.context).importNamespace((Namespace)aPackage, null);
        }
    }

    public void postProcess(@NonNull BaseCSResource csResource, @NonNull Map<@NonNull Namespace, @NonNull List<@NonNull String>> importedNamespaces) {
        EObject eObject = (EObject)csResource.getContents().get(0);
        if (eObject instanceof CompleteOCLDocumentCS) {
            ((AS2CSConversion)this.context).createImports((RootCS)((CompleteOCLDocumentCS)eObject), importedNamespaces);
        }
    }

    protected void refreshPathNamedElement(@NonNull PathNameDeclCS csDecl, @NonNull NamedElement namedElement, Namespace scope) {
        PathNameCS csPathName = csDecl.getOwnedPathName();
        if (csPathName == null) {
            csPathName = BaseCSFactory.eINSTANCE.createPathNameCS();
            assert (csPathName != null);
            csDecl.setOwnedPathName(csPathName);
        }
        ((AS2CSConversion)this.context).refreshPathName(csPathName, (Element)namedElement, scope);
    }

    public ElementCS visitClass(@NonNull Class object) {
        List ownedInvariant = object.getOwnedInvariants();
        if (ownedInvariant.size() <= 0) {
            return null;
        }
        Package objectPackage = object.getOwningPackage();
        ClassifierContextDeclCS csContext = (ClassifierContextDeclCS)((AS2CSConversion)this.context).refreshElement(ClassifierContextDeclCS.class, CompleteOCLCSPackage.Literals.CLASSIFIER_CONTEXT_DECL_CS, (Element)object);
        if (objectPackage != null) {
            this.refreshPathNamedElement(csContext, (NamedElement)object, (Namespace)objectPackage);
            this.importPackage(objectPackage);
            ((AS2CSConversion)this.context).refreshList(csContext.getOwnedInvariants(), ((AS2CSConversion)this.context).visitDeclarations(ConstraintCS.class, ownedInvariant, null));
        }
        return csContext;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public ElementCS visitConstraint(@NonNull Constraint object) {
        ConstraintCS csElement = (ConstraintCS)((AS2CSConversion)this.context).refreshNamedElement(ConstraintCS.class, BaseCSPackage.Literals.CONSTRAINT_CS, (NamedElement)object);
        Namespace namespace = PivotUtil.getNamespace((EObject)object);
        LanguageExpression specification = object.getOwnedSpecification();
        if (specification != null && namespace != null) {
            AliasAnalysis adapter;
            specification.accept((Visitor)this);
            ExpSpecificationCS csSpec = (ExpSpecificationCS)((AS2CSConversion)this.context).refreshElement(ExpSpecificationCS.class, EssentialOCLCSPackage.Literals.EXP_SPECIFICATION_CS, (Element)specification);
            csElement.setOwnedSpecification((SpecificationCS)csSpec);
            PivotMetamodelManager metamodelManager = ((AS2CSConversion)this.context).getMetamodelManager();
            PrettyPrintOptions.Global prettyPrintOptions = PrettyPrinter.createOptions(null);
            @NonNull @NonNull ArrayList newArrayList = Lists.newArrayList((Object[])new String[]{"body", "context", "def", "endpackage", "inv", "package", "post", "inv"});
            prettyPrintOptions.addReservedNames((Iterable)newArrayList);
            prettyPrintOptions.setEnvironmentFactory((EnvironmentFactory)metamodelManager.getEnvironmentFactory());
            prettyPrintOptions.setLinelength(80);
            Resource resource = object.eResource();
            AliasAnalysis aliasAnalysis = adapter = resource != null ? AliasAnalysis.getAdapter((Resource)resource) : null;
            if (adapter != null) {
                for (CompletePackage aliased : adapter.getAliases()) {
                    String alias;
                    Package primary = aliased.getPrimaryPackage();
                    if (primary == null || (alias = adapter.getAlias((EObject)primary, null)) == null) continue;
                    prettyPrintOptions.addAliases((Namespace)primary, alias);
                }
            }
            String expr = PrettyPrinter.print((Element)specification, (PrettyPrintOptions)prettyPrintOptions);
            csSpec.setExprString("\t" + expr.trim().replaceAll("\\r", "").replaceAll("\\n", "\n\t\t"));
        } else {
            ExpSpecificationCS csSpec = EssentialOCLCSFactory.eINSTANCE.createExpSpecificationCS();
            csElement.setOwnedSpecification((SpecificationCS)csSpec);
            csSpec.setExprString("\tnull");
        }
        return csElement;
    }

    public ElementCS visitDataType(@NonNull DataType object) {
        return this.visitType((Type)object);
    }

    public ElementCS visitEnumeration(@NonNull Enumeration object) {
        return this.visitType((Type)object);
    }

    public ElementCS visitExpressionInOCL(@NonNull ExpressionInOCL object) {
        this.safeVisit((Visitable)object.getOwnedBody());
        return super.visitExpressionInOCL(object);
    }

    public ElementCS visitOperation(@NonNull Operation object) {
        if (object.getOwnedPreconditions().size() <= 0 && object.getBodyExpression() == null && object.getOwnedPostconditions().size() <= 0) {
            return null;
        }
        Class modelType = object.getOwningClass();
        Package modelPackage = modelType.getOwningPackage();
        Class savedScope = ((AS2CSConversion)this.context).setScope(modelType);
        OperationContextDeclCS csContext = (OperationContextDeclCS)((AS2CSConversion)this.context).refreshElement(OperationContextDeclCS.class, CompleteOCLCSPackage.Literals.OPERATION_CONTEXT_DECL_CS, (Element)object);
        this.refreshPathNamedElement(csContext, (NamedElement)object, (Namespace)modelPackage);
        csContext.setOwnedType(this.convertTypeRef((TypedElement)object));
        Package owningPackage = object.getOwningClass().getOwningPackage();
        if (owningPackage != null) {
            this.importPackage(owningPackage);
        }
        ((AS2CSConversion)this.context).refreshList(csContext.getOwnedParameters(), ((AS2CSConversion)this.context).visitDeclarations(ParameterCS.class, object.getOwnedParameters(), null));
        ((AS2CSConversion)this.context).refreshList(csContext.getOwnedPreconditions(), ((AS2CSConversion)this.context).visitDeclarations(ConstraintCS.class, object.getOwnedPreconditions(), null));
        ((AS2CSConversion)this.context).refreshList(csContext.getOwnedPostconditions(), ((AS2CSConversion)this.context).visitDeclarations(ConstraintCS.class, object.getOwnedPostconditions(), null));
        ((AS2CSConversion)this.context).refreshList(csContext.getOwnedBodies(), ((AS2CSConversion)this.context).visitDeclarationAsList(ExpSpecificationCS.class, (EObject)object.getBodyExpression()));
        ((AS2CSConversion)this.context).setScope(savedScope);
        return csContext;
    }

    public ElementCS visitPackage(@NonNull Package object) {
        PackageDeclarationCS csElement = null;
        assert (object.eContainer() != null);
        ArrayList<@NonNull ContextDeclCS> contexts = new ArrayList<ContextDeclCS>();
        for (Class type : ClassUtil.nullFree((List)object.getOwnedClasses())) {
            ClassifierContextDeclCS classifierContext = (ClassifierContextDeclCS)((AS2CSConversion)this.context).visitDeclaration(ClassifierContextDeclCS.class, (EObject)type);
            if (classifierContext != null) {
                contexts.add(classifierContext);
            }
            for (Operation operation : ClassUtil.nullFree((List)type.getOwnedOperations())) {
                OperationContextDeclCS operationContext = (OperationContextDeclCS)((AS2CSConversion)this.context).visitDeclaration(OperationContextDeclCS.class, (EObject)operation);
                if (operationContext == null) continue;
                contexts.add(operationContext);
            }
            for (Property property : ClassUtil.nullFree((List)type.getOwnedProperties())) {
                PropertyContextDeclCS propertyContext = (PropertyContextDeclCS)((AS2CSConversion)this.context).visitDeclaration(PropertyContextDeclCS.class, (EObject)property);
                if (propertyContext == null) continue;
                contexts.add(propertyContext);
            }
        }
        if (contexts.size() > 0) {
            PackageDeclarationCS csPackage = (PackageDeclarationCS)((AS2CSConversion)this.context).refreshElement(PackageDeclarationCS.class, CompleteOCLCSPackage.Literals.PACKAGE_DECLARATION_CS, (Element)object);
            this.refreshPathNamedElement(csPackage, (NamedElement)object, PivotUtil.getContainingNamespace((EObject)object));
            this.importPackage(object);
            ((AS2CSConversion)this.context).refreshList(csPackage.getOwnedContexts(), contexts);
            csElement = csPackage;
        }
        return csElement;
    }

    public ElementCS visitParameter(@NonNull Parameter object) {
        ParameterCS csElement = (ParameterCS)((AS2CSConversion)this.context).refreshNamedElement(ParameterCS.class, BaseCSPackage.Literals.PARAMETER_CS, (NamedElement)object);
        csElement.setOwnedType(this.convertTypeRef((TypedElement)object));
        return csElement;
    }

    public ElementCS visitProperty(@NonNull Property object) {
        if (object.getOwnedExpression() == null) {
            return null;
        }
        Class modelType = object.getOwningClass();
        Package modelPackage = modelType.getOwningPackage();
        Class savedScope = ((AS2CSConversion)this.context).setScope(modelType);
        PropertyContextDeclCS csContext = (PropertyContextDeclCS)((AS2CSConversion)this.context).refreshElement(PropertyContextDeclCS.class, CompleteOCLCSPackage.Literals.PROPERTY_CONTEXT_DECL_CS, (Element)object);
        if (modelPackage != null) {
            this.refreshPathNamedElement(csContext, (NamedElement)object, (Namespace)modelPackage);
            csContext.setOwnedType(this.convertTypeRef((TypedElement)object));
            this.importPackage(modelPackage);
            ((AS2CSConversion)this.context).refreshList(csContext.getOwnedDefaultExpressions(), ((AS2CSConversion)this.context).visitDeclarationAsList(ExpSpecificationCS.class, (EObject)object.getOwnedExpression()));
            ((AS2CSConversion)this.context).setScope(savedScope);
        }
        return csContext;
    }

    protected <T extends ConstraintCS> void refreshPropertyConstraints(@NonNull java.lang.Class<T> csConstraintClass, @NonNull List<@NonNull ? super T> csPropertyConstraints, Property object) {
        ConstraintCS csConstraint = null;
        LanguageExpression defaultExpression = object.getOwnedExpression();
        if (defaultExpression != null) {
            csConstraint = (ConstraintCS)((AS2CSConversion)this.context).visitDeclaration(csConstraintClass, (EObject)defaultExpression);
        }
        if (csConstraint != null) {
            csConstraint.setStereotype("derivation");
            ((AS2CSConversion)this.context).refreshList(csPropertyConstraints, Collections.singletonList(csConstraint));
        } else {
            csPropertyConstraints.clear();
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public ElementCS visitModel(@NonNull Model object) {
        assert (object.eContainer() == null);
        CompleteOCLDocumentCS csDocument = (CompleteOCLDocumentCS)((AS2CSConversion)this.context).refreshElement(CompleteOCLDocumentCS.class, CompleteOCLCSPackage.Literals.COMPLETE_OCL_DOCUMENT_CS, (Element)object);
        ArrayList<@NonNull Package> allPackages = new ArrayList<Package>();
        @NonNull List nestedPackages = ClassUtil.nullFree((List)object.getOwnedPackages());
        assert (nestedPackages != null);
        this.gatherPackages(allPackages, nestedPackages);
        ((AS2CSConversion)this.context).refreshList(csDocument.getOwnedPackages(), ((AS2CSConversion)this.context).visitDeclarations(PackageDeclarationCS.class, allPackages, null));
        CompleteOCLDocumentCS csElement = csDocument;
        return csElement;
    }

    public ElementCS visitType(@NonNull Type object) {
        return null;
    }
}

