/*******************************************************************************
 * Copyright (c) 2008, 2016 Zeligsoft Inc., and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   Zeligsoft - Initial API and implementation
 *******************************************************************************/
package org.eclipse.ocl.types.operations;

import org.eclipse.emf.common.util.EList;

import org.eclipse.ocl.types.VoidType;

/**
 * <!-- begin-user-doc -->
 * A static utility class that provides operations related to '<em><b>Void Type</b></em>' model objects.
 * @since 1.3
 * <!-- end-user-doc -->
 *
 * <p>
 * The following operations are supported:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.ocl.utilities.PredefinedType#getName() <em>Get Name</em>}</li>
 *   <li>{@link org.eclipse.ocl.utilities.PredefinedType#oclOperations() <em>Ocl Operations</em>}</li>
 * </ul>
 *
 * @generated
 */
public class VoidTypeOperations {

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected VoidTypeOperations() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public static <O> String getName(VoidType<O> voidType) {
		throw new UnsupportedOperationException();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public static <O> EList<O> oclOperations(VoidType<O> voidType) {
		throw new UnsupportedOperationException();
	}

} // VoidTypeOperations