/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otequinox;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.internal.runtime.Log;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.log.ExtendedLogReaderService;
import org.eclipse.equinox.log.ExtendedLogService;
import org.eclipse.equinox.log.LogFilter;
import org.eclipse.equinox.log.Logger;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.objectteams.internal.osgi.weaving.AspectBinding;
import org.eclipse.objectteams.internal.osgi.weaving.AspectBindingRegistry;
import org.eclipse.objectteams.internal.osgi.weaving.AspectPermissionManager;
import org.eclipse.objectteams.internal.osgi.weaving.OTWeavingHook;
import org.eclipse.objectteams.otequinox.IAspectRegistry;
import org.eclipse.objectteams.otre.ClassLoaderAccess;
import org.objectteams.Team;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.hooks.weaving.WeavingHook;
import org.osgi.framework.hooks.weaving.WovenClassListener;
import org.osgi.service.log.LogEntry;
import org.osgi.service.log.LogListener;
import org.osgi.util.tracker.ServiceTracker;

@NonNullByDefault
public class TransformerPlugin
implements BundleActivator,
IAspectRegistry {
    private static final String OTEQUINOX_AGENT_JAR_FILENAME = "otequinoxAgent.jar";
    private static final String OTEQUINOX_LOGGER_NAME = "org.eclipse.objectteams.otequinox.logger";
    @Nullable
    private static InitializedPlugin plugin;
    @Nullable
    static BundleContext context;
    private static List<IStatus> pendingLogEntries;
    @Nullable
    private static URL agentURL;
    public static int WARN_LEVEL;

    static {
        pendingLogEntries = new ArrayList<IStatus>();
        WARN_LEVEL = 4;
        String level = System.getProperty("otequinox.debug");
        if (level != null) {
            WARN_LEVEL = (level = level.toUpperCase()).equals("OK") ? 0 : (level.equals("INFO") ? 1 : (level.startsWith("WARN") ? 2 : (level.startsWith("ERR") ? 4 : 0)));
        }
    }

    private static InitializedPlugin plugin() {
        InitializedPlugin plugin = TransformerPlugin.plugin;
        if (plugin == null) {
            throw TransformerPlugin.notInitialized();
        }
        return plugin;
    }

    public static Bundle getBundle() {
        BundleContext context = TransformerPlugin.context;
        if (context != null) {
            return context.getBundle();
        }
        throw new IllegalStateException("TransformerPlugin has not been started");
    }

    public void start(final BundleContext bundleContext) throws Exception {
        context = bundleContext;
        if (!"false".equals(System.getProperty("ot.equinox"))) {
            this.OTREInit();
            final OTWeavingHook otWeavingHook = new OTWeavingHook();
            bundleContext.registerService(new String[]{WeavingHook.class.getName(), WovenClassListener.class.getName()}, (Object)otWeavingHook, null);
            try {
                ServiceReference reference = bundleContext.getServiceReference(IExtensionRegistry.class);
                if (reference != null) {
                    otWeavingHook.activate(bundleContext, (ServiceReference<IExtensionRegistry>)reference);
                } else {
                    bundleContext.addServiceListener(new ServiceListener(){

                        public void serviceChanged(ServiceEvent event) {
                            if (event.getType() == 1) {
                                otWeavingHook.activate(bundleContext, (ServiceReference<IExtensionRegistry>)bundleContext.getServiceReference(IExtensionRegistry.class));
                            }
                        }
                    }, "(objectclass=" + IExtensionRegistry.class.getName() + ")");
                }
            }
            catch (InvalidSyntaxException ex) {
                TransformerPlugin.log(ex, "Failed to register service listener");
            }
        }
        agentURL = bundleContext.getBundle().getEntry("/otequinoxAgent.jar");
        TransformerPlugin.log(1, "agentURL=" + agentURL);
    }

    private static ILog acquireLog(BundleContext bundleContext) {
        ServiceTracker tracker = new ServiceTracker(bundleContext, ExtendedLogService.class, null);
        tracker.open();
        ExtendedLogService logService = (ExtendedLogService)tracker.getService();
        Bundle bundle = bundleContext.getBundle();
        Logger logger = logService.getLogger(bundle, OTEQUINOX_LOGGER_NAME);
        Log result = new Log(bundle, logger);
        ServiceTracker logReaderTracker = new ServiceTracker(bundleContext, ExtendedLogReaderService.class.getName(), null);
        logReaderTracker.open();
        ExtendedLogReaderService logReader = (ExtendedLogReaderService)logReaderTracker.getService();
        final Logger equinoxLogger = logService.getLogger(bundle, "org.eclipse.equinox.logger");
        logReader.addLogListener(new LogListener(){

            @NonNullByDefault(value=false)
            public void logged(LogEntry entry) {
                equinoxLogger.log(entry.getLevel(), entry.getMessage(), entry.getException());
            }
        }, new LogFilter(){

            @NonNullByDefault(value=false)
            public boolean isLoggable(Bundle bundle, String loggerName, int logLevel) {
                return TransformerPlugin.OTEQUINOX_LOGGER_NAME.equals(loggerName);
            }
        });
        return result;
    }

    private void OTREInit() {
        System.setProperty("ot.equinox", "true");
        try {
            ClassLoaderAccess.setLoadClass((Method)Bundle.class.getMethod("loadClass", String.class));
            ClassLoaderAccess.setGetResource((Method)Bundle.class.getMethod("getResource", String.class));
        }
        catch (NoSuchMethodException | SecurityException e) {
            TransformerPlugin.log(e, "Failed to wire an OSGi class into the OTRE");
        }
    }

    public void stop(@Nullable BundleContext bundleContext) throws Exception {
        plugin = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void log(Throwable ex, String msg) {
        msg = "OT/Equinox: " + msg;
        Status status = new Status(4, "org.eclipse.objectteams.otequinox", msg, ex);
        InitializedPlugin plugin = TransformerPlugin.plugin;
        if (plugin != null) {
            plugin.log.log((IStatus)status);
            return;
        }
        System.err.println(msg);
        ex.printStackTrace();
        Class<TransformerPlugin> clazz = TransformerPlugin.class;
        synchronized (TransformerPlugin.class) {
            pendingLogEntries.add((IStatus)status);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    public static void log(int status, String msg) {
        if (status >= WARN_LEVEL) {
            TransformerPlugin.doLog(status, msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void doLog(int level, String msg) {
        try {
            Status status = new Status(level, "org.eclipse.objectteams.otequinox", "OT/Equinox: " + msg);
            InitializedPlugin plugin = TransformerPlugin.plugin;
            if (plugin != null) {
                plugin.log.log((IStatus)status);
                return;
            }
            Class<TransformerPlugin> clazz = TransformerPlugin.class;
            synchronized (TransformerPlugin.class) {
                pendingLogEntries.add((IStatus)status);
                // ** MonitorExit[var4_5] (shouldn't be in output)
                return;
            }
        }
        catch (NoClassDefFoundError err) {
            if (level < WARN_LEVEL) return;
            System.out.println(">> OT/Equinox: " + msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void flushLog() {
        Class<TransformerPlugin> clazz = TransformerPlugin.class;
        synchronized (TransformerPlugin.class) {
            List<IStatus> copy = pendingLogEntries;
            pendingLogEntries = new ArrayList<IStatus>();
            // ** MonitorExit[var1] (shouldn't be in output)
            for (IStatus status : copy) {
                InitializedPlugin plugin = TransformerPlugin.plugin;
                if (plugin != null) {
                    plugin.log.log(status);
                    continue;
                }
                if (status.getCode() == 4) {
                    System.err.println(status.getMessage());
                    continue;
                }
                System.out.println(status.getMessage());
            }
            return;
        }
    }

    public static void initialize(BundleContext bundleContext, AspectBindingRegistry aspectBindingRegistry, @Nullable AspectPermissionManager permissionManager) {
        plugin = new InitializedPlugin(aspectBindingRegistry, permissionManager, TransformerPlugin.acquireLog(bundleContext));
    }

    public static TransformerPlugin getDefault() {
        return TransformerPlugin.plugin();
    }

    public static synchronized void registerTeamInstance(Team instance) {
        TransformerPlugin.plugin().teamInstances.add(instance);
    }

    public static synchronized void getTeamInstances(List<Team> list) {
        list.addAll(TransformerPlugin.plugin().teamInstances);
    }

    @Override
    public String[] getAdaptingAspectPlugins(Bundle basePlugin) {
        return this.getAdaptingAspectPlugins(basePlugin.getSymbolicName());
    }

    public String[] getAdaptingAspectPlugins(@Nullable String id) {
        throw TransformerPlugin.notInitialized();
    }

    @Override
    public boolean isOTDT() {
        throw TransformerPlugin.notInitialized();
    }

    @Override
    public boolean isAdaptedBasePlugin(@Nullable String baseBundleName) {
        throw TransformerPlugin.notInitialized();
    }

    @Override
    @Nullable
    public String[] getAdaptedBasePlugins(Bundle aspectBundle) {
        throw TransformerPlugin.notInitialized();
    }

    @Override
    public boolean hasInternalTeams(Bundle bundle) {
        return false;
    }

    @Override
    public boolean isDeniedAspectPlugin(String symbolicName) {
        throw TransformerPlugin.notInitialized();
    }

    static IllegalStateException notInitialized() {
        return new IllegalStateException("TransformerPlugin has not been initialized");
    }

    @Nullable
    public static String getOtequinoxAgentPath() {
        if (agentURL != null) {
            try {
                return new File(FileLocator.toFileURL((URL)agentURL).getFile()).getAbsolutePath();
            }
            catch (IOException e) {
                TransformerPlugin.log(new IllegalStateException(e), "Failed to intialize location of otequinoxAgent.jar");
            }
        } else {
            TransformerPlugin.log(4, "Failed to intialize location of otequinoxAgent.jar");
        }
        return null;
    }

    static class InitializedPlugin
    extends TransformerPlugin {
        AspectBindingRegistry aspectBindingRegistry;
        @Nullable
        AspectPermissionManager aspectPermissionManager;
        ILog log;
        List<Team> teamInstances = new ArrayList<Team>();

        public InitializedPlugin(AspectBindingRegistry aspectBindingRegistry, @Nullable AspectPermissionManager permissionManager, ILog log) {
            this.aspectBindingRegistry = aspectBindingRegistry;
            this.aspectPermissionManager = permissionManager;
            this.log = log;
        }

        @Override
        public boolean isDeniedAspectPlugin(String symbolicName) {
            AspectPermissionManager manager = this.aspectPermissionManager;
            if (manager != null) {
                return manager.isDeniedAspectPlugin(symbolicName);
            }
            return false;
        }

        @Override
        public boolean isOTDT() {
            return this.aspectBindingRegistry.isOTDT();
        }

        @Override
        public boolean isAdaptedBasePlugin(@Nullable String baseBundleName) {
            return this.aspectBindingRegistry.isAdaptedBasePlugin(baseBundleName);
        }

        @Override
        @Nullable
        public String[] getAdaptedBasePlugins(Bundle aspectBundle) {
            return this.aspectBindingRegistry.getAdaptedBasePlugins(aspectBundle);
        }

        @Override
        public String[] getAdaptingAspectPlugins(@Nullable String id) {
            List<AspectBinding> aspectBindings = this.aspectBindingRegistry.getAdaptingAspectBindings(id);
            if (aspectBindings == null) {
                return new String[0];
            }
            String[] result = new String[aspectBindings.size()];
            int i = 0;
            while (i < result.length) {
                result[i] = aspectBindings.get((int)i).aspectPlugin;
                ++i;
            }
            return result;
        }
    }
}

