/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.github.core;

import java.util.Date;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.data.TaskMapper;

public abstract class RepositoryConnector
extends AbstractRepositoryConnector {
    public boolean canCreateNewTask(TaskRepository repository) {
        return true;
    }

    public boolean canCreateTaskFromKey(TaskRepository repository) {
        return true;
    }

    public boolean hasTaskChanged(TaskRepository taskRepository, ITask task, TaskData taskData) {
        Date dataDate = this.getTaskMapping(taskData).getModificationDate();
        Date taskDate = task.getModificationDate();
        return dataDate == null || !dataDate.equals(taskDate);
    }

    public void updateRepositoryConfiguration(TaskRepository taskRepository, IProgressMonitor monitor) throws CoreException {
    }

    public String getTaskIdFromTaskUrl(String taskFullUrl) {
        if (taskFullUrl == null || taskFullUrl.length() == 0) {
            return null;
        }
        int lastSlash = taskFullUrl.lastIndexOf(47);
        if (lastSlash != -1 && lastSlash + 1 < taskFullUrl.length()) {
            return taskFullUrl.substring(lastSlash + 1);
        }
        return null;
    }

    public String getTaskUrl(String repositoryUrl, String taskId) {
        return String.valueOf(repositoryUrl) + '/' + taskId;
    }

    public void updateTaskFromTaskData(TaskRepository taskRepository, ITask task, TaskData taskData) {
        if (!taskData.isNew()) {
            task.setUrl(this.getTaskUrl(taskRepository.getUrl(), taskData.getTaskId()));
        }
        new TaskMapper(taskData).applyTo(task);
    }
}

