/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.kdm.source.extension.ui.adapters;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterFactoryImpl;
import org.eclipse.gmt.modisco.infra.common.core.logging.MoDiscoLogger;
import org.eclipse.modisco.kdm.source.extension.ui.Activator;
import org.eclipse.modisco.kdm.source.extension.ui.adapters.SourceAccessAdapter;
import org.eclipse.modisco.kdm.source.extension.ui.interfaces.RevealingStrategy;
import org.eclipse.modisco.kdm.source.extension.ui.interfaces.SourceStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceAccessAdapterFactory
extends AdapterFactoryImpl {
    private static List<SourceStrategy> listSourceStrategy;
    private static List<RevealingStrategy> listRevealingStrategy;

    protected Adapter createAdapter(Notifier target) {
        SourceAccessAdapter adapter = null;
        if (listSourceStrategy == null) {
            SourceAccessAdapterFactory.initializeSourceStrategy();
        }
        SourceStrategy sourceStrategy = SourceAccessAdapterFactory.findSourceStrategy(target);
        if (listRevealingStrategy == null) {
            SourceAccessAdapterFactory.initializeRevealingStrategy();
        }
        RevealingStrategy revealingStrategy = SourceAccessAdapterFactory.findRevealingStrategy(target);
        if (sourceStrategy != null && revealingStrategy != null) {
            adapter = new SourceAccessAdapter(sourceStrategy, revealingStrategy, target);
            this.associate((Adapter)adapter, target);
        }
        return adapter;
    }

    protected static void initializeSourceStrategy() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extPointStrategySource = registry.getExtensionPoint("org.eclipse.modisco.kdm.source.extension.ui.source.strategy");
        IExtension[] iExtensionArray = extPointStrategySource.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension ext = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = ext.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement configElt = iConfigurationElementArray[n4];
                String strategyResolutionClass = configElt.getAttribute("class");
                String metamodelUri = configElt.getAttribute("meta-model");
                if (strategyResolutionClass != null && metamodelUri != null) {
                    try {
                        SourceStrategy sourceStrategy = (SourceStrategy)configElt.createExecutableExtension("class");
                        SourceAccessAdapterFactory.addSourceStrategy(sourceStrategy);
                    }
                    catch (CoreException e) {
                        MoDiscoLogger.logError((Throwable)e, (Plugin)Activator.getDefault());
                    }
                } else {
                    MoDiscoLogger.logError((String)("Metamodel or class in extension: " + ext.getNamespaceIdentifier() + " is null"), (Plugin)Activator.getDefault());
                }
                ++n4;
            }
            ++n2;
        }
    }

    protected static void initializeRevealingStrategy() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extPointStrategyRevealing = registry.getExtensionPoint("org.eclipse.modisco.kdm.source.extension.ui.revealing.strategy");
        IExtension[] iExtensionArray = extPointStrategyRevealing.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension ext = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = ext.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement configElt = iConfigurationElementArray[n4];
                String strategyOpeningClass = configElt.getAttribute("class");
                if (strategyOpeningClass != null) {
                    try {
                        RevealingStrategy revealingStrategy = (RevealingStrategy)configElt.createExecutableExtension("class");
                        SourceAccessAdapterFactory.addRevealingSrategy(revealingStrategy);
                    }
                    catch (CoreException e) {
                        MoDiscoLogger.logError((Throwable)e, (Plugin)Activator.getDefault());
                    }
                }
                ++n4;
            }
            ++n2;
        }
    }

    private static RevealingStrategy findRevealingStrategy(Notifier target) {
        for (RevealingStrategy revealingStrategy : SourceAccessAdapterFactory.getRevealingStrategies()) {
            if (!revealingStrategy.isApplicableTo(target)) continue;
            return revealingStrategy;
        }
        return null;
    }

    private static SourceStrategy findSourceStrategy(Notifier target) {
        for (SourceStrategy srcStrategy : SourceAccessAdapterFactory.getSourceStrategies()) {
            if (!srcStrategy.isApplicableTo(target)) continue;
            return srcStrategy;
        }
        return null;
    }

    private static List<SourceStrategy> getSourceStrategies() {
        if (listSourceStrategy == null) {
            listSourceStrategy = new ArrayList<SourceStrategy>();
        }
        return listSourceStrategy;
    }

    private static void addSourceStrategy(SourceStrategy sourceStrategy) {
        if (!SourceAccessAdapterFactory.getSourceStrategies().contains(sourceStrategy)) {
            SourceAccessAdapterFactory.getSourceStrategies().add(sourceStrategy);
        }
    }

    private static void addRevealingSrategy(RevealingStrategy revealingStrategy) {
        if (!SourceAccessAdapterFactory.getRevealingStrategies().contains(revealingStrategy)) {
            SourceAccessAdapterFactory.getRevealingStrategies().add(revealingStrategy);
        }
    }

    private static List<RevealingStrategy> getRevealingStrategies() {
        if (listRevealingStrategy == null) {
            listRevealingStrategy = new ArrayList<RevealingStrategy>();
        }
        return listRevealingStrategy;
    }
}

