/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.parser.model;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.collect.ArrayLong;
import org.eclipse.mat.parser.model.AbstractArrayImpl;
import org.eclipse.mat.parser.model.ClassImpl;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.model.Field;
import org.eclipse.mat.snapshot.model.IPrimitiveArray;
import org.eclipse.mat.snapshot.model.NamedReference;
import org.eclipse.mat.snapshot.model.PseudoReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrimitiveArrayImpl
extends AbstractArrayImpl
implements IPrimitiveArray {
    private static final long serialVersionUID = 2L;
    private int type;

    public PrimitiveArrayImpl(int objectId, long address, ClassImpl classInstance, int length, int type) {
        super(objectId, address, classInstance, length);
        this.type = type;
    }

    public int getType() {
        return this.type;
    }

    public Class<?> getComponentType() {
        return COMPONENT_TYPE[this.type];
    }

    public Object getValueAt(int index) {
        Object data = this.getValueArray(index, 1);
        return data != null ? Array.get(data, 0) : null;
    }

    public Object getValueArray() {
        try {
            return this.source.getHeapObjectReader().readPrimitiveArrayContent(this, 0, this.getLength());
        }
        catch (SnapshotException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Object getValueArray(int offset, int length) {
        try {
            return this.source.getHeapObjectReader().readPrimitiveArrayContent(this, offset, length);
        }
        catch (SnapshotException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected Field internalGetField(String name) {
        return null;
    }

    @Override
    public ArrayLong getReferences() {
        ArrayLong references = new ArrayLong(1);
        references.add(this.classInstance.getObjectAddress());
        return references;
    }

    public List<NamedReference> getOutboundReferences() {
        ArrayList<NamedReference> references = new ArrayList<NamedReference>(1);
        references.add((NamedReference)new PseudoReference((ISnapshot)this.source, this.classInstance.getObjectAddress(), "<class>"));
        return references;
    }

    @Override
    protected StringBuffer appendFields(StringBuffer buf) {
        return super.appendFields(buf).append(";size=").append(this.getUsedHeapSize());
    }

    @Override
    public long getUsedHeapSize() {
        try {
            return this.getSnapshot().getHeapSize(this.getObjectId());
        }
        catch (SnapshotException snapshotException) {
            return PrimitiveArrayImpl.doGetUsedHeapSize(this.classInstance, this.length, this.type);
        }
    }

    public static long doGetUsedHeapSize(ClassImpl clazz, int length, int type) {
        return PrimitiveArrayImpl.alignUpTo8(2L * clazz.getHeapSizePerInstance() + 4L + (long)length * (long)ELEMENT_SIZE[type]);
    }
}

