/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.outline;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LanguageServiceAccessor;
import org.eclipse.lsp4e.outline.LSSymbolsContentProvider;
import org.eclipse.lsp4e.ui.LSPImages;
import org.eclipse.lsp4e.ui.Messages;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.ICommonLabelProvider;

public class SymbolsLabelProvider
extends LabelProvider
implements ICommonLabelProvider,
DelegatingStyledCellLabelProvider.IStyledLabelProvider {
    private Map<Image, Image[]> overlays = new HashMap<Image, Image[]>();
    private boolean showLocation;
    private boolean showKind;

    public SymbolsLabelProvider() {
        this(false, true);
    }

    public SymbolsLabelProvider(boolean showLocation, boolean showKind) {
        this.showLocation = showLocation;
        this.showKind = showKind;
    }

    public Image getImage(Object element) {
        if (element == null) {
            return null;
        }
        if (element == LSSymbolsContentProvider.COMPUTING) {
            return JFaceResources.getImage((String)"WAITING_JOB");
        }
        if (element instanceof Throwable) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK");
        }
        SymbolInformation symbolInformation = (SymbolInformation)element;
        Image res = LSPImages.imageFromSymbolKind(symbolInformation.getKind());
        IResource resource = LSPEclipseUtils.findResourceFor(symbolInformation.getLocation().getUri());
        if (resource != null) {
            try {
                IDocument doc = LSPEclipseUtils.getDocument(resource);
                int maxSeverity = -1;
                IMarker[] iMarkerArray = resource.findMarkers("org.eclipse.core.resources.problemmarker", true, 0);
                int n = iMarkerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IMarker marker = iMarkerArray[n2];
                    int offset = marker.getAttribute("charStart", -1);
                    if (offset != -1 && offset >= LSPEclipseUtils.toOffset(symbolInformation.getLocation().getRange().getStart(), doc) && offset <= LSPEclipseUtils.toOffset(symbolInformation.getLocation().getRange().getEnd(), doc)) {
                        maxSeverity = Math.max(maxSeverity, marker.getAttribute("severity", -1));
                    }
                    ++n2;
                }
                if (maxSeverity > 0) {
                    return this.getOverlay(res, maxSeverity);
                }
            }
            catch (CoreException | BadLocationException e) {
                LanguageServerPlugin.logError(e);
            }
        }
        return res;
    }

    private Image getOverlay(Image res, int maxSeverity) {
        Image[] currentOverlays;
        if (maxSeverity != 1 && maxSeverity != 2) {
            throw new IllegalArgumentException("Severity " + maxSeverity + " not supported.");
        }
        if (!this.overlays.containsKey(res)) {
            this.overlays.put(res, new Image[2]);
        }
        if ((currentOverlays = this.overlays.get(res))[maxSeverity - 1] == null) {
            String overlayId = null;
            if (maxSeverity == 2) {
                overlayId = "IMG_DEC_FIELD_ERROR";
            } else if (maxSeverity == 1) {
                overlayId = "IMG_DEC_FIELD_WARNING";
            }
            currentOverlays[maxSeverity - 1] = new DecorationOverlayIcon(res, PlatformUI.getWorkbench().getSharedImages().getImageDescriptor(overlayId), 2).createImage();
        }
        return currentOverlays[maxSeverity - 1];
    }

    public String getText(Object element) {
        return this.getStyledText(element).getString();
    }

    public StyledString getStyledText(Object element) {
        if (element == LSSymbolsContentProvider.COMPUTING) {
            return new StyledString(Messages.outline_computingSymbols);
        }
        if (element instanceof Throwable) {
            String message = ((Throwable)element).getMessage();
            if (message == null) {
                message = element.getClass().getName();
            }
            return new StyledString(message);
        }
        if (element instanceof LanguageServiceAccessor.LSPDocumentInfo) {
            return new StyledString(((LanguageServiceAccessor.LSPDocumentInfo)element).getFileUri().getPath());
        }
        StyledString res = new StyledString();
        if (element == null) {
            return res;
        }
        SymbolInformation symbol = (SymbolInformation)element;
        if (symbol.getName() != null) {
            res.append(symbol.getName(), null);
        }
        if (this.showKind) {
            res.append(" :", null);
            res.append(symbol.getKind().toString(), StyledString.DECORATIONS_STYLER);
        }
        if (this.showLocation) {
            URI uri = URI.create(symbol.getLocation().getUri());
            res.append(' ');
            res.append(uri.getPath(), StyledString.QUALIFIER_STYLER);
        }
        return res;
    }

    public void restoreState(IMemento aMemento) {
    }

    public void saveState(IMemento aMemento) {
    }

    public String getDescription(Object anElement) {
        return null;
    }

    public void init(ICommonContentExtensionSite aConfig) {
    }
}

