/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.rename;

import com.google.common.base.Strings;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LanguageServiceAccessor;
import org.eclipse.lsp4e.ui.Messages;
import org.eclipse.lsp4j.RenameParams;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.ITextEditor;

public class LSPRenameHandler
extends AbstractHandler
implements IHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        List<LanguageServiceAccessor.LSPDocumentInfo> infos;
        IEditorPart part = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        if (part instanceof AbstractTextEditor && !(infos = LanguageServiceAccessor.getLSPDocumentInfosFor(LSPEclipseUtils.getDocument((ITextEditor)part), capabilities -> Boolean.TRUE.equals(capabilities.getRenameProvider()))).isEmpty()) {
            LanguageServiceAccessor.LSPDocumentInfo info = (LanguageServiceAccessor.LSPDocumentInfo)infos.iterator().next();
            ISelection sel = ((AbstractTextEditor)part).getSelectionProvider().getSelection();
            if (sel instanceof TextSelection) {
                try {
                    RenameParams params = new RenameParams();
                    params.setPosition(LSPEclipseUtils.toPosition(((TextSelection)sel).getOffset(), info.getDocument()));
                    TextDocumentIdentifier identifier = new TextDocumentIdentifier();
                    identifier.setUri(info.getFileUri().toString());
                    params.setTextDocument(identifier);
                    params.setNewName(this.askNewName(part.getSite().getShell()));
                    if (params.getNewName() != null) {
                        CompletableFuture rename = info.getLanguageClient().getTextDocumentService().rename(params);
                        rename.thenAccept(t -> LSPEclipseUtils.applyWorkspaceEdit(t));
                    }
                }
                catch (BadLocationException e) {
                    LanguageServerPlugin.logError(e);
                }
            }
        }
        return null;
    }

    public boolean isEnabled() {
        IWorkbenchPart part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart();
        if (part instanceof AbstractTextEditor) {
            List<LanguageServiceAccessor.LSPDocumentInfo> infos = LanguageServiceAccessor.getLSPDocumentInfosFor(LSPEclipseUtils.getDocument((ITextEditor)part), capabilities -> Boolean.TRUE.equals(capabilities.getRenameProvider()));
            ISelection selection = ((AbstractTextEditor)part).getSelectionProvider().getSelection();
            return !infos.isEmpty() && !selection.isEmpty() && selection instanceof ITextSelection;
        }
        return false;
    }

    private String askNewName(Shell parentShell) {
        InputDialog dialog = new InputDialog(parentShell, Messages.rename_title, Messages.rename_label, "newName", s -> Strings.isNullOrEmpty((String)s) ? Messages.rename_invalid : null);
        dialog.setBlockOnOpen(true);
        if (dialog.open() == 0) {
            return dialog.getValue();
        }
        return null;
    }
}

