/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.systemtap.ui.ide.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.views.BrowserView;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class TreeExpandCollapseAction
extends Action
implements ISelectionListener {
    private final IWorkbenchWindow fWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
    private IStructuredSelection selection;
    private final BrowserView viewer;

    public TreeExpandCollapseAction(BrowserView view) {
        this.fWindow.getSelectionService().addSelectionListener((ISelectionListener)this);
        this.viewer = view;
    }

    public void selectionChanged(IWorkbenchPart part, ISelection incoming) {
        if (incoming instanceof IStructuredSelection) {
            this.selection = (IStructuredSelection)incoming;
            this.setEnabled(this.selection.size() == 1);
        } else {
            this.setEnabled(false);
        }
    }

    public void dispose() {
        this.fWindow.getSelectionService().removeSelectionListener((ISelectionListener)this);
    }

    public void run() {
        ITreeSelection selection = this.viewer.getViewer().getStructuredSelection();
        Object o = selection.getFirstElement();
        if (o == null) {
            return;
        }
        Object[] objs = this.viewer.getViewer().getVisibleExpandedElements();
        boolean doExpand = true;
        Object[] objectArray = objs;
        int n = objs.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            if (obj == o) {
                doExpand = false;
            }
            ++n2;
        }
        if (doExpand) {
            this.viewer.getViewer().expandToLevel(o, 1);
        } else {
            this.viewer.getViewer().collapseToLevel(o, 1);
        }
    }
}

