/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.oprofile.core.model;

import org.eclipse.linuxtools.internal.oprofile.core.model.OpModelSymbol;

public class OpModelImage {
    public static final int IMAGE_PARSE_ERROR = -1;
    private int count = 0;
    private int depcount = 0;
    private String name = "";
    private OpModelSymbol[] symbols = null;
    private OpModelImage[] dependents = null;
    private String printTabs = "";

    public int getCount() {
        return this.count;
    }

    public int getDepCount() {
        return this.depcount;
    }

    public String getName() {
        return this.name;
    }

    public OpModelSymbol[] getSymbols() {
        return this.symbols;
    }

    public OpModelImage[] getDependents() {
        return this.dependents;
    }

    public boolean hasDependents() {
        return this.dependents != null && this.dependents.length != 0;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public void setDepCount(int depcount) {
        this.depcount = depcount;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setSymbols(OpModelSymbol[] symbols) {
        this.symbols = symbols;
    }

    public void setDependents(OpModelImage[] dependents) {
        this.dependents = dependents;
    }

    public String toString(String tabs) {
        this.printTabs = tabs;
        String s = this.toString();
        this.printTabs = "";
        return s;
    }

    public String toString() {
        int i;
        String s = String.valueOf(this.name) + ", Count: " + this.count + (this.depcount != 0 ? ", Dependent Count: " + this.depcount + "\n" : "\n");
        if (this.symbols != null) {
            i = 0;
            while (i < this.symbols.length) {
                s = String.valueOf(s) + this.printTabs + "Symbols: ";
                s = String.valueOf(s) + this.symbols[i].toString(String.valueOf(this.printTabs) + "\t");
                ++i;
            }
        }
        if (this.dependents != null) {
            i = 0;
            while (i < this.dependents.length) {
                s = String.valueOf(s) + this.printTabs + "Dependent Image: ";
                s = String.valueOf(s) + this.dependents[i].toString(String.valueOf(this.printTabs) + "\t");
                ++i;
            }
        }
        return s;
    }
}

