/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.oprofile.core;

import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.linuxtools.internal.oprofile.core.IOpxmlProvider;
import org.eclipse.linuxtools.internal.oprofile.core.OprofileProperties;
import org.eclipse.linuxtools.internal.oprofile.core.linux.LinuxOpxmlProvider;
import org.eclipse.swt.widgets.Display;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class OprofileCorePlugin
extends Plugin {
    private static final String PLUGIN_ID = "org.eclipse.linuxtools.oprofile.core";
    private static OprofileCorePlugin plugin;
    public static final String DEBUG_PRINT_PREFIX = "DEBUG: ";

    public OprofileCorePlugin() {
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        plugin = null;
    }

    public static OprofileCorePlugin getDefault() {
        return plugin;
    }

    public static String getId() {
        return PLUGIN_ID;
    }

    public IOpxmlProvider getOpxmlProvider() {
        return new LinuxOpxmlProvider();
    }

    public static IStatus createErrorStatus(String errorClassString, Exception e) {
        String statusMessage = OprofileProperties.getString(String.valueOf(errorClassString) + ".error.statusMessage");
        if (e == null) {
            return new Status(4, OprofileCorePlugin.getId(), 0, statusMessage, null);
        }
        return new Status(4, OprofileCorePlugin.getId(), 0, statusMessage, (Throwable)e);
    }

    public static void showErrorDialog(String errorClassString, CoreException ex) {
        String dialogTitle = OprofileProperties.getString(String.valueOf(errorClassString) + ".error.dialog.title");
        String errorMessage = OprofileProperties.getString(String.valueOf(errorClassString) + ".error.dialog.message");
        IStatus status = ex == null ? OprofileCorePlugin.createErrorStatus(errorClassString, null) : ex.getStatus();
        Display.getDefault().syncExec(() -> {
            int n = ErrorDialog.openError(null, (String)dialogTitle, (String)errorMessage, (IStatus)status);
        });
    }

    public static boolean isDebugMode() {
        return Platform.inDebugMode() && Platform.getDebugOption((String)(String.valueOf(OprofileCorePlugin.getId()) + "/debug")) != null;
    }

    public static void log(int severity, String msg) {
        plugin.getLog().log((IStatus)new Status(severity, PLUGIN_ID, 0, msg, null));
    }

    public String getPluginLocation() {
        Bundle bundle = this.getBundle();
        URL locationUrl = FileLocator.find((Bundle)bundle, (IPath)new Path("/"), null);
        URL fileUrl = null;
        try {
            fileUrl = FileLocator.toFileURL((URL)locationUrl);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return fileUrl.getFile();
    }
}

