/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.gcov.preferences;

import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ColorFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.linuxtools.internal.gcov.Activator;
import org.eclipse.linuxtools.internal.gcov.preferences.Messages;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ColorPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final String PREFKEY_COV_USE_COLORS = "PREFKEY_COV_USE_COLORS";
    public static final String PREFKEY_COV_USE_GRADIENT = "PREFKEY_COV_USE_GRADIENT";
    public static final String PREFKEY_COV_MAX_COLOR = "PREFKEY_COV_MAX_COLOR";
    public static final String PREFKEY_COV_MIN_COLOR = "PREFKEY_COV_MIN_COLOR";
    public static final String PREFKEY_COV_0_COLOR = "PREFKEY_COV_0_COLOR";
    private ColorFieldEditor fcfeMax;
    private ColorFieldEditor fcfeMin;
    private ColorFieldEditor fcfeMno;
    private BooleanFieldEditor fbfeUseGradient;
    private BooleanFieldEditor fbfeUseColors;

    public ColorPreferencePage() {
        super(Messages.ColorPreferencePage_Title, AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.linuxtools.gcov.core", (String)"icons/toggle.gif"), 1);
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
        this.setDescription(Messages.ColorPreferencePage_Description);
    }

    public void init(IWorkbench workbench) {
    }

    protected void createFieldEditors() {
        this.fbfeUseColors = new BooleanFieldEditor(PREFKEY_COV_USE_COLORS, Messages.ColorPreferencePage_ColorizeCode, this.getFieldEditorParent());
        this.addField((FieldEditor)this.fbfeUseColors);
        this.fbfeUseGradient = new BooleanFieldEditor(PREFKEY_COV_USE_GRADIENT, Messages.ColorPreferencePage_UseGradient, this.getFieldEditorParent());
        this.addField((FieldEditor)this.fbfeUseGradient);
        this.fcfeMax = new ColorFieldEditor(PREFKEY_COV_MAX_COLOR, Messages.ColorPreferencePage_BackColorHighest, this.getFieldEditorParent());
        this.addField((FieldEditor)this.fcfeMax);
        this.fcfeMin = new ColorFieldEditor(PREFKEY_COV_MIN_COLOR, Messages.ColorPreferencePage_BackColorLowest, this.getFieldEditorParent());
        this.addField((FieldEditor)this.fcfeMin);
        this.fcfeMno = new ColorFieldEditor(PREFKEY_COV_0_COLOR, Messages.ColorPreferencePage_BackColorNotCovered, this.getFieldEditorParent());
        this.addField((FieldEditor)this.fcfeMno);
    }

    private void update() {
        boolean useColor = this.fbfeUseColors.getBooleanValue();
        this.fbfeUseGradient.setEnabled(useColor, this.getFieldEditorParent());
        this.fcfeMax.setEnabled(useColor, this.getFieldEditorParent());
        this.fcfeMno.setEnabled(useColor, this.getFieldEditorParent());
        boolean useGradient = useColor && this.fbfeUseGradient.getBooleanValue();
        this.fcfeMin.setEnabled(useGradient, this.getFieldEditorParent());
    }

    protected void initialize() {
        super.initialize();
        this.update();
    }

    public void propertyChange(PropertyChangeEvent event) {
        super.propertyChange(event);
        this.update();
    }
}

