/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.properties;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.StatusUtil;
import org.eclipse.jst.pagedesigner.PDPlugin;
import org.eclipse.jst.pagedesigner.properties.DesignerPropertyTool;
import org.eclipse.jst.pagedesigner.properties.WPETabbedPropertySheetPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.w3c.dom.Node;

public abstract class BaseCustomSection
extends AbstractPropertySection {
    protected static final Status OKSTATUS = new Status(0, PDPlugin.getPluginId(), 0, "", null);
    private WPETabbedPropertySheetPage _propertySheetPage;
    private boolean _visible = false;
    protected IDOMElement _element;
    protected INodeAdapter _adapter = new INodeAdapter(){

        public boolean isAdapterForType(Object type) {
            return false;
        }

        public void notifyChanged(INodeNotifier notifier, int eventType, Object changedFeature, Object oldValue, Object newValue, int pos) {
            BaseCustomSection.this.notifyChanged(notifier, eventType, changedFeature, oldValue, newValue, pos);
        }
    };

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        IDOMElement newEle = (IDOMElement)DesignerPropertyTool.getElement(part, selection);
        if (this._element != newEle) {
            if (this._element != null) {
                this._element.removeAdapter(this._adapter);
            }
            this._element = newEle;
            if (this._element != null) {
                this._element.addAdapter(this._adapter);
            }
        }
    }

    protected abstract void notifyChanged(INodeNotifier var1, int var2, Object var3, Object var4, Object var5, int var6);

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        this._propertySheetPage = (WPETabbedPropertySheetPage)aTabbedPropertySheetPage;
    }

    protected void refreshPropertySheetPage() {
        if (this._propertySheetPage != null) {
            IWorkbenchPart part = this.getPart();
            if (part != null) {
                ISelection sel = part.getSite().getSelectionProvider().getSelection();
                this._propertySheetPage.selectionChanged(part, sel);
            } else {
                System.out.println("AbstractCustomSection --> What to do?");
            }
        }
    }

    protected void gotoNode(Node node) {
        this._propertySheetPage.internalChangeSelection(node, node);
    }

    protected IStatusLineManager getStatusLineManager() {
        IActionBars bar;
        if (this._propertySheetPage != null && (bar = this._propertySheetPage.getSite().getActionBars()) != null) {
            return bar.getStatusLineManager();
        }
        return null;
    }

    protected void applyStatus(IStatus[] status) {
        if (!this._visible) {
            return;
        }
        IStatusLineManager statusLine = this.getStatusLineManager();
        if (statusLine == null) {
            return;
        }
        IStatus s = status == null || status.length == 0 ? null : StatusUtil.getMostSevere((IStatus[])status);
        if (s == null || s.getSeverity() != 4) {
            statusLine.setErrorMessage(null);
        } else {
            statusLine.setErrorMessage(s.getMessage());
        }
    }

    protected void setErrorMessage(String message) {
        IStatusLineManager s = this.getStatusLineManager();
        if (s != null) {
            s.setErrorMessage(message);
        }
    }

    protected Status createErrorStatus(String message) {
        return new Status(4, PDPlugin.getPluginId(), 0, message, null);
    }

    public void aboutToBeHidden() {
        this.applyStatus(null);
        this._visible = false;
        if (this._element != null) {
            this._element.removeAdapter(this._adapter);
        }
        super.aboutToBeHidden();
    }

    public void aboutToBeShown() {
        super.aboutToBeShown();
        if (this._element != null) {
            this._element.addAdapter(this._adapter);
        }
        this._visible = true;
    }

    protected IProject getProject() {
        IEditorInput input;
        if (this._propertySheetPage != null && (input = this._propertySheetPage.getEditor().getEditorInput()) instanceof IFileEditorInput) {
            return ((IFileEditorInput)input).getFile().getProject();
        }
        return null;
    }

    public void dispose() {
        super.dispose();
        if (this._element != null) {
            this._element.removeAdapter(this._adapter);
        }
    }

    protected IFile getFile() {
        IEditorInput input;
        if (this._propertySheetPage != null && (input = this._propertySheetPage.getEditor().getEditorInput()) instanceof IFileEditorInput) {
            return ((IFileEditorInput)input).getFile();
        }
        return null;
    }
}

