/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.wizards.buildpaths;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.provisional.JavaModelAccess;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElementAttribute;

public abstract class ModuleEncapsulationDetail {
    protected CPListElementAttribute fAttribElem;

    public CPListElementAttribute getParent() {
        return this.fAttribElem;
    }

    public static IJavaElement[] getTargetJavaElements(IJavaProject currentProject, IPath path) {
        IResource member = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
        if (member != null) {
            IJavaElement element = JavaCore.create((IResource)member);
            if (element != null) {
                return new IJavaElement[]{element};
            }
        } else if (path != null && path.isAbsolute()) {
            try {
                IClasspathEntry[] iClasspathEntryArray = currentProject.getRawClasspath();
                int n = iClasspathEntryArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IClasspathEntry classpathEntry = iClasspathEntryArray[n2];
                    if (classpathEntry.getPath().equals((Object)path)) {
                        switch (classpathEntry.getEntryKind()) {
                            case 1: {
                                return new IJavaElement[]{currentProject.getPackageFragmentRoot(path.toString())};
                            }
                        }
                    }
                    ++n2;
                }
            }
            catch (JavaModelException e) {
                JavaPlugin.log(e);
            }
        } else {
            try {
                IClasspathEntry[] iClasspathEntryArray = currentProject.getRawClasspath();
                int n = iClasspathEntryArray.length;
                int n3 = 0;
                while (n3 < n) {
                    IClasspathEntry classpathEntry = iClasspathEntryArray[n3];
                    if (classpathEntry.getPath().equals((Object)path)) {
                        return JavaModelAccess.getUnfilteredPackageFragmentRoots((IJavaProject)currentProject, (IClasspathEntry)classpathEntry);
                    }
                    ++n3;
                }
            }
            catch (JavaModelException e) {
                JavaPlugin.log(e);
            }
        }
        return null;
    }

    public static String encodeFiltered(ModuleEncapsulationDetail[] details, Class<?> detailClass) {
        return Arrays.stream(details).filter(detailClass::isInstance).map(Object::toString).collect(Collectors.joining(":"));
    }

    static class LimitModules
    extends ModuleEncapsulationDetail {
        public final List<String> fExplicitlyIncludedModules;

        public static LimitModules fromString(CPListElementAttribute attribElem, String value) {
            String[] modules = value.split(",");
            int i = 0;
            while (i < modules.length) {
                modules[i] = modules[i].trim();
                ++i;
            }
            return new LimitModules(Arrays.asList(modules), attribElem);
        }

        public LimitModules(List<String> explicitlyIncludedModules, CPListElementAttribute attribElem) {
            this.fExplicitlyIncludedModules = explicitlyIncludedModules;
            this.fAttribElem = attribElem;
        }

        public String toString() {
            return String.join((CharSequence)",", this.fExplicitlyIncludedModules);
        }
    }

    static class ModuleAddExport
    extends ModuleEncapsulationDetail {
        public final String fSourceModule;
        public final String fPackage;
        public final String fTargetModules;

        public static ModuleAddExport fromString(CPListElementAttribute attribElem, String value) {
            int slash = value.indexOf(47);
            int equals = value.indexOf(61);
            if (slash != -1 && equals != -1 && equals > slash) {
                return new ModuleAddExport(value.substring(0, slash), value.substring(slash + 1, equals), value.substring(equals + 1), attribElem);
            }
            return null;
        }

        public static Collection<ModuleAddExport> fromMultiString(CPListElementAttribute attribElem, String values) {
            ArrayList<ModuleAddExport> exports = new ArrayList<ModuleAddExport>();
            String[] stringArray = values.split(":");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String value = stringArray[n2];
                ModuleAddExport export = ModuleAddExport.fromString(attribElem, value);
                if (export != null) {
                    exports.add(export);
                }
                ++n2;
            }
            return exports;
        }

        public ModuleAddExport(String sourceModule, String aPackage, String targetModules, CPListElementAttribute attribElem) {
            this.fSourceModule = sourceModule;
            this.fPackage = aPackage;
            this.fTargetModules = targetModules;
            this.fAttribElem = attribElem;
        }

        public String toString() {
            return String.valueOf(this.fSourceModule) + '/' + this.fPackage + '=' + this.fTargetModules;
        }
    }

    static class ModuleAddReads
    extends ModuleEncapsulationDetail {
        public final String fSourceModule;
        public final String fTargetModule;

        public static ModuleAddReads fromString(CPListElementAttribute attribElem, String value) {
            int equals = value.indexOf(61);
            if (equals != -1) {
                return new ModuleAddReads(value.substring(0, equals), value.substring(equals + 1), attribElem);
            }
            return null;
        }

        public static Collection<ModuleAddReads> fromMultiString(CPListElementAttribute attribElem, String values) {
            ArrayList<ModuleAddReads> readss = new ArrayList<ModuleAddReads>();
            String[] stringArray = values.split(":");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String value = stringArray[n2];
                ModuleAddReads reads = ModuleAddReads.fromString(attribElem, value);
                if (reads != null) {
                    readss.add(reads);
                }
                ++n2;
            }
            return readss;
        }

        public ModuleAddReads(String sourceModule, String targetModule, CPListElementAttribute attribElem) {
            this.fSourceModule = sourceModule;
            this.fTargetModule = targetModule;
            this.fAttribElem = attribElem;
        }

        public String toString() {
            return String.valueOf(this.fSourceModule) + '=' + this.fTargetModule;
        }
    }

    static class ModulePatch
    extends ModuleEncapsulationDetail {
        public final String fModule;

        public static ModulePatch fromString(CPListElementAttribute attribElem, String value) {
            return new ModulePatch(value, attribElem);
        }

        public ModulePatch(String module, CPListElementAttribute attribElem) {
            this.fModule = module;
            this.fAttribElem = attribElem;
        }

        public String toString() {
            return this.fModule;
        }
    }
}

