/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction.proposals;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.EmptyStatement;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.ScopeAnalyzer;
import org.eclipse.jdt.internal.corext.fix.FixMessages;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalPositionGroup;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.text.correction.proposals.LinkedCorrectionProposal;
import org.eclipse.text.edits.TextEditGroup;

public class ExtractToNullCheckedLocalProposal
extends LinkedCorrectionProposal {
    private static final String LOCAL_NAME_POSITION_GROUP = "localName";
    private SimpleName fieldReference;
    private CompilationUnit compilationUnit;
    private ASTNode enclosingMethod;

    public ExtractToNullCheckedLocalProposal(ICompilationUnit cu, CompilationUnit compilationUnit, SimpleName fieldReference, ASTNode enclosingMethod) {
        super(FixMessages.ExtractToNullCheckedLocalProposal_extractToCheckedLocal_proposalName, cu, (ASTRewrite)null, 100, JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif"));
        this.compilationUnit = compilationUnit;
        this.fieldReference = fieldReference;
        this.enclosingMethod = enclosingMethod;
    }

    @Override
    protected ASTRewrite getRewrite() throws CoreException {
        AST ast = this.compilationUnit.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        ImportRewrite imports = ImportRewrite.create((CompilationUnit)this.compilationUnit, (boolean)true);
        TextEditGroup group = new TextEditGroup(FixMessages.ExtractToNullCheckedLocalProposal_extractCheckedLocal_editName);
        LinkedProposalPositionGroup localNameGroup = new LinkedProposalPositionGroup(LOCAL_NAME_POSITION_GROUP);
        this.getLinkedProposalModel().addPositionGroup(localNameGroup);
        Statement origStmt = (Statement)ASTNodes.getParent((ASTNode)this.fieldReference, Statement.class);
        RearrangeStrategy rearrangeStrategy = RearrangeStrategy.create(origStmt, rewrite, group);
        ASTNode directParent = this.fieldReference.getParent();
        Object toReplace = directParent instanceof FieldAccess ? (Expression)directParent : (directParent instanceof QualifiedName && this.fieldReference.getLocationInParent() == QualifiedName.NAME_PROPERTY ? (Expression)directParent : this.fieldReference);
        VariableDeclarationFragment localFrag = ast.newVariableDeclarationFragment();
        VariableDeclarationStatement localDecl = ast.newVariableDeclarationStatement(localFrag);
        localDecl.setType(ExtractToNullCheckedLocalProposal.newType(toReplace.resolveTypeBinding(), ast, imports));
        localDecl.modifiers().add(ast.newModifier(Modifier.ModifierKeyword.FINAL_KEYWORD));
        String localName = this.proposeLocalName(this.fieldReference, this.compilationUnit, this.getCompilationUnit().getJavaProject());
        localFrag.setName(ast.newSimpleName(localName));
        localFrag.setInitializer((Expression)ASTNode.copySubtree((AST)ast, (ASTNode)toReplace));
        rearrangeStrategy.insertLocalDecl(localDecl);
        IfStatement ifStmt = ast.newIfStatement();
        InfixExpression nullCheck = ast.newInfixExpression();
        nullCheck.setLeftOperand((Expression)ast.newSimpleName(localName));
        nullCheck.setRightOperand((Expression)ast.newNullLiteral());
        nullCheck.setOperator(InfixExpression.Operator.NOT_EQUALS);
        ifStmt.setExpression((Expression)nullCheck);
        Block thenBlock = ast.newBlock();
        thenBlock.statements().add(rearrangeStrategy.createMoveTargetForOrigStmt());
        ifStmt.setThenStatement((Statement)thenBlock);
        SimpleName dereferencedName = ast.newSimpleName(localName);
        rewrite.replace((ASTNode)toReplace, (ASTNode)dereferencedName, group);
        Block elseBlock = ast.newBlock();
        String elseStatement = "// TODO " + FixMessages.ExtractToNullCheckedLocalProposal_todoHandleNullDescription;
        if (origStmt instanceof ReturnStatement) {
            Type returnType = ExtractToNullCheckedLocalProposal.newType(((ReturnStatement)origStmt).getExpression().resolveTypeBinding(), ast, imports);
            ReturnStatement returnStatement = ast.newReturnStatement();
            returnStatement.setExpression(ASTNodeFactory.newDefaultExpression(ast, returnType, 0));
            elseStatement = String.valueOf(elseStatement) + '\n' + ASTNodes.asFormattedString((ASTNode)returnStatement, (int)0, (String)String.valueOf('\n'), (Map)this.getCompilationUnit().getJavaProject().getOptions(true));
        }
        EmptyStatement todoNode = (EmptyStatement)rewrite.createStringPlaceholder(elseStatement, 20);
        elseBlock.statements().add(todoNode);
        ifStmt.setElseStatement((Statement)elseBlock);
        this.addLinkedPosition(rewrite.track((ASTNode)localFrag.getName()), true, LOCAL_NAME_POSITION_GROUP);
        this.addLinkedPosition(rewrite.track((ASTNode)nullCheck.getLeftOperand()), false, LOCAL_NAME_POSITION_GROUP);
        this.addLinkedPosition(rewrite.track((ASTNode)dereferencedName), false, LOCAL_NAME_POSITION_GROUP);
        rearrangeStrategy.insertIfStatement(ifStmt, thenBlock);
        return rewrite;
    }

    String proposeLocalName(SimpleName fieldName, CompilationUnit root, IJavaProject javaProject) {
        String identifier;
        Collection variableNames = new ScopeAnalyzer(root).getUsedVariableNames(this.enclosingMethod.getStartPosition(), this.enclosingMethod.getLength());
        String[] names = new String[variableNames.size() + 1];
        variableNames.toArray(names);
        names[names.length - 1] = identifier = fieldName.getIdentifier();
        return StubUtility.getLocalNameSuggestions(javaProject, identifier, 0, names)[0];
    }

    public static Type newType(ITypeBinding typeBinding, AST ast, ImportRewrite imports) {
        PrimitiveType elementType;
        int dimensions = typeBinding.getDimensions();
        if (dimensions > 0) {
            typeBinding = typeBinding.getElementType();
        }
        ITypeBinding[] typeArguments = typeBinding.getTypeArguments();
        Object object = elementType = (typeBinding = typeBinding.getErasure()).isPrimitive() ? ast.newPrimitiveType(PrimitiveType.toCode((String)typeBinding.getName())) : ast.newSimpleType(ast.newName(imports.addImport(typeBinding)));
        if (typeArguments.length > 0) {
            ParameterizedType parameterizedType = ast.newParameterizedType((Type)elementType);
            ITypeBinding[] iTypeBindingArray = typeArguments;
            int n = typeArguments.length;
            int n2 = 0;
            while (n2 < n) {
                ITypeBinding typeArgument = iTypeBindingArray[n2];
                parameterizedType.typeArguments().add(ExtractToNullCheckedLocalProposal.newType(typeArgument, ast, imports));
                ++n2;
            }
            elementType = parameterizedType;
        }
        if (dimensions > 0) {
            return ast.newArrayType((Type)elementType, dimensions);
        }
        return elementType;
    }

    private static abstract class RearrangeStrategy {
        final Statement origStmt;
        final Block block;
        final TextEditGroup group;

        RearrangeStrategy(Statement origStmt, Block block, TextEditGroup group) {
            this.origStmt = origStmt;
            this.block = block;
            this.group = group;
        }

        public abstract void insertLocalDecl(VariableDeclarationStatement var1);

        public abstract Statement createMoveTargetForOrigStmt();

        public abstract void insertIfStatement(IfStatement var1, Block var2);

        public static RearrangeStrategy create(Statement origStmt, ASTRewrite rewrite, TextEditGroup group) {
            ASTNode parent = origStmt.getParent();
            if (parent instanceof Block) {
                Block block = (Block)parent;
                if (origStmt instanceof VariableDeclarationStatement) {
                    return new ModifyBlockWithLocalDecl(origStmt, block, rewrite, group);
                }
                return new ModifyBlock(origStmt, block, rewrite, group);
            }
            return new ReplaceStatement(origStmt, rewrite, group);
        }

        private static class ModifyBlock
        extends RearrangeStrategy {
            final ListRewrite blockRewrite;

            ModifyBlock(Statement origStmt, Block enclosingBlock, ASTRewrite rewrite, TextEditGroup group) {
                super(origStmt, enclosingBlock, group);
                this.blockRewrite = rewrite.getListRewrite((ASTNode)enclosingBlock, Block.STATEMENTS_PROPERTY);
            }

            @Override
            public void insertLocalDecl(VariableDeclarationStatement localDecl) {
                this.blockRewrite.insertBefore((ASTNode)localDecl, (ASTNode)this.origStmt, this.group);
            }

            @Override
            public Statement createMoveTargetForOrigStmt() {
                return (Statement)this.blockRewrite.createMoveTarget((ASTNode)this.origStmt, (ASTNode)this.origStmt, null, this.group);
            }

            @Override
            public void insertIfStatement(IfStatement ifStmt, Block thenBlock) {
                this.blockRewrite.replace((ASTNode)this.origStmt, (ASTNode)ifStmt, this.group);
            }
        }

        private static class ModifyBlockWithLocalDecl
        extends ModifyBlock {
            ModifyBlockWithLocalDecl(Statement origStmt, Block enclosingBlock, ASTRewrite rewrite, TextEditGroup group) {
                super(origStmt, enclosingBlock, rewrite, group);
            }

            @Override
            public void insertIfStatement(IfStatement ifStmt, Block thenBlock) {
                List blockStmts = this.block.statements();
                int stmtIdx = blockStmts.indexOf(this.origStmt);
                int lastIdx = blockStmts.size() - 1;
                if (stmtIdx != -1 && stmtIdx < lastIdx) {
                    thenBlock.statements().add(this.blockRewrite.createMoveTarget((ASTNode)blockStmts.get(stmtIdx + 1), (ASTNode)blockStmts.get(lastIdx), null, this.group));
                }
                super.insertIfStatement(ifStmt, thenBlock);
            }
        }

        private static class ReplaceStatement
        extends RearrangeStrategy {
            final ASTRewrite rewrite;

            ReplaceStatement(Statement origStmt, ASTRewrite rewrite, TextEditGroup group) {
                super(origStmt, rewrite.getAST().newBlock(), group);
                this.rewrite = rewrite;
            }

            @Override
            public void insertLocalDecl(VariableDeclarationStatement localDecl) {
                this.block.statements().add(localDecl);
            }

            @Override
            public Statement createMoveTargetForOrigStmt() {
                return (Statement)this.rewrite.createMoveTarget((ASTNode)this.origStmt);
            }

            @Override
            public void insertIfStatement(IfStatement ifStmt, Block thenBlock) {
                this.block.statements().add(ifStmt);
                this.rewrite.replace((ASTNode)this.origStmt, (ASTNode)this.block, this.group);
            }
        }
    }
}

