/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.ui.handlers.exportimport;

import java.util.Date;
import org.eclipse.emf.emfstore.internal.client.ui.controller.UIImportController;
import org.eclipse.emf.emfstore.internal.client.ui.handlers.AbstractEMFStoreHandler;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.ui.PlatformUI;

public class ImportProjectHandler
extends AbstractEMFStoreHandler {
    public void handle() {
        String projectName = this.showProjectNameDialog("Imported project@" + new Date());
        if (projectName == null) {
            return;
        }
        new UIImportController(this.getShell()).importProject(projectName);
    }

    private String showProjectNameDialog(String initialProjectName) {
        IInputValidator inputValidator = new IInputValidator(){

            public String isValid(String newText) {
                if (newText == null || newText.equals("") || newText.matches("\\s*")) {
                    return "No project name provided!";
                }
                return null;
            }
        };
        InputDialog inputDialog = new InputDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "Project Name", "Please enter a name for the imported project:", initialProjectName, inputValidator);
        if (inputDialog.open() == 0) {
            return inputDialog.getValue();
        }
        return null;
    }
}

