/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.session;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.eclipse.emf.cdo.CDOState;
import org.eclipse.emf.cdo.common.CDOCommonRepository;
import org.eclipse.emf.cdo.common.CDOCommonSession;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.branch.CDOBranchVersion;
import org.eclipse.emf.cdo.common.commit.CDOChangeKind;
import org.eclipse.emf.cdo.common.commit.CDOChangeSet;
import org.eclipse.emf.cdo.common.commit.CDOChangeSetData;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfo;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfoManager;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDGenerator;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.lob.CDOLobInfo;
import org.eclipse.emf.cdo.common.lob.CDOLobStore;
import org.eclipse.emf.cdo.common.lock.CDOLockChangeInfo;
import org.eclipse.emf.cdo.common.model.CDOPackageUnit;
import org.eclipse.emf.cdo.common.protocol.CDOAuthenticator;
import org.eclipse.emf.cdo.common.protocol.CDOProtocol;
import org.eclipse.emf.cdo.common.revision.CDOElementProxy;
import org.eclipse.emf.cdo.common.revision.CDOIDAndVersion;
import org.eclipse.emf.cdo.common.revision.CDOList;
import org.eclipse.emf.cdo.common.revision.CDORevisable;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionKey;
import org.eclipse.emf.cdo.common.revision.CDORevisionManager;
import org.eclipse.emf.cdo.common.revision.CDORevisionProvider;
import org.eclipse.emf.cdo.common.revision.CDORevisionUtil;
import org.eclipse.emf.cdo.common.revision.delta.CDOAddFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOClearFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDeltaVisitor;
import org.eclipse.emf.cdo.common.revision.delta.CDOListFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOMoveFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDORemoveFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDORevisionDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOSetFeatureDelta;
import org.eclipse.emf.cdo.common.security.CDOPermission;
import org.eclipse.emf.cdo.common.util.CDOCommonUtil;
import org.eclipse.emf.cdo.common.util.CDOPackageNotFoundException;
import org.eclipse.emf.cdo.common.util.RepositoryStateChangedEvent;
import org.eclipse.emf.cdo.common.util.RepositoryTypeChangedEvent;
import org.eclipse.emf.cdo.eresource.EresourcePackage;
import org.eclipse.emf.cdo.etypes.EtypesPackage;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDOMoveFeatureDeltaImpl;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDOSetFeatureDeltaImpl;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDOSingleValueFeatureDeltaImpl;
import org.eclipse.emf.cdo.session.CDOCollectionLoadingPolicy;
import org.eclipse.emf.cdo.session.CDORepositoryInfo;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.session.CDOSessionInvalidationEvent;
import org.eclipse.emf.cdo.session.CDOSessionLocksChangedEvent;
import org.eclipse.emf.cdo.spi.common.CDOLobStoreImpl;
import org.eclipse.emf.cdo.spi.common.branch.CDOBranchUtil;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranch;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranchManager;
import org.eclipse.emf.cdo.spi.common.commit.CDORevisionAvailabilityInfo;
import org.eclipse.emf.cdo.spi.common.commit.InternalCDOCommitInfoManager;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageRegistry;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageUnit;
import org.eclipse.emf.cdo.spi.common.revision.CDOFeatureDeltaVisitorImpl;
import org.eclipse.emf.cdo.spi.common.revision.DetachedCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionCache;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionDelta;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionManager;
import org.eclipse.emf.cdo.spi.common.revision.PointerCDORevision;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.cdo.view.CDOFetchRuleManager;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.internal.cdo.analyzer.NOOPFetchRuleManager;
import org.eclipse.emf.internal.cdo.bundle.OM;
import org.eclipse.emf.internal.cdo.messages.Messages;
import org.eclipse.emf.internal.cdo.object.CDOFactoryImpl;
import org.eclipse.emf.internal.cdo.session.CDOTransactionContainerImpl;
import org.eclipse.emf.internal.cdo.session.DelegatingSessionProtocol;
import org.eclipse.emf.internal.cdo.session.SessionUtil;
import org.eclipse.emf.internal.cdo.session.remote.CDORemoteSessionManagerImpl;
import org.eclipse.emf.internal.cdo.util.DefaultLocksChangedEvent;
import org.eclipse.emf.spi.cdo.CDOPermissionUpdater;
import org.eclipse.emf.spi.cdo.CDOSessionProtocol;
import org.eclipse.emf.spi.cdo.InternalCDOObject;
import org.eclipse.emf.spi.cdo.InternalCDORemoteSessionManager;
import org.eclipse.emf.spi.cdo.InternalCDOSession;
import org.eclipse.emf.spi.cdo.InternalCDOSessionInvalidationEvent;
import org.eclipse.emf.spi.cdo.InternalCDOTransaction;
import org.eclipse.emf.spi.cdo.InternalCDOView;
import org.eclipse.net4j.util.AdapterUtil;
import org.eclipse.net4j.util.ReflectUtil;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.concurrent.ConcurrencyUtil;
import org.eclipse.net4j.util.concurrent.ExecutorWorkSerializer;
import org.eclipse.net4j.util.concurrent.IExecutorServiceProvider;
import org.eclipse.net4j.util.concurrent.IRWLockManager;
import org.eclipse.net4j.util.concurrent.IRWOLockManager;
import org.eclipse.net4j.util.concurrent.RWOLockManager;
import org.eclipse.net4j.util.concurrent.RunnableWithName;
import org.eclipse.net4j.util.event.Event;
import org.eclipse.net4j.util.event.EventUtil;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.event.INotifier;
import org.eclipse.net4j.util.event.Notifier;
import org.eclipse.net4j.util.io.IOUtil;
import org.eclipse.net4j.util.lifecycle.ILifecycle;
import org.eclipse.net4j.util.lifecycle.LifecycleEventAdapter;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.log.OMLogger;
import org.eclipse.net4j.util.om.trace.ContextTracer;
import org.eclipse.net4j.util.options.IOptions;
import org.eclipse.net4j.util.options.OptionsEvent;
import org.eclipse.net4j.util.registry.HashMapRegistry;
import org.eclipse.net4j.util.registry.IRegistry;
import org.eclipse.net4j.util.security.IPasswordCredentialsProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CDOSessionImpl
extends CDOTransactionContainerImpl
implements InternalCDOSession,
IExecutorServiceProvider {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_SESSION, CDOSessionImpl.class);
    private CDOSession.ExceptionHandler exceptionHandler;
    private CDOIDGenerator idGenerator;
    private InternalCDOPackageRegistry packageRegistry;
    private InternalCDOBranchManager branchManager;
    private InternalCDORevisionManager revisionManager;
    private InternalCDOCommitInfoManager commitInfoManager;
    private CDOSessionProtocol sessionProtocol;
    @ReflectUtil.ExcludeFromDump
    private IListener sessionProtocolListener = new LifecycleEventAdapter(){

        protected void onDeactivated(ILifecycle lifecycle) {
            CDOSessionImpl.this.sessionProtocolDeactivated();
        }
    };
    private int sessionID;
    private String userID;
    private long lastUpdateTime;
    @ReflectUtil.ExcludeFromDump
    private LastUpdateTimeLock lastUpdateTimeLock = new LastUpdateTimeLock();
    private CDOSession.Options options = this.createOptions();
    private final IRegistry<String, Object> properties = new HashMapRegistry<String, Object>(){

        public void setAutoCommit(boolean autoCommit) {
            throw new UnsupportedOperationException();
        }
    };
    private Invalidator invalidator = new Invalidator();
    private CDORepositoryInfo repositoryInfo;
    private CDOFetchRuleManager fetchRuleManager;
    private IRWOLockManager<CDOSessionImpl, Object> lockManager = new RWOLockManager();
    @ReflectUtil.ExcludeFromDump
    private Set<CDOSessionImpl> singletonCollection = Collections.singleton(this);
    private boolean mainBranchLocal;
    private IPasswordCredentialsProvider credentialsProvider;
    private InternalCDORemoteSessionManager remoteSessionManager;
    private Map<CDOID, CDOBranchPoint> committedSinceLastRefresh = CDOIDUtil.createMap();

    static {
        EcorePackage.eINSTANCE.getClass();
        EtypesPackage.eINSTANCE.getClass();
        EresourcePackage.eINSTANCE.getClass();
    }

    @Override
    public CDORepositoryInfo getRepositoryInfo() {
        return this.repositoryInfo;
    }

    @Override
    public void setRepositoryInfo(CDORepositoryInfo repositoryInfo) {
        this.repositoryInfo = repositoryInfo;
    }

    public int getSessionID() {
        return this.sessionID;
    }

    @Override
    public void setSessionID(int sessionID) {
        this.sessionID = sessionID;
    }

    public String getUserID() {
        return this.userID;
    }

    @Override
    public void setUserID(String userID) {
        this.userID = userID;
    }

    @Override
    public CDOSession.ExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    @Override
    public void setExceptionHandler(CDOSession.ExceptionHandler exceptionHandler) {
        this.checkInactive();
        this.exceptionHandler = exceptionHandler;
    }

    @Override
    public CDOIDGenerator getIDGenerator() {
        return this.idGenerator;
    }

    @Override
    public void setIDGenerator(CDOIDGenerator idGenerator) {
        this.checkInactive();
        this.idGenerator = idGenerator;
    }

    @Override
    public InternalCDOPackageRegistry getPackageRegistry() {
        return this.packageRegistry;
    }

    @Override
    public void setPackageRegistry(InternalCDOPackageRegistry packageRegistry) {
        this.packageRegistry = packageRegistry;
    }

    @Override
    public InternalCDOBranchManager getBranchManager() {
        return this.branchManager;
    }

    @Override
    public void setBranchManager(InternalCDOBranchManager branchManager) {
        this.checkInactive();
        this.branchManager = branchManager;
    }

    @Override
    public InternalCDORevisionManager getRevisionManager() {
        return this.revisionManager;
    }

    @Override
    public void setRevisionManager(InternalCDORevisionManager revisionManager) {
        this.checkInactive();
        this.revisionManager = revisionManager;
    }

    @Override
    public InternalCDOCommitInfoManager getCommitInfoManager() {
        return this.commitInfoManager;
    }

    @Override
    public void setCommitInfoManager(InternalCDOCommitInfoManager commitInfoManager) {
        this.checkInactive();
        this.commitInfoManager = commitInfoManager;
    }

    @Override
    public CDOSessionProtocol getSessionProtocol() {
        return this.sessionProtocol;
    }

    @Override
    public void setSessionProtocol(CDOSessionProtocol sessionProtocol) {
        if (this.exceptionHandler == null) {
            this.sessionProtocol = sessionProtocol;
        } else if (this.sessionProtocol instanceof DelegatingSessionProtocol) {
            ((DelegatingSessionProtocol)this.sessionProtocol).setDelegate(sessionProtocol);
        } else {
            this.sessionProtocol = new DelegatingSessionProtocol(sessionProtocol, this.exceptionHandler);
        }
    }

    @Override
    public CDOFetchRuleManager getFetchRuleManager() {
        return this.fetchRuleManager;
    }

    public ExecutorService getExecutorService() {
        return ConcurrencyUtil.getExecutorService((Object)this.sessionProtocol);
    }

    @Override
    public void setFetchRuleManager(CDOFetchRuleManager fetchRuleManager) {
        if (fetchRuleManager == null) {
            fetchRuleManager = new NOOPFetchRuleManager(){

                public CDOCollectionLoadingPolicy getCollectionLoadingPolicy() {
                    return CDOSessionImpl.this.options().getCollectionLoadingPolicy();
                }
            };
        }
        this.fetchRuleManager = fetchRuleManager;
    }

    @Override
    @Deprecated
    public CDOAuthenticator getAuthenticator() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void setAuthenticator(CDOAuthenticator authenticator) {
        throw new UnsupportedOperationException();
    }

    public IPasswordCredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider;
    }

    @Override
    public void setCredentialsProvider(IPasswordCredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
    }

    public boolean isMainBranchLocal() {
        return this.mainBranchLocal;
    }

    @Override
    public void setMainBranchLocal(boolean mainBranchLocal) {
        this.mainBranchLocal = mainBranchLocal;
    }

    @Override
    public InternalCDORemoteSessionManager getRemoteSessionManager() {
        return this.remoteSessionManager;
    }

    @Override
    public void setRemoteSessionManager(InternalCDORemoteSessionManager remoteSessionManager) {
        this.remoteSessionManager = remoteSessionManager;
    }

    @Override
    public CDOLobStore getLobStore() {
        final CDOLobStore cache = this.options().getLobCache();
        return new CDOLobStore.Delegating(){

            public InputStream getBinary(CDOLobInfo info) throws IOException {
                while (true) {
                    try {
                        return super.getBinary(info);
                    }
                    catch (FileNotFoundException couldNotBeRead) {
                        try {
                            this.loadBinary(info);
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                        }
                        continue;
                    }
                    break;
                }
            }

            public Reader getCharacter(CDOLobInfo info) throws IOException {
                while (true) {
                    try {
                        return super.getCharacter(info);
                    }
                    catch (FileNotFoundException couldNotBeRead) {
                        try {
                            this.loadCharacter(info);
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                        }
                        continue;
                    }
                    break;
                }
            }

            private void loadBinary(CDOLobInfo info) throws IOException {
                File file = this.getDelegate().getBinaryFile(info.getID());
                FileOutputStream out = new FileOutputStream(file);
                CDOSessionImpl.this.loadLobAsync(info, file, out);
            }

            private void loadCharacter(CDOLobInfo info) throws IOException {
                File file = this.getDelegate().getCharacterFile(info.getID());
                FileWriter out = new FileWriter(file);
                CDOSessionImpl.this.loadLobAsync(info, file, out);
            }

            protected CDOLobStore getDelegate() {
                return cache;
            }
        };
    }

    protected void loadLobAsync(final CDOLobInfo info, final File file, final Object outputStreamOrWriter) {
        ConcurrencyUtil.execute((Object)this, (Runnable)new RunnableWithName(){

            public String getName() {
                return "CDOLobLoader-" + info.getIDString();
            }

            protected void doRun() {
                try {
                    CDOSessionProtocol sessionProtocol = CDOSessionImpl.this.getSessionProtocol();
                    sessionProtocol.loadLob(info, outputStreamOrWriter);
                }
                catch (Throwable t) {
                    OM.LOG.error(t);
                    IOUtil.delete((File)file);
                }
            }
        });
    }

    public void close() {
        LifecycleUtil.deactivate((Object)this, (OMLogger.Level)OMLogger.Level.DEBUG);
    }

    public boolean isClosed() {
        return !this.isActive();
    }

    @Override
    public CDOSession.Options options() {
        return this.options;
    }

    public IRegistry<String, Object> properties() {
        return this.properties;
    }

    protected CDOSession.Options createOptions() {
        return new OptionsImpl();
    }

    public Object processPackage(Object value) {
        CDOFactoryImpl.prepareDynamicEPackage(value);
        return value;
    }

    public EPackage[] loadPackages(CDOPackageUnit packageUnit) {
        if (packageUnit.getOriginalType().isGenerated() && !this.options().isGeneratedPackageEmulationEnabled()) {
            throw new CDOPackageNotFoundException(packageUnit.getID());
        }
        return this.getSessionProtocol().loadPackages(packageUnit);
    }

    public void acquireAtomicRequestLock(Object key) {
        try {
            this.lockManager.lock(IRWLockManager.LockType.WRITE, key, (Object)this, 0L);
        }
        catch (InterruptedException ex) {
            throw WrappedException.wrap((Exception)ex);
        }
    }

    public void releaseAtomicRequestLock(Object key) {
        this.lockManager.unlock(IRWLockManager.LockType.WRITE, key, this.singletonCollection);
    }

    @Override
    protected void initViewSynced(InternalCDOView view) {
        view.setSession(this);
        view.setLastUpdateTime(this.getLastUpdateTime());
    }

    @Override
    protected CDOBranch getMainBranch() {
        return this.getBranchManager().getMainBranch();
    }

    @Override
    public long refresh() {
        this.checkActive();
        if (this.options().isPassiveUpdateEnabled()) {
            return 0L;
        }
        return this.refresh(false);
    }

    @Override
    public long refresh(CDOSessionProtocol.RefreshSessionResult.Provider provider) {
        HashMap<CDOBranch, List<InternalCDOView>> views = new HashMap<CDOBranch, List<InternalCDOView>>();
        HashMap<CDOBranch, Map<CDOID, InternalCDORevision>> viewedRevisions = new HashMap<CDOBranch, Map<CDOID, InternalCDORevision>>();
        this.collectViewedRevisions(views, viewedRevisions);
        this.cleanupRevisionCache(viewedRevisions);
        CDOSessionProtocol.RefreshSessionResult result = provider.getRefreshSessionResult(views, viewedRevisions);
        this.setLastUpdateTime(result.getLastUpdateTime());
        this.registerPackageUnits(result.getPackageUnits());
        for (Map.Entry entry : views.entrySet()) {
            CDOBranch branch = (CDOBranch)entry.getKey();
            List branchViews = (List)entry.getValue();
            this.processRefreshSessionResult(result, branch, branchViews, viewedRevisions);
        }
        return result.getLastUpdateTime();
    }

    protected final long refresh(final boolean enablePassiveUpdates) {
        return this.refresh(new CDOSessionProtocol.RefreshSessionResult.Provider(){

            @Override
            public CDOSessionProtocol.RefreshSessionResult getRefreshSessionResult(Map<CDOBranch, List<InternalCDOView>> views, Map<CDOBranch, Map<CDOID, InternalCDORevision>> viewedRevisions) {
                CDOSessionProtocol sessionProtocol = CDOSessionImpl.this.getSessionProtocol();
                long lastUpdateTime = CDOSessionImpl.this.getLastUpdateTime();
                int initialChunkSize = CDOSessionImpl.this.options().getCollectionLoadingPolicy().getInitialChunkSize();
                return sessionProtocol.refresh(lastUpdateTime, viewedRevisions, initialChunkSize, enablePassiveUpdates);
            }
        });
    }

    @Override
    public void processRefreshSessionResult(CDOSessionProtocol.RefreshSessionResult result, CDOBranch branch, List<InternalCDOView> branchViews, Map<CDOBranch, Map<CDOID, InternalCDORevision>> viewedRevisions) {
        Map<CDOID, InternalCDORevision> oldRevisions = viewedRevisions.get(branch);
        InternalCDORevisionManager revisionManager = this.getRevisionManager();
        ArrayList<CDORevisionKey> changedObjects = new ArrayList<CDORevisionKey>();
        List<InternalCDORevision> newRevisions = result.getChangedObjects(branch);
        for (InternalCDORevision newRevision : newRevisions) {
            revisionManager.addRevision((CDORevision)newRevision);
            CDOID id = newRevision.getID();
            InternalCDORevision oldRevision = oldRevisions.get(id);
            InternalCDORevisionDelta delta = newRevision.compare((CDORevision)oldRevision);
            changedObjects.add((CDORevisionKey)delta);
        }
        List<CDOIDAndVersion> detachedObjects = result.getDetachedObjects(branch);
        for (CDOIDAndVersion detachedObject : detachedObjects) {
            CDOID id = detachedObject.getID();
            revisionManager.reviseLatest(id, branch);
        }
        long lastUpdateTime = result.getLastUpdateTime();
        for (InternalCDOView view : branchViews) {
            InternalCDOView.ViewInvalidationData invalidationData = new InternalCDOView.ViewInvalidationData();
            invalidationData.setBranch(view.getBranch());
            invalidationData.setLastUpdateTime(lastUpdateTime);
            invalidationData.setAllChangedObjects(changedObjects);
            invalidationData.setAllDetachedObjects(detachedObjects);
            invalidationData.setOldRevisions(oldRevisions);
            invalidationData.setClearResourcePathCache(true);
            view.invalidate(invalidationData);
        }
    }

    private void collectViewedRevisions(Map<CDOBranch, List<InternalCDOView>> views, Map<CDOBranch, Map<CDOID, InternalCDORevision>> viewedRevisions) {
        InternalCDOView[] internalCDOViewArray = this.getViews();
        int n = internalCDOViewArray.length;
        int n2 = 0;
        while (n2 < n) {
            InternalCDOView view = internalCDOViewArray[n2];
            if (view.getTimeStamp() == 0L) {
                boolean needNewMap;
                CDOBranch branch = view.getBranch();
                Map revisions = viewedRevisions.get(branch);
                boolean bl = needNewMap = revisions == null;
                if (needNewMap) {
                    revisions = CDOIDUtil.createMap();
                }
                view.collectViewedRevisions(revisions);
                if (!revisions.isEmpty()) {
                    List<InternalCDOView> list = views.get(branch);
                    if (list == null) {
                        list = new ArrayList<InternalCDOView>();
                        views.put(branch, list);
                    }
                    list.add(view);
                    if (needNewMap) {
                        viewedRevisions.put(branch, revisions);
                    }
                }
            }
            ++n2;
        }
    }

    private void cleanupRevisionCache(Map<CDOBranch, Map<CDOID, InternalCDORevision>> viewedRevisions) {
        HashSet<InternalCDORevision> set = new HashSet<InternalCDORevision>();
        for (Map<CDOID, InternalCDORevision> revisions : viewedRevisions.values()) {
            for (InternalCDORevision revision : revisions.values()) {
                set.add(revision);
            }
        }
        InternalCDORevisionCache cache = this.getRevisionManager().getCache();
        List currentRevisions = cache.getCurrentRevisions();
        for (InternalCDORevision revision : currentRevisions) {
            if (set.contains(revision)) continue;
            cache.removeRevision(revision.getID(), (CDOBranchVersion)revision);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLastUpdateTime() {
        LastUpdateTimeLock lastUpdateTimeLock = this.lastUpdateTimeLock;
        synchronized (lastUpdateTimeLock) {
            return this.lastUpdateTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLastUpdateTime(long lastUpdateTime) {
        LastUpdateTimeLock lastUpdateTimeLock = this.lastUpdateTimeLock;
        synchronized (lastUpdateTimeLock) {
            if (this.lastUpdateTime < lastUpdateTime) {
                this.lastUpdateTime = lastUpdateTime;
            }
            this.lastUpdateTimeLock.notifyAll();
        }
    }

    @Override
    public void waitForUpdate(long updateTime) {
        this.waitForUpdate(updateTime, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean waitForUpdate(long updateTime, long timeoutMillis) {
        long end = timeoutMillis == -1L ? Long.MAX_VALUE : System.currentTimeMillis() + timeoutMillis;
        InternalCDOView[] views = this.getViews();
        if (views.length > 0) {
            InternalCDOView[] internalCDOViewArray = views;
            int n = views.length;
            int n2 = 0;
            while (n2 < n) {
                InternalCDOView view = internalCDOViewArray[n2];
                long viewTimeoutMillis = timeoutMillis == -1L ? -1L : end - System.currentTimeMillis();
                boolean ok = view.waitForUpdate(updateTime, viewTimeoutMillis);
                if (!ok) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
        while (true) {
            LastUpdateTimeLock lastUpdateTimeLock = this.lastUpdateTimeLock;
            synchronized (lastUpdateTimeLock) {
                if (this.lastUpdateTime >= updateTime) {
                    return true;
                }
                long now = System.currentTimeMillis();
                if (now >= end) {
                    return false;
                }
                try {
                    this.lastUpdateTimeLock.wait(end - now);
                }
                catch (InterruptedException ex) {
                    throw WrappedException.wrap((Exception)ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean runAfterUpdate(final long updateTime, final Runnable runnable) {
        LastUpdateTimeLock lastUpdateTimeLock = this.lastUpdateTimeLock;
        synchronized (lastUpdateTimeLock) {
            if (this.lastUpdateTime < updateTime) {
                this.addListener(new IListener(){

                    public void notifyEvent(IEvent event) {
                        CDOSessionInvalidationEvent e;
                        if (event instanceof CDOSessionInvalidationEvent && (e = (CDOSessionInvalidationEvent)event).getTimeStamp() >= updateTime) {
                            CDOSessionImpl.this.removeListener(this);
                            runnable.run();
                        }
                    }
                });
                return false;
            }
        }
        runnable.run();
        return true;
    }

    @Override
    public Object resolveElementProxy(CDORevision revision, EStructuralFeature feature, int accessIndex, int serverIndex) {
        if (!((InternalCDORevision)revision).isUnchunked()) {
            CDOCollectionLoadingPolicy policy = this.options().getCollectionLoadingPolicy();
            return policy.resolveProxy(revision, feature, accessIndex, serverIndex);
        }
        return revision.data().get(feature, accessIndex);
    }

    @Override
    public void resolveAllElementProxies(CDORevision revision) {
        InternalCDORevision internalRevision = (InternalCDORevision)revision;
        if (!internalRevision.isUnchunked()) {
            CDOCollectionLoadingPolicy policy = this.options().getCollectionLoadingPolicy();
            EReference[] eReferenceArray = internalRevision.getClassInfo().getAllPersistentReferences();
            int n = eReferenceArray.length;
            int n2 = 0;
            while (n2 < n) {
                EReference reference = eReferenceArray[n2];
                if (reference.isMany()) {
                    CDOList list = internalRevision.getList((EStructuralFeature)reference);
                    for (Object element : list) {
                        if (!(element instanceof CDOElementProxy)) continue;
                        policy.resolveAllProxies((CDORevision)internalRevision, (EStructuralFeature)reference);
                        break;
                    }
                }
                ++n2;
            }
            internalRevision.setUnchunked();
        }
    }

    public void ensureChunks(InternalCDORevision revision, int chunkSize) {
        this.resolveAllElementProxies((CDORevision)revision);
    }

    @Override
    public void handleRepositoryTypeChanged(CDOCommonRepository.Type oldType, CDOCommonRepository.Type newType) {
        this.fireEvent((IEvent)new RepositoryTypeChangedEvent((INotifier)this, oldType, newType));
    }

    @Override
    public void handleRepositoryStateChanged(CDOCommonRepository.State oldState, CDOCommonRepository.State newState) {
        this.fireEvent((IEvent)new RepositoryStateChangedEvent((INotifier)this, oldState, newState));
    }

    @Override
    @Deprecated
    public void handleBranchNotification(InternalCDOBranch branch) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void handleCommitNotification(CDOCommitInfo commitInfo) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void handleCommitNotification(CDOCommitInfo commitInfo, boolean clearResourcePathCache) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void handleCommitNotification(CDOProtocol.CommitNotificationInfo info) {
        try {
            CDOCommitInfo commitInfo = info.getCommitInfo();
            this.registerPackageUnits(commitInfo.getNewPackageUnits());
            InternalCDOSession.InvalidationData invalidationData = new InternalCDOSession.InvalidationData();
            invalidationData.setCommitInfo(commitInfo);
            invalidationData.setSender(null);
            invalidationData.setClearResourcePathCache(info.isClearResourcePathCache());
            invalidationData.setSecurityImpact(info.getSecurityImpact());
            invalidationData.setNewPermissions(info.getNewPermissions());
            invalidationData.setLockChangeInfo(info.getLockChangeInfo());
            this.invalidate(invalidationData);
        }
        catch (RuntimeException ex) {
            if (this.isActive()) {
                OM.LOG.error((Throwable)ex);
            }
            OM.LOG.info(Messages.getString("CDOSessionImpl.2"));
        }
    }

    @Override
    public void handleLockNotification(CDOLockChangeInfo lockChangeInfo, InternalCDOView sender) {
        InternalCDOView[] internalCDOViewArray = this.getViews();
        int n = internalCDOViewArray.length;
        int n2 = 0;
        while (n2 < n) {
            InternalCDOView view = internalCDOViewArray[n2];
            if (view != sender) {
                view.handleLockNotification(sender, lockChangeInfo);
            }
            ++n2;
        }
        this.fireEvent(new SessionLocksChangedEvent(sender, lockChangeInfo));
    }

    private void registerPackageUnits(List<CDOPackageUnit> packageUnits) {
        InternalCDOPackageRegistry packageRegistry = this.getPackageRegistry();
        for (CDOPackageUnit newPackageUnit : packageUnits) {
            packageRegistry.putPackageUnit((InternalCDOPackageUnit)newPackageUnit);
        }
    }

    private void addOldValuesToDelta(final CDORevision oldRevision, CDORevisionDelta revisionDelta) {
        CDOFeatureDeltaVisitorImpl visitor = new CDOFeatureDeltaVisitorImpl(){
            private List<Object> workList;

            public void visit(CDOAddFeatureDelta delta) {
                this.workList.add(delta.getIndex(), delta.getValue());
            }

            public void visit(CDOClearFeatureDelta delta) {
                this.workList.clear();
            }

            public void visit(CDOListFeatureDelta deltas) {
                List list = (List)((InternalCDORevision)oldRevision).getValue(deltas.getFeature());
                if (list != null) {
                    this.workList = new ArrayList<Object>(list);
                    super.visit(deltas);
                }
            }

            public void visit(CDOMoveFeatureDelta delta) {
                Object value = this.workList.get(delta.getOldPosition());
                ((CDOMoveFeatureDeltaImpl)delta).setValue(value);
                ECollections.move(this.workList, (int)delta.getNewPosition(), (int)delta.getOldPosition());
            }

            public void visit(CDORemoveFeatureDelta delta) {
                Object oldValue = this.workList.remove(delta.getIndex());
                ((CDOSingleValueFeatureDeltaImpl)delta).setValue(oldValue);
            }

            public void visit(CDOSetFeatureDelta delta) {
                EStructuralFeature feature = delta.getFeature();
                Object value = null;
                value = feature.isMany() ? this.workList.set(delta.getIndex(), delta.getValue()) : ((InternalCDORevision)oldRevision).getValue(feature);
                ((CDOSetFeatureDeltaImpl)delta).setOldValue(value);
            }
        };
        for (CDOFeatureDelta featureDelta : revisionDelta.getFeatureDeltas()) {
            featureDelta.accept((CDOFeatureDeltaVisitor)visitor);
        }
    }

    @Override
    public Object startLocalCommit() {
        return this.invalidator.startLocalCommit();
    }

    @Override
    public void endLocalCommit(Object token) {
        this.invalidator.endLocalCommit(token);
    }

    @Override
    @Deprecated
    public void invalidate(CDOCommitInfo commitInfo, InternalCDOTransaction sender) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void invalidate(CDOCommitInfo commitInfo, InternalCDOTransaction sender, boolean clearResourcePathCache) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void invalidate(CDOCommitInfo commitInfo, InternalCDOTransaction sender, boolean clearResourcePathCache, byte securityImpact, Map<CDOID, CDOPermission> newPermissions) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void invalidate(InternalCDOSession.InvalidationData invalidationData) {
        this.invalidator.reorderInvalidations(invalidationData);
    }

    public ILifecycle getInvalidator() {
        return this.invalidator;
    }

    public Object getAdapter(Class adapter) {
        return AdapterUtil.adapt((Object)this, (Class)adapter, (boolean)false);
    }

    public String toString() {
        String name;
        String string = name = this.repositoryInfo == null ? "?" : this.repositoryInfo.getName();
        if (this.userID != null && this.userID.length() != 0) {
            name = String.valueOf(this.userID) + "@" + name;
        }
        return MessageFormat.format("Session{0} [{1}]", this.sessionID, name);
    }

    @Override
    public CDOBranchPoint getCommittedSinceLastRefresh(CDOID id) {
        if (this.isSticky()) {
            return this.committedSinceLastRefresh.get(id);
        }
        return null;
    }

    @Override
    public void setCommittedSinceLastRefresh(CDOID id, CDOBranchPoint branchPoint) {
        if (this.isSticky()) {
            this.committedSinceLastRefresh.put(id, branchPoint);
        }
    }

    @Override
    public void clearCommittedSinceLastRefresh() {
        if (this.isSticky()) {
            this.committedSinceLastRefresh.clear();
        }
    }

    @Override
    public boolean isSticky() {
        return !this.options().isPassiveUpdateEnabled() && this.getRepositoryInfo().isSupportingAudits();
    }

    @Override
    public CDOChangeSetData compareRevisions(CDOBranchPoint source, CDOBranchPoint target) {
        long now = this.getLastUpdateTime();
        if (target.getTimeStamp() == 0L) {
            target = target.getBranch().getPoint(now);
        }
        if (source.getTimeStamp() == 0L) {
            source = source.getBranch().getPoint(now);
        }
        CDORevisionAvailabilityInfo targetInfo = this.createRevisionAvailabilityInfo2(target);
        CDORevisionAvailabilityInfo sourceInfo = this.createRevisionAvailabilityInfo2(source);
        CDOSessionProtocol.MergeDataResult result = this.sessionProtocol.loadMergeData2(targetInfo, sourceInfo, null, null);
        Set<CDOID> ids = result.getTargetIDs();
        this.cacheRevisions2(targetInfo);
        this.cacheRevisions2(sourceInfo);
        return CDORevisionUtil.createChangeSetData(ids, (CDORevisionProvider)sourceInfo, (CDORevisionProvider)targetInfo);
    }

    @Override
    public InternalCDOSession.MergeData getMergeData(CDOBranchPoint target, CDOBranchPoint source, CDOBranchPoint sourceBase, boolean computeChangeSets) {
        return this.getMergeData(target, source, null, sourceBase, computeChangeSets);
    }

    @Override
    public InternalCDOSession.MergeData getMergeData(CDOBranchPoint target, CDOBranchPoint source, CDOBranchPoint targetBase, CDOBranchPoint sourceBase, boolean computeChangeSets) {
        boolean auto;
        if (sourceBase == CDOBranchUtil.AUTO_BRANCH_POINT) {
            auto = true;
            targetBase = CDOBranchUtil.AUTO_BRANCH_POINT;
        } else {
            auto = false;
            CDOBranchPoint ancestor = null;
            if (sourceBase == null) {
                sourceBase = ancestor = CDOBranchUtil.getAncestor((CDOBranchPoint)target, (CDOBranchPoint)source);
            }
            if (targetBase == null) {
                if (ancestor == null) {
                    ancestor = CDOBranchUtil.getAncestor((CDOBranchPoint)target, (CDOBranchPoint)source);
                }
                targetBase = ancestor;
            }
        }
        boolean sameBase = sourceBase.equals(targetBase);
        CDORevisionAvailabilityInfo targetInfo = this.createRevisionAvailabilityInfo2(target);
        CDORevisionAvailabilityInfo sourceInfo = this.createRevisionAvailabilityInfo2(source);
        CDORevisionAvailabilityInfo targetBaseInfo = this.createRevisionAvailabilityInfo2(targetBase);
        CDORevisionAvailabilityInfo sourceBaseInfo = sameBase && !auto ? null : this.createRevisionAvailabilityInfo2(sourceBase);
        CDOSessionProtocol.MergeDataResult result = this.sessionProtocol.loadMergeData2(targetInfo, sourceInfo, targetBaseInfo, sourceBaseInfo);
        if (auto) {
            sourceBase = sourceBaseInfo.getBranchPoint();
            targetBase = targetBaseInfo.getBranchPoint();
            sameBase = sourceBase.equals(targetBase);
        }
        this.cacheRevisions2(targetInfo);
        this.cacheRevisions2(sourceInfo);
        this.cacheRevisions2(targetBaseInfo);
        if (sameBase) {
            sourceBaseInfo = targetBaseInfo;
        } else {
            this.cacheRevisions2(sourceBaseInfo);
        }
        CDOChangeSet targetChanges = null;
        CDOChangeSet sourceChanges = null;
        if (computeChangeSets) {
            targetChanges = this.createChangeSet(result.getTargetIDs(), targetBaseInfo, targetInfo);
            sourceChanges = this.createChangeSet(result.getSourceIDs(), sourceBaseInfo, sourceInfo);
        }
        return new InternalCDOSession.MergeData(target, targetInfo, targetBase, targetBaseInfo, result.getTargetIDs(), targetChanges, source, sourceInfo, sourceBase, sourceBaseInfo, result.getSourceIDs(), sourceChanges, result.getResultBase());
    }

    @Override
    @Deprecated
    public CDORevisionAvailabilityInfo createRevisionAvailabilityInfo(CDOBranchPoint branchPoint) {
        throw new UnsupportedOperationException();
    }

    private CDORevisionAvailabilityInfo createRevisionAvailabilityInfo2(CDOBranchPoint branchPoint) {
        InternalCDORevisionManager revisionManager = this.getRevisionManager();
        CDORevisionAvailabilityInfo info = new CDORevisionAvailabilityInfo(branchPoint, (CDORevisionManager)revisionManager);
        if (branchPoint != CDOBranchUtil.AUTO_BRANCH_POINT) {
            InternalCDORevisionCache cache = revisionManager.getCache();
            List revisions = cache.getRevisions(branchPoint);
            for (CDORevision revision : revisions) {
                if (revision instanceof PointerCDORevision) {
                    PointerCDORevision pointer = (PointerCDORevision)revision;
                    CDOBranchVersion target = pointer.getTarget();
                    if (target != null) {
                        revision = cache.getRevisionByVersion(pointer.getID(), target);
                    }
                } else if (revision instanceof DetachedCDORevision) {
                    revision = null;
                }
                if (revision == null) continue;
                this.resolveAllElementProxies(revision);
                info.addRevision((CDORevisionKey)revision);
            }
        }
        return info;
    }

    @Override
    @Deprecated
    public void cacheRevisions(CDORevisionAvailabilityInfo info) {
        throw new UnsupportedOperationException();
    }

    private void cacheRevisions2(CDORevisionAvailabilityInfo info) {
        InternalCDORevisionManager revisionManager = this.getRevisionManager();
        CDOBranch branch = info.getBranchPoint().getBranch();
        for (CDORevisionKey key : info.getAvailableRevisions().values()) {
            CDORevision revision = (CDORevision)key;
            revisionManager.addRevision(revision);
            if (revision.getBranch() == branch) continue;
            CDOID id = revision.getID();
            CDORevision firstRevision = revisionManager.getCache().getRevisionByVersion(id, branch.getVersion(1));
            if (firstRevision == null) continue;
            long revised = firstRevision.getTimeStamp() - 1L;
            CDOBranchVersion target = CDOBranchUtil.copyBranchVersion((CDOBranchVersion)revision);
            PointerCDORevision pointer = new PointerCDORevision(revision.getEClass(), id, branch, revised, target);
            revisionManager.addRevision((CDORevision)pointer);
        }
    }

    private CDOChangeSet createChangeSet(Set<CDOID> ids, CDORevisionAvailabilityInfo startInfo, CDORevisionAvailabilityInfo endInfo) {
        CDOChangeSetData data = CDORevisionUtil.createChangeSetData(ids, (CDORevisionProvider)startInfo, (CDORevisionProvider)endInfo);
        return CDORevisionUtil.createChangeSet((CDOBranchPoint)startInfo.getBranchPoint(), (CDOBranchPoint)endInfo.getBranchPoint(), (CDOChangeSetData)data);
    }

    protected void doActivate() throws Exception {
        super.doActivate();
        Runnable runnable = SessionUtil.getTestDelayInSessionActivation();
        if (runnable != null) {
            runnable.run();
        }
        CDORemoteSessionManagerImpl remoteSessionManager = new CDORemoteSessionManagerImpl();
        remoteSessionManager.setLocalSession(this);
        this.setRemoteSessionManager(remoteSessionManager);
        remoteSessionManager.activate();
        this.checkState(this.sessionProtocol, "sessionProtocol");
        this.checkState(remoteSessionManager, "remoteSessionManager");
    }

    protected void doAfterActivate() throws Exception {
        super.doAfterActivate();
        ExecutorService executorService = ConcurrencyUtil.getExecutorService((Object)this.sessionProtocol);
        this.invalidator.setExecutor(executorService);
        LifecycleUtil.activate((Object)((Object)this.invalidator));
    }

    @Override
    protected void doDeactivate() throws Exception {
        LifecycleUtil.deactivate((Object)((Object)this.invalidator));
        super.doDeactivate();
        this.unhookSessionProtocol();
        InternalCDORemoteSessionManager remoteSessionManager = this.getRemoteSessionManager();
        this.setRemoteSessionManager(null);
        LifecycleUtil.deactivate((Object)remoteSessionManager);
        CDOSessionProtocol sessionProtocol = this.getSessionProtocol();
        LifecycleUtil.deactivate((Object)sessionProtocol);
        this.setSessionProtocol(null);
    }

    protected CDOSessionProtocol hookSessionProtocol() {
        EventUtil.addListener((Object)this.sessionProtocol, (IListener)this.sessionProtocolListener);
        return this.sessionProtocol;
    }

    protected void unhookSessionProtocol() {
        EventUtil.removeListener((Object)this.sessionProtocol, (IListener)this.sessionProtocolListener);
    }

    protected void sessionProtocolDeactivated() {
        this.deactivate();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class Invalidation
    extends RunnableWithName
    implements Comparable<Invalidation> {
        private final InternalCDOSession.InvalidationData invalidationData;
        private final CDOCommitInfo commitInfo;

        public Invalidation(InternalCDOSession.InvalidationData invalidationData) {
            this.invalidationData = invalidationData;
            this.commitInfo = invalidationData.getCommitInfo();
        }

        public long getTimeStamp() {
            return this.commitInfo.getTimeStamp();
        }

        public long getPreviousTimeStamp() {
            return this.commitInfo.getPreviousTimeStamp();
        }

        @Override
        public int compareTo(Invalidation o) {
            return CDOCommonUtil.compareTimeStamps((long)this.getTimeStamp(), (long)o.getTimeStamp());
        }

        public String toString() {
            return Long.toString(this.getTimeStamp() % 10000L);
        }

        public String getName() {
            return "CDOSessionInvalidator-" + CDOSessionImpl.this;
        }

        protected void doRun() {
            long timeStamp = this.getTimeStamp();
            try {
                try {
                    boolean success;
                    InternalCDOView[] views = CDOSessionImpl.this.getViews();
                    Map<CDORevision, CDOPermission> oldPermissions = null;
                    Map<CDOID, InternalCDORevision> oldRevisions = null;
                    CDOBranch branch = this.commitInfo.getBranch();
                    boolean bl = success = branch != null;
                    if (success) {
                        oldRevisions = this.reviseRevisions();
                        if (this.invalidationData.getSecurityImpact() != 0) {
                            oldPermissions = this.updatePermissions(views);
                        }
                        CDOSessionImpl.this.commitInfoManager.setLastCommitOfBranch(branch, timeStamp);
                    }
                    if (CDOSessionImpl.this.options.isPassiveUpdateEnabled()) {
                        CDOSessionImpl.this.setLastUpdateTime(timeStamp);
                    }
                    CDOLockChangeInfo lockChangeInfo = this.invalidationData.getLockChangeInfo();
                    InternalCDOTransaction sender = this.invalidationData.getSender();
                    if (success) {
                        CDOSessionImpl.this.fireEvent(new InvalidationEvent(sender, this.commitInfo, this.invalidationData.getSecurityImpact(), oldPermissions));
                        CDOSessionImpl.this.fireEvent(new SessionLocksChangedEvent((InternalCDOView)sender, lockChangeInfo));
                        CDOSessionImpl.this.commitInfoManager.notifyCommitInfoHandlers(this.commitInfo);
                    }
                    InternalCDOView[] internalCDOViewArray = views;
                    int n = views.length;
                    int n2 = 0;
                    while (n2 < n) {
                        InternalCDOView view = internalCDOViewArray[n2];
                        this.invalidateView(this.commitInfo, view, sender, oldRevisions, this.invalidationData.isClearResourcePathCache(), lockChangeInfo);
                        ++n2;
                    }
                }
                catch (RuntimeException ex) {
                    if (CDOSessionImpl.this.isActive()) {
                        throw ex;
                    }
                    if (TRACER.isEnabled()) {
                        TRACER.trace(Messages.getString("CDOSessionImpl.2"));
                    }
                    CDOSessionImpl.this.invalidator.scheduleInvalidations();
                }
            }
            finally {
                CDOSessionImpl.this.invalidator.scheduleInvalidations();
            }
        }

        private Map<CDORevision, CDOPermission> updatePermissions(InternalCDOView[] views) {
            CDOPermissionUpdater permissionUpdater = CDOSessionImpl.this.options().getPermissionUpdater();
            if (permissionUpdater != null) {
                CDOBranchPoint head = CDOSessionImpl.this.getBranchManager().getMainBranch().getHead();
                HashSet<InternalCDORevision> revisions = new HashSet<InternalCDORevision>();
                int i = 0;
                while (i < views.length) {
                    InternalCDOView view = views[i];
                    if (!head.equals(view)) {
                        throw new IllegalStateException("Security not supported with auditing or branching");
                    }
                    block5: for (InternalCDOObject object : view.getObjects().values()) {
                        InternalCDORevision revision;
                        CDOState state = object.cdoState();
                        switch (state) {
                            case CLEAN: {
                                revision = object.cdoRevision();
                                break;
                            }
                            case DIRTY: 
                            case CONFLICT: {
                                CDOID id = object.cdoID();
                                revision = CDOSessionImpl.this.getRevisionManager().getRevision(id, head, 0, 0, false);
                                break;
                            }
                            default: {
                                continue block5;
                            }
                        }
                        if (revision == null || this.commitInfo.getDetachedObjects().contains(CDOIDUtil.createIDAndVersion((CDOIDAndVersion)revision))) continue;
                        revisions.add(revision);
                    }
                    ++i;
                }
                return permissionUpdater.updatePermissions(CDOSessionImpl.this, revisions);
            }
            return null;
        }

        private Map<CDOID, InternalCDORevision> reviseRevisions() {
            CDOID id;
            Map oldRevisions = null;
            CDOBranch newBranch = this.commitInfo.getBranch();
            long timeStamp = this.getTimeStamp();
            for (CDOIDAndVersion key : this.commitInfo.getNewObjects()) {
                if (!(key instanceof InternalCDORevision)) continue;
                InternalCDORevision newRevision = (InternalCDORevision)key;
                this.addNewRevision(newRevision);
            }
            for (CDOIDAndVersion key : this.commitInfo.getChangedObjects()) {
                id = key.getID();
                if (key instanceof CDORevisionDelta) {
                    CDORevisionDelta revisionDelta = (CDORevisionDelta)key;
                    InternalCDORevision oldRevision = CDOSessionImpl.this.revisionManager.getRevisionByVersion(id, (CDOBranchVersion)revisionDelta, -1, false);
                    if (oldRevision == null) continue;
                    CDOSessionImpl.this.addOldValuesToDelta((CDORevision)oldRevision, revisionDelta);
                    InternalCDORevision newRevision = oldRevision.copy();
                    newRevision.adjustForCommit(newBranch, timeStamp);
                    CDORevisable target = revisionDelta.getTarget();
                    if (target != null) {
                        newRevision.setVersion(target.getVersion());
                    }
                    boolean bypassPermissionChecks = newRevision.bypassPermissionChecks(true);
                    try {
                        revisionDelta.applyTo((CDORevision)newRevision);
                    }
                    finally {
                        newRevision.bypassPermissionChecks(bypassPermissionChecks);
                        newRevision.freeze();
                    }
                    this.addNewRevision(newRevision);
                    if (oldRevisions == null) {
                        oldRevisions = CDOIDUtil.createMap();
                    }
                    oldRevisions.put(id, oldRevision);
                    continue;
                }
                if (key.getBranch() != newBranch) continue;
                CDOSessionImpl.this.revisionManager.reviseVersion(id, (CDOBranchVersion)key, timeStamp);
            }
            for (CDOIDAndVersion key : this.commitInfo.getDetachedObjects()) {
                id = key.getID();
                CDOSessionImpl.this.revisionManager.reviseLatest(id, newBranch);
            }
            return oldRevisions;
        }

        private void addNewRevision(InternalCDORevision newRevision) {
            CDOPermission newPermission;
            Map<CDOID, CDOPermission> newPermissions = this.invalidationData.getNewPermissions();
            if (newPermissions != null && (newPermission = newPermissions.get(newRevision.getID())) != null) {
                newRevision.setPermission(newPermission);
            }
            CDOSessionImpl.this.revisionManager.addRevision((CDORevision)newRevision);
        }

        private void invalidateView(CDOCommitInfo commitInfo, InternalCDOView view, InternalCDOTransaction sender, Map<CDOID, InternalCDORevision> oldRevisions, boolean clearResourcePathCache, CDOLockChangeInfo lockChangeInfo) {
            block4: {
                try {
                    InternalCDOView.ViewInvalidationData invalidationData = new InternalCDOView.ViewInvalidationData();
                    invalidationData.setLastUpdateTime(this.getTimeStamp());
                    invalidationData.setAsync(true);
                    if (view != sender) {
                        invalidationData.setBranch(commitInfo.getBranch());
                        invalidationData.setAllChangedObjects(commitInfo.getChangedObjects());
                        invalidationData.setAllDetachedObjects(commitInfo.getDetachedObjects());
                        invalidationData.setOldRevisions(oldRevisions);
                        invalidationData.setClearResourcePathCache(clearResourcePathCache);
                        invalidationData.setLockChangeInfo(lockChangeInfo);
                    }
                    view.invalidate(invalidationData);
                }
                catch (RuntimeException ex) {
                    if (view.isActive()) {
                        OM.LOG.error((Throwable)ex);
                    }
                    if (!TRACER.isEnabled()) break block4;
                    TRACER.trace(Messages.getString("CDOSessionImpl.1"));
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class InvalidationEvent
    extends Event
    implements InternalCDOSessionInvalidationEvent {
        private static final long serialVersionUID = 1L;
        private InternalCDOTransaction sender;
        private CDOCommitInfo commitInfo;
        private byte securityImpact;
        private Map<CDORevision, CDOPermission> oldPermissions;

        public InvalidationEvent(InternalCDOTransaction sender, CDOCommitInfo commitInfo, byte securityImpact, Map<CDORevision, CDOPermission> oldPermissions) {
            super((INotifier)CDOSessionImpl.this);
            this.sender = sender;
            this.commitInfo = commitInfo;
            this.securityImpact = securityImpact;
            this.oldPermissions = oldPermissions;
        }

        @Override
        public CDOSession getSource() {
            return (CDOSession)super.getSource();
        }

        public CDOCommitInfoManager getCommitInfoManager() {
            return this.commitInfo.getCommitInfoManager();
        }

        @Override
        public CDOTransaction getLocalTransaction() {
            return this.sender;
        }

        @Override
        @Deprecated
        public InternalCDOView getView() {
            return this.sender;
        }

        @Override
        public boolean isRemote() {
            return this.sender == null;
        }

        public CDOBranch getBranch() {
            return this.commitInfo.getBranch();
        }

        public long getTimeStamp() {
            return this.commitInfo.getTimeStamp();
        }

        public long getPreviousTimeStamp() {
            return this.commitInfo.getPreviousTimeStamp();
        }

        public CDOCommitInfo getPreviousCommitInfo() {
            return this.commitInfo.getPreviousCommitInfo();
        }

        public String getUserID() {
            return this.commitInfo.getUserID();
        }

        public String getComment() {
            return this.commitInfo.getComment();
        }

        public CDOBranchPoint getMergeSource() {
            return this.commitInfo.getMergeSource();
        }

        public CDOCommitInfo getMergedCommitInfo() {
            CDOBranchPoint mergeSource = this.getMergeSource();
            return mergeSource == null ? null : CDOSessionImpl.this.commitInfoManager.getCommitInfo(mergeSource.getBranch(), mergeSource.getTimeStamp(), false);
        }

        public boolean isEmpty() {
            return false;
        }

        public boolean isInitialCommit() {
            return this.commitInfo.isInitialCommit();
        }

        public boolean isCommitDataLoaded() {
            return this.commitInfo.isCommitDataLoaded();
        }

        public CDOChangeSetData copy() {
            return this.commitInfo.copy();
        }

        public void merge(CDOChangeSetData changeSetData) {
            this.commitInfo.merge(changeSetData);
        }

        public List<CDOPackageUnit> getNewPackageUnits() {
            return this.commitInfo.getNewPackageUnits();
        }

        public List<CDOIDAndVersion> getNewObjects() {
            return this.commitInfo.getNewObjects();
        }

        public List<CDORevisionKey> getChangedObjects() {
            return this.commitInfo.getChangedObjects();
        }

        public List<CDOIDAndVersion> getDetachedObjects() {
            return this.commitInfo.getDetachedObjects();
        }

        public Map<CDOID, CDOChangeKind> getChangeKinds() {
            return this.commitInfo.getChangeKinds();
        }

        public CDOChangeKind getChangeKind(CDOID id) {
            return this.commitInfo.getChangeKind(id);
        }

        @Override
        public byte getSecurityImpact() {
            return this.securityImpact;
        }

        @Override
        public Map<CDORevision, CDOPermission> getOldPermissions() {
            return this.oldPermissions;
        }

        public String toString() {
            return "CDOSessionInvalidationEvent[" + this.commitInfo + "]";
        }
    }

    private class Invalidator
    extends ExecutorWorkSerializer {
        private static final boolean DEBUG = false;
        private final Set<Object> unfinishedLocalCommits = new HashSet<Object>();
        private final List<Invalidation> reorderQueue = new ArrayList<Invalidation>();
        private boolean terminateIfSessionClosed;
        private int lastCommitNumber;

        public synchronized Object startLocalCommit() {
            if (!this.isActive()) {
                return null;
            }
            InternalCDOSession.CommitToken token = new InternalCDOSession.CommitToken(++this.lastCommitNumber, Thread.currentThread().getName());
            this.unfinishedLocalCommits.add(token);
            return token;
        }

        public synchronized void endLocalCommit(Object token) {
            this.unfinishedLocalCommits.remove(token);
        }

        public synchronized void reorderInvalidations(InternalCDOSession.InvalidationData invalidationData) {
            Invalidation invalidation = new Invalidation(invalidationData);
            this.reorderQueue.add(invalidation);
            Collections.sort(this.reorderQueue);
            this.scheduleInvalidations();
        }

        public synchronized void scheduleInvalidations() {
            while (!this.reorderQueue.isEmpty() && this.canProcess(this.reorderQueue.get(0))) {
                Invalidation invalidation0 = this.reorderQueue.remove(0);
                this.addWork((Runnable)((Object)invalidation0));
            }
        }

        protected boolean canProcess(Invalidation invalidation) {
            if (CDOSessionImpl.this.options().isPassiveUpdateEnabled()) {
                long lastUpdateTime;
                long previousTimeStamp = invalidation.getPreviousTimeStamp();
                return previousTimeStamp <= (lastUpdateTime = CDOSessionImpl.this.getLastUpdateTime());
            }
            return this.unfinishedLocalCommits.size() == 1;
        }

        protected void noWork() {
            if (CDOSessionImpl.this.isClosed() && this.terminateIfSessionClosed) {
                this.dispose();
            }
        }

        protected void doAfterActivate() throws Exception {
            super.doAfterActivate();
            this.terminateIfSessionClosed = true;
        }
    }

    private static final class LastUpdateTimeLock {
        private LastUpdateTimeLock() {
        }
    }

    protected class OptionsImpl
    extends Notifier
    implements CDOSession.Options {
        private boolean generatedPackageEmulationEnabled;
        private boolean passiveUpdateEnabled = true;
        private CDOCommonSession.Options.PassiveUpdateMode passiveUpdateMode = CDOCommonSession.Options.PassiveUpdateMode.INVALIDATIONS;
        private CDOCommonSession.Options.LockNotificationMode lockNotificationMode = CDOCommonSession.Options.LockNotificationMode.IF_REQUIRED_BY_VIEWS;
        private CDOCollectionLoadingPolicy collectionLoadingPolicy;
        private CDOLobStore lobCache = CDOLobStoreImpl.INSTANCE;
        private CDOPermissionUpdater permissionUpdater = CDOPermissionUpdater.SERVER;
        private boolean delegableViewLockEnabled;

        public OptionsImpl() {
            this.setCollectionLoadingPolicy(null);
        }

        public CDOSession getContainer() {
            return CDOSessionImpl.this;
        }

        public boolean isGeneratedPackageEmulationEnabled() {
            return this.generatedPackageEmulationEnabled;
        }

        public synchronized void setGeneratedPackageEmulationEnabled(boolean generatedPackageEmulationEnabled) {
            this.generatedPackageEmulationEnabled = generatedPackageEmulationEnabled;
            if (this.generatedPackageEmulationEnabled != generatedPackageEmulationEnabled) {
                this.generatedPackageEmulationEnabled = generatedPackageEmulationEnabled;
                IListener[] listeners = this.getListeners();
                if (listeners != null) {
                    this.fireEvent((IEvent)new GeneratedPackageEmulationEventImpl(), listeners);
                }
            }
        }

        public boolean isPassiveUpdateEnabled() {
            return this.passiveUpdateEnabled;
        }

        public synchronized void setPassiveUpdateEnabled(boolean passiveUpdateEnabled) {
            if (this.passiveUpdateEnabled != passiveUpdateEnabled) {
                this.passiveUpdateEnabled = passiveUpdateEnabled;
                CDOSessionProtocol protocol = CDOSessionImpl.this.getSessionProtocol();
                if (protocol != null) {
                    if (passiveUpdateEnabled) {
                        CDOSessionImpl.this.refresh(true);
                    } else {
                        protocol.disablePassiveUpdate();
                    }
                    IListener[] listeners = this.getListeners();
                    if (listeners != null) {
                        this.fireEvent((IEvent)new PassiveUpdateEventImpl(!passiveUpdateEnabled, passiveUpdateEnabled, this.passiveUpdateMode, this.passiveUpdateMode), listeners);
                    }
                }
            }
        }

        public CDOCommonSession.Options.PassiveUpdateMode getPassiveUpdateMode() {
            return this.passiveUpdateMode;
        }

        public void setPassiveUpdateMode(CDOCommonSession.Options.PassiveUpdateMode passiveUpdateMode) {
            CDOSessionImpl.this.checkArg(passiveUpdateMode, "passiveUpdateMode");
            if (this.passiveUpdateMode != passiveUpdateMode) {
                CDOCommonSession.Options.PassiveUpdateMode oldMode = this.passiveUpdateMode;
                this.passiveUpdateMode = passiveUpdateMode;
                CDOSessionProtocol protocol = CDOSessionImpl.this.getSessionProtocol();
                if (protocol != null) {
                    protocol.setPassiveUpdateMode(passiveUpdateMode);
                    IListener[] listeners = this.getListeners();
                    if (listeners != null) {
                        this.fireEvent((IEvent)new PassiveUpdateEventImpl(this.passiveUpdateEnabled, this.passiveUpdateEnabled, oldMode, passiveUpdateMode), listeners);
                    }
                }
            }
        }

        public CDOCommonSession.Options.LockNotificationMode getLockNotificationMode() {
            return this.lockNotificationMode;
        }

        public void setLockNotificationMode(CDOCommonSession.Options.LockNotificationMode lockNotificationMode) {
            CDOSessionImpl.this.checkArg(lockNotificationMode, "lockNotificationMode");
            if (this.lockNotificationMode != lockNotificationMode) {
                CDOCommonSession.Options.LockNotificationMode oldMode = this.lockNotificationMode;
                this.lockNotificationMode = lockNotificationMode;
                CDOSessionProtocol protocol = CDOSessionImpl.this.getSessionProtocol();
                if (protocol != null) {
                    protocol.setLockNotificationMode(lockNotificationMode);
                    IListener[] listeners = this.getListeners();
                    if (listeners != null) {
                        this.fireEvent((IEvent)new LockNotificationModeEventImpl(oldMode, lockNotificationMode), listeners);
                    }
                }
            }
            this.lockNotificationMode = lockNotificationMode;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CDOCollectionLoadingPolicy getCollectionLoadingPolicy() {
            OptionsImpl optionsImpl = this;
            synchronized (optionsImpl) {
                return this.collectionLoadingPolicy;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setCollectionLoadingPolicy(CDOCollectionLoadingPolicy policy) {
            CDOSession oldSession;
            if (policy == null) {
                policy = CDOUtil.createCollectionLoadingPolicy(-1, -1);
            }
            if ((oldSession = policy.getSession()) != null) {
                throw new IllegalArgumentException("Policy is already associated with " + oldSession);
            }
            policy.setSession(CDOSessionImpl.this);
            IListener[] listeners = this.getListeners();
            CollectionLoadingPolicyEventImpl event = null;
            OptionsImpl optionsImpl = this;
            synchronized (optionsImpl) {
                if (this.collectionLoadingPolicy != policy) {
                    this.collectionLoadingPolicy = policy;
                    if (listeners != null) {
                        event = new CollectionLoadingPolicyEventImpl();
                    }
                }
            }
            if (event != null) {
                this.fireEvent((IEvent)event, listeners);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CDOLobStore getLobCache() {
            OptionsImpl optionsImpl = this;
            synchronized (optionsImpl) {
                return this.lobCache;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setLobCache(CDOLobStore cache) {
            if (cache == null) {
                cache = CDOLobStoreImpl.INSTANCE;
            }
            IListener[] listeners = this.getListeners();
            LobCacheEventImpl event = null;
            OptionsImpl optionsImpl = this;
            synchronized (optionsImpl) {
                if (this.lobCache != cache) {
                    this.lobCache = cache;
                    if (listeners != null) {
                        event = new LobCacheEventImpl();
                    }
                }
            }
            if (event != null) {
                this.fireEvent((IEvent)event, listeners);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CDOPermissionUpdater getPermissionUpdater() {
            OptionsImpl optionsImpl = this;
            synchronized (optionsImpl) {
                return this.permissionUpdater;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setPermissionUpdater(CDOPermissionUpdater permissionUpdater) {
            IListener[] listeners = this.getListeners();
            PermissionUpdaterEventImpl event = null;
            OptionsImpl optionsImpl = this;
            synchronized (optionsImpl) {
                if (this.permissionUpdater != permissionUpdater) {
                    this.permissionUpdater = permissionUpdater;
                    if (listeners != null) {
                        event = new PermissionUpdaterEventImpl();
                    }
                }
            }
            if (event != null) {
                this.fireEvent((IEvent)event, listeners);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isDelegableViewLockEnabled() {
            OptionsImpl optionsImpl = this;
            synchronized (optionsImpl) {
                return this.delegableViewLockEnabled;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setDelegableViewLockEnabled(boolean delegableViewLockEnabled) {
            IListener[] listeners = this.getListeners();
            DelegableViewLockEventImpl event = null;
            OptionsImpl optionsImpl = this;
            synchronized (optionsImpl) {
                if (this.delegableViewLockEnabled != delegableViewLockEnabled) {
                    this.delegableViewLockEnabled = delegableViewLockEnabled;
                    if (listeners != null) {
                        event = new DelegableViewLockEventImpl();
                    }
                }
            }
            if (event != null) {
                this.fireEvent((IEvent)event, listeners);
            }
        }

        private final class CollectionLoadingPolicyEventImpl
        extends OptionsEvent
        implements CDOSession.Options.CollectionLoadingPolicyEvent {
            private static final long serialVersionUID = 1L;

            public CollectionLoadingPolicyEventImpl() {
                super((IOptions)OptionsImpl.this);
            }
        }

        private final class DelegableViewLockEventImpl
        extends OptionsEvent
        implements CDOSession.Options.DelegableViewLockEvent {
            private static final long serialVersionUID = 1L;

            public DelegableViewLockEventImpl() {
                super((IOptions)OptionsImpl.this);
            }
        }

        private final class GeneratedPackageEmulationEventImpl
        extends OptionsEvent
        implements CDOSession.Options.GeneratedPackageEmulationEvent {
            private static final long serialVersionUID = 1L;

            public GeneratedPackageEmulationEventImpl() {
                super((IOptions)OptionsImpl.this);
            }
        }

        private final class LobCacheEventImpl
        extends OptionsEvent
        implements CDOSession.Options.LobCacheEvent {
            private static final long serialVersionUID = 1L;

            public LobCacheEventImpl() {
                super((IOptions)OptionsImpl.this);
            }
        }

        private final class LockNotificationModeEventImpl
        extends OptionsEvent
        implements CDOCommonSession.Options.LockNotificationModeEvent {
            private static final long serialVersionUID = 1L;
            private CDOCommonSession.Options.LockNotificationMode oldMode;
            private CDOCommonSession.Options.LockNotificationMode newMode;

            public LockNotificationModeEventImpl(CDOCommonSession.Options.LockNotificationMode oldMode, CDOCommonSession.Options.LockNotificationMode newMode) {
                super((IOptions)OptionsImpl.this);
                this.oldMode = oldMode;
                this.newMode = newMode;
            }

            public CDOCommonSession.Options.LockNotificationMode getOldMode() {
                return this.oldMode;
            }

            public CDOCommonSession.Options.LockNotificationMode getNewMode() {
                return this.newMode;
            }
        }

        private final class PassiveUpdateEventImpl
        extends OptionsEvent
        implements CDOCommonSession.Options.PassiveUpdateEvent {
            private static final long serialVersionUID = 1L;
            private boolean oldEnabled;
            private boolean newEnabled;
            private CDOCommonSession.Options.PassiveUpdateMode oldMode;
            private CDOCommonSession.Options.PassiveUpdateMode newMode;

            public PassiveUpdateEventImpl(boolean oldEnabled, boolean newEnabled, CDOCommonSession.Options.PassiveUpdateMode oldMode, CDOCommonSession.Options.PassiveUpdateMode newMode) {
                super((IOptions)OptionsImpl.this);
                this.oldEnabled = oldEnabled;
                this.newEnabled = newEnabled;
                this.oldMode = oldMode;
                this.newMode = newMode;
            }

            public boolean getOldEnabled() {
                return this.oldEnabled;
            }

            public boolean getNewEnabled() {
                return this.newEnabled;
            }

            public CDOCommonSession.Options.PassiveUpdateMode getOldMode() {
                return this.oldMode;
            }

            public CDOCommonSession.Options.PassiveUpdateMode getNewMode() {
                return this.newMode;
            }
        }

        private final class PermissionUpdaterEventImpl
        extends OptionsEvent
        implements CDOSession.Options.PermissionUpdaterEvent {
            private static final long serialVersionUID = 1L;

            public PermissionUpdaterEventImpl() {
                super((IOptions)OptionsImpl.this);
            }
        }
    }

    private final class SessionLocksChangedEvent
    extends DefaultLocksChangedEvent
    implements CDOSessionLocksChangedEvent {
        private static final long serialVersionUID = 1L;

        public SessionLocksChangedEvent(InternalCDOView sender, CDOLockChangeInfo lockChangeInfo) {
            super((INotifier)CDOSessionImpl.this, sender, lockChangeInfo);
        }

        public CDOSession getSource() {
            return (CDOSession)super.getSource();
        }

        protected String formatEventName() {
            return "CDOSessionLocksChangedEvent";
        }
    }
}

