/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.internal.tools.wizards.classes;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.conversion.Converter;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.MultiValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.internal.tools.Messages;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.TypedElementSelectionValidator;
import org.eclipse.jdt.internal.ui.wizards.TypedViewerFilter;
import org.eclipse.jdt.ui.JavaElementComparator;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.StandardJavaElementContentProvider;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.IWidgetValueProperty;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.wizard.WizardPageSupport;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;

public abstract class AbstractNewClassPage
extends WizardPage {
    private static final String BUNDLECLASS = "bundleclass://";
    private static final String FRAGMENT_ROOT = "fragmentRoot";
    public static final String PACKAGE_FRAGMENT = "packageFragment";
    public static final String PROPERTY_NAME = "name";
    private JavaClass clazz;
    private IPackageFragmentRoot froot;
    private final IWorkspaceRoot fWorkspaceRoot;
    private String initialString;
    private String initialPackage;

    protected AbstractNewClassPage(String pageName, String title, String description, IPackageFragmentRoot froot, IWorkspaceRoot fWorkspaceRoot) {
        super(pageName);
        this.froot = froot;
        this.fWorkspaceRoot = fWorkspaceRoot;
        this.setTitle(title);
        this.setDescription(description);
    }

    protected AbstractNewClassPage(String pageName, String title, String description, IPackageFragmentRoot froot, IWorkspaceRoot fWorkspaceRoot, String initialString) {
        this(pageName, title, description, froot, fWorkspaceRoot);
        this.initialString = initialString;
    }

    public void init(IStructuredSelection selection) {
        if (selection == null || selection.isEmpty() || selection.getFirstElement() == null) {
            return;
        }
        if (selection.getFirstElement() instanceof IPackageFragment) {
            IPackageFragment pkg = (IPackageFragment)selection.getFirstElement();
            this.initialPackage = pkg.getElementName();
        }
    }

    public void createControl(Composite parent) {
        final Image img = new Image((Device)parent.getDisplay(), ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("/icons/full/wizban/newclass_wiz.png"));
        this.setImageDescriptor(ImageDescriptor.createFromImage((Image)img));
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                img.dispose();
                AbstractNewClassPage.this.setImageDescriptor(null);
            }
        });
        parent = new Composite(parent, 0);
        parent.setLayoutData((Object)new GridData(1808));
        parent.setLayout((Layout)new GridLayout(3, false));
        this.clazz = this.createInstance();
        if (this.froot != null && this.initialString != null) {
            this.clazz.setPackageFragment(this.froot.getPackageFragment(this.parseInitialStringForPackage(this.initialString) == null ? "" : this.parseInitialStringForPackage(this.initialString)));
            this.clazz.setName(this.parseInitialStringForClassName(this.initialString));
        } else if (this.froot != null && this.initialPackage != null) {
            this.clazz.setPackageFragment(this.froot.getPackageFragment(this.initialPackage));
        }
        DataBindingContext dbc = new DataBindingContext();
        WizardPageSupport.create((WizardPage)this, (DataBindingContext)dbc);
        Label l = new Label(parent, 0);
        l.setText(Messages.AbstractNewClassPage_SourceFolder);
        Text t = new Text(parent, 2048);
        t.setLayoutData((Object)new GridData(768));
        t.setEditable(false);
        final Binding bd = dbc.bindValue((IObservableValue)WidgetProperties.text().observe((Widget)t), BeanProperties.value((String)FRAGMENT_ROOT).observe((Object)this.clazz), new UpdateValueStrategy().setBeforeSetValidator((IValidator)new PFRootValidator()), new UpdateValueStrategy().setConverter((IConverter)new PackageFragmentRootToStringConverter()));
        Button b = new Button(parent, 8);
        b.setText(Messages.AbstractNewClassPage_Browse);
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IPackageFragmentRoot root = AbstractNewClassPage.this.choosePackageRoot();
                if (root != null) {
                    AbstractNewClassPage.this.froot = root;
                    AbstractNewClassPage.this.clazz.setFragmentRoot(root);
                }
                bd.updateModelToTarget();
            }
        });
        Label l2 = new Label(parent, 0);
        l2.setText(Messages.AbstractNewClassPage_Package);
        Text tClassPackage = new Text(parent, 2048);
        tClassPackage.setEditable(true);
        tClassPackage.setLayoutData((Object)new GridData(768));
        bd = dbc.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)tClassPackage), BeanProperties.value((String)PACKAGE_FRAGMENT).observe((Object)this.clazz), new UpdateValueStrategy().setConverter((IConverter)new StringToPackageFragmentConverter(this.clazz)), new UpdateValueStrategy().setConverter((IConverter)new PackageFragmentToStringConverter()));
        b = new Button(parent, 8);
        b.setText(Messages.AbstractNewClassPage_Browse);
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IPackageFragment fragment = AbstractNewClassPage.this.choosePackage();
                if (fragment != null) {
                    AbstractNewClassPage.this.clazz.setPackageFragment(fragment);
                }
                bd.updateModelToTarget();
            }
        });
        IWidgetValueProperty textProp = WidgetProperties.text((int)24);
        Label l3 = new Label(parent, 0);
        l3.setText(Messages.AbstractNewClassPage_Name);
        Text tClassName = new Text(parent, 2048);
        tClassName.setLayoutData((Object)new GridData(768));
        dbc.bindValue((IObservableValue)textProp.observe((Widget)tClassName), BeanProperties.value((String)PROPERTY_NAME, String.class).observe((Object)this.clazz), new UpdateValueStrategy().setBeforeSetValidator((IValidator)new ClassnameValidator()), null);
        new Label(parent, 0);
        Label l4 = new Label(parent, 258);
        l4.setLayoutData((Object)new GridData(4, 2, false, false, 3, 1));
        ISWTObservableValue obsPackage = WidgetProperties.text((int)24).observe((Widget)tClassPackage);
        ISWTObservableValue obsClass = WidgetProperties.text((int)24).observe((Widget)tClassName);
        ClassMultiValidator multiValidator = new ClassMultiValidator(this.clazz, (IObservableValue<String>)obsPackage, (IObservableValue<String>)obsClass);
        dbc.addValidationStatusProvider((ValidationStatusProvider)multiValidator);
        this.createFields(parent, dbc);
        this.setControl((Control)parent);
    }

    private String parseInitialStringForPackage(String initialString2) {
        if (initialString2 == null) {
            return null;
        }
        int ioBC = initialString2.indexOf(BUNDLECLASS);
        int iSecondSlash = initialString2.lastIndexOf(47);
        if (initialString2.length() == 0 || ioBC == -1 || iSecondSlash == -1 || initialString2.indexOf(46) == -1) {
            return null;
        }
        int lastDot = initialString2.lastIndexOf(46);
        String packageString = initialString2.substring(iSecondSlash + 1, lastDot);
        return packageString;
    }

    private String parseInitialStringForClassName(String initialString) {
        if (initialString == null) {
            return null;
        }
        int ioBC = initialString.indexOf(BUNDLECLASS);
        int iSecondSlash = initialString.lastIndexOf(47);
        if (initialString.length() == 0 || ioBC == -1 || iSecondSlash == -1 || initialString.indexOf(46) == -1) {
            return null;
        }
        int lastDot = initialString.lastIndexOf(46);
        if (lastDot != -1) {
            return initialString.substring(lastDot + 1);
        }
        return null;
    }

    private IPackageFragmentRoot choosePackageRoot() {
        IPackageFragmentRoot initElement = this.clazz.getFragmentRoot();
        Class[] acceptedClasses = new Class[]{IPackageFragmentRoot.class, IJavaProject.class};
        TypedElementSelectionValidator validator = new TypedElementSelectionValidator(acceptedClasses, false){

            public boolean isSelectedValid(Object element) {
                try {
                    if (element instanceof IJavaProject) {
                        IJavaProject jproject = (IJavaProject)element;
                        IPath path = jproject.getProject().getFullPath();
                        return jproject.findPackageFragmentRoot(path) != null;
                    }
                    if (element instanceof IPackageFragmentRoot) {
                        return ((IPackageFragmentRoot)element).getKind() == 1;
                    }
                    return true;
                }
                catch (JavaModelException e) {
                    JavaPlugin.log((IStatus)e.getStatus());
                    return false;
                }
            }
        };
        acceptedClasses = new Class[]{IJavaModel.class, IPackageFragmentRoot.class, IJavaProject.class};
        TypedViewerFilter filter = new TypedViewerFilter(acceptedClasses){

            public boolean select(Viewer viewer, Object parent, Object element) {
                if (element instanceof IPackageFragmentRoot) {
                    try {
                        return ((IPackageFragmentRoot)element).getKind() == 1;
                    }
                    catch (JavaModelException e) {
                        JavaPlugin.log((IStatus)e.getStatus());
                        return false;
                    }
                }
                return super.select(viewer, parent, element);
            }
        };
        StandardJavaElementContentProvider provider = new StandardJavaElementContentProvider();
        JavaElementLabelProvider labelProvider = new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT);
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)labelProvider, (ITreeContentProvider)provider);
        dialog.setValidator((ISelectionStatusValidator)validator);
        dialog.setComparator((ViewerComparator)new JavaElementComparator());
        dialog.setTitle(NewWizardMessages.NewContainerWizardPage_ChooseSourceContainerDialog_title);
        dialog.setMessage(NewWizardMessages.NewContainerWizardPage_ChooseSourceContainerDialog_description);
        dialog.addFilter((ViewerFilter)filter);
        dialog.setInput((Object)JavaCore.create((IWorkspaceRoot)this.fWorkspaceRoot));
        dialog.setInitialSelection((Object)initElement);
        dialog.setHelpAvailable(false);
        if (dialog.open() == 0) {
            Object element = dialog.getFirstResult();
            if (element instanceof IJavaProject) {
                IJavaProject jproject = (IJavaProject)element;
                return jproject.getPackageFragmentRoot((IResource)jproject.getProject());
            }
            if (element instanceof IPackageFragmentRoot) {
                return (IPackageFragmentRoot)element;
            }
            return null;
        }
        return null;
    }

    private IPackageFragment choosePackage() {
        Object[] packages = null;
        try {
            if (this.froot != null && this.froot.exists()) {
                packages = this.froot.getChildren();
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        if (packages == null) {
            packages = new IJavaElement[]{};
        }
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT));
        dialog.setIgnoreCase(false);
        dialog.setTitle(Messages.AbstractNewClassPage_ChoosePackage);
        dialog.setMessage(Messages.AbstractNewClassPage_ChooseAPackage);
        dialog.setEmptyListMessage(Messages.AbstractNewClassPage_NeedToSelectAPackage);
        dialog.setElements(packages);
        dialog.setHelpAvailable(false);
        IPackageFragment pack = this.clazz.getPackageFragment();
        if (pack != null) {
            dialog.setInitialSelections(new Object[]{pack});
        }
        if (dialog.open() == 0) {
            return (IPackageFragment)dialog.getFirstResult();
        }
        return null;
    }

    protected abstract void createFields(Composite var1, DataBindingContext var2);

    protected abstract JavaClass createInstance();

    public JavaClass getClazz() {
        return this.clazz;
    }

    static class ClassMultiValidator
    extends MultiValidator {
        private final JavaClass javaClass;
        private final IObservableValue<String> observedPackage;
        private final IObservableValue<String> observedClass;

        public ClassMultiValidator(JavaClass javaClass, IObservableValue<String> observedPackage, IObservableValue<String> observedClass) {
            this.javaClass = javaClass;
            this.observedPackage = observedPackage;
            this.observedClass = observedClass;
        }

        protected IStatus validate() {
            String classPackage = (String)this.observedPackage.getValue();
            String className = (String)this.observedClass.getValue();
            IPackageFragment packageFragment = this.javaClass.getFragmentRoot().getPackageFragment(classPackage);
            if (JavaClass.exists(this.javaClass.getFragmentRoot(), packageFragment, className)) {
                return new Status(4, "org.eclipse.e4.tools", Messages.AbstractNewClassPage_ClassExists);
            }
            return ValidationStatus.ok();
        }
    }

    static class ClassnameValidator
    implements IValidator {
        ClassnameValidator() {
        }

        public IStatus validate(Object value) {
            String name = value.toString();
            if (name.length() == 0) {
                return new Status(4, "org.eclipse.e4.tools", Messages.AbstractNewClassPage_NameNotEmpty);
            }
            if (name.indexOf(46) != -1 || name.trim().indexOf(32) != -1) {
                return new Status(4, "org.eclipse.e4.tools", Messages.AbstractNewClassPage_NameMustBeQualified);
            }
            return JavaConventions.validateJavaTypeName((String)name, (String)"1.3", (String)"1.3");
        }
    }

    public static class JavaClass {
        protected PropertyChangeSupport support = new PropertyChangeSupport(this);
        private IPackageFragmentRoot fragmentRoot;
        private IPackageFragment packageFragment;
        private String name;

        public JavaClass(IPackageFragmentRoot fragmentRoot) {
            this.fragmentRoot = fragmentRoot;
        }

        public IPackageFragmentRoot getFragmentRoot() {
            return this.fragmentRoot;
        }

        public void setFragmentRoot(IPackageFragmentRoot fragmentRoot) {
            this.fragmentRoot = fragmentRoot;
            this.support.firePropertyChange(AbstractNewClassPage.FRAGMENT_ROOT, this.fragmentRoot, this.fragmentRoot);
        }

        public IPackageFragment getPackageFragment() {
            return this.packageFragment;
        }

        public void setPackageFragment(IPackageFragment packageFragment) {
            this.packageFragment = packageFragment;
            this.support.firePropertyChange(AbstractNewClassPage.PACKAGE_FRAGMENT, this.packageFragment, this.packageFragment);
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
            this.support.firePropertyChange(AbstractNewClassPage.PROPERTY_NAME, this.name, this.name);
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.support.addPropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.support.removePropertyChangeListener(listener);
        }

        public static boolean exists(IPackageFragmentRoot pFragmentRoot, IPackageFragment pPackageFragment, String pName) {
            IFile file;
            if (pFragmentRoot == null) {
                return false;
            }
            String cuName = String.valueOf(pName) + ".java";
            if (pPackageFragment != null) {
                ICompilationUnit unit = pPackageFragment.getCompilationUnit(cuName);
                IResource resource = unit.getResource();
                file = (IFile)resource;
            } else {
                IFolder p = (IFolder)pFragmentRoot.getResource();
                file = p.getFile(cuName);
            }
            return file.exists();
        }
    }

    static class PFRootValidator
    implements IValidator {
        PFRootValidator() {
        }

        public IStatus validate(Object value) {
            String name = value.toString();
            if (name.length() == 0) {
                return new Status(4, "org.eclipse.e4.tools", Messages.AbstractNewClassPage_SourceFolderNotEmpty);
            }
            return new Status(0, "org.eclipse.e4.tools", "");
        }
    }

    static class PackageFragmentRootToStringConverter
    extends Converter {
        public PackageFragmentRootToStringConverter() {
            super(IPackageFragmentRoot.class, String.class);
        }

        public Object convert(Object fromObject) {
            IPackageFragmentRoot f = (IPackageFragmentRoot)fromObject;
            if (f == null) {
                return "";
            }
            return f.getPath().makeRelative().toString();
        }
    }

    static class PackageFragmentToStringConverter
    extends Converter {
        public PackageFragmentToStringConverter() {
            super(IPackageFragment.class, String.class);
        }

        public Object convert(Object fromObject) {
            if (fromObject == null) {
                return "";
            }
            IPackageFragment f = (IPackageFragment)fromObject;
            return f.getElementName();
        }
    }

    static class StringToPackageFragmentConverter
    extends Converter {
        private final JavaClass clazz;

        public StringToPackageFragmentConverter(JavaClass clazz) {
            super(String.class, IPackageFragment.class);
            this.clazz = clazz;
        }

        public Object convert(Object fromObject) {
            if (this.clazz.getFragmentRoot() == null) {
                return null;
            }
            if (fromObject == null) {
                return this.clazz.getFragmentRoot().getPackageFragment("");
            }
            return this.clazz.getFragmentRoot().getPackageFragment((String)fromObject);
        }
    }
}

