/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ibm.db2.luw.catalog.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ParseXMLFile
implements EntityResolver,
ErrorHandler {
    private Node rootNode = null;
    private InputSource binDTDFile = null;
    private InputSource binXMLFile = null;

    public ParseXMLFile(InputSource DTDFile, InputSource XMLFile, String rootNodeName) throws SAXException, IOException, ParserConfigurationException {
        this.binDTDFile = DTDFile;
        this.binXMLFile = XMLFile;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        builder.setEntityResolver(this);
        builder.setErrorHandler(this);
        Document document = builder.parse(this.binXMLFile);
        this.rootNode = document.getDocumentElement();
        if (rootNodeName != null && !rootNodeName.equals(this.rootNode.getNodeName())) {
            SAXException e = new SAXException("Not our XML file. Root is " + this.rootNode.getNodeName() + " but should be " + rootNodeName);
            throw e;
        }
    }

    public Node getRootNode() {
        return this.rootNode;
    }

    public void setRootNode(Node n) {
        this.rootNode = n;
    }

    public InputSource getBinaryXMLFile() {
        return this.binXMLFile;
    }

    public InputSource getBinaryDTDFile() {
        return this.binDTDFile;
    }

    public void setBinaryXMLFile(InputSource is) {
        this.binXMLFile = is;
    }

    public void setBinaryDTDFile(InputSource is) {
        this.binDTDFile = is;
    }

    public String findAttribute(Node node, String key, String defV) {
        NamedNodeMap nnm = node.getAttributes();
        if (nnm == null) {
            return defV;
        }
        int i = 0;
        while (i < nnm.getLength()) {
            Node attr = nnm.item(i);
            if (key.equals(attr.getNodeName())) {
                return attr.getNodeValue().trim();
            }
            ++i;
        }
        return defV;
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        return this.binDTDFile;
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        String msg = new String("An XML Parser exception occured. Exception Text: " + e.getMessage());
        SAXException err = new SAXException(msg);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream errOut = new PrintStream(baos, true);
        e.printStackTrace(errOut);
        throw err;
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        String msg = new String("An XML Parser exception occured. Exception Text: " + e.getMessage());
        SAXException err = new SAXException(msg);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream errOut = new PrintStream(baos, true);
        e.printStackTrace(errOut);
        throw err;
    }

    @Override
    public void warning(SAXParseException e) throws SAXException {
    }
}

