/*******************************************************************************
 * Copyright (c) 2000, 2011 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *     Sergey Prigogin (Google)
 *     Anton Leherbauer (Wind River Systems)
 *******************************************************************************/
package org.eclipse.cdt.internal.ui.preferences.formatter;

import org.eclipse.osgi.util.NLS;

/**
 * Helper class to get NLSed messages.
 */
final class FormatterMessages extends NLS {

	public static String FormatterTabPage_ShowInvisibleCharacters_label;
	public static String ModifyDialog_BuiltIn_Status;
	public static String ModifyDialog_Duplicate_Status;
	public static String ModifyDialog_EmptyName_Status;
	public static String ModifyDialog_Export_Button;
	public static String ModifyDialog_NewCreated_Status;
	public static String ModifyDialog_ProfileName_Label;
	public static String ModifyDialog_Shared_Status;
	public static String ProfileConfigurationBlock_load_profile_wrong_profile_message;
	public static String WhiteSpaceTabPage_assignments;
	public static String WhiteSpaceTabPage_assignments_before_assignment_operator;
	public static String WhiteSpaceTabPage_assignments_after_assignment_operator;
	public static String WhiteSpaceTabPage_operators;
	public static String WhiteSpaceTabPage_operators_before_binary_operators;
	public static String WhiteSpaceTabPage_operators_after_binary_operators;
	public static String WhiteSpaceTabPage_operators_before_unary_operators;
	public static String WhiteSpaceTabPage_operators_after_unary_operators;
	public static String WhiteSpaceTabPage_operators_before_prefix_operators;
	public static String WhiteSpaceTabPage_operators_after_prefix_operators;
	public static String WhiteSpaceTabPage_operators_before_postfix_operators;
	public static String WhiteSpaceTabPage_operators_after_postfix_operators;
	public static String WhiteSpaceTabPage_classes;
	public static String WhiteSpaceTabPage_classes_before_opening_brace_of_a_class;
	public static String WhiteSpaceTabPage_classes_before_colon_of_base_clause;
	public static String WhiteSpaceTabPage_classes_after_colon_of_base_clause;
	public static String WhiteSpaceTabPage_classes_before_comma_base_types;
	public static String WhiteSpaceTabPage_classes_after_comma_base_types;
	public static String WhiteSpaceTabPage_functions;
	public static String WhiteSpaceTabPage_exception_specifications;
	public static String WhiteSpaceTabPage_declarator_list;
	public static String WhiteSpaceTabPage_declarator_list_before_comma;
	public static String WhiteSpaceTabPage_declarator_list_after_comma;
	public static String WhiteSpaceTabPage_expression_list;
	public static String WhiteSpaceTabPage_expression_list_before_comma;
	public static String WhiteSpaceTabPage_expression_list_after_comma;
	public static String WhiteSpaceTabPage_initializer_list;
	public static String WhiteSpaceTabPage_calls;
	public static String WhiteSpaceTabPage_calls_before_comma_in_function_args;
	public static String WhiteSpaceTabPage_calls_after_comma_in_function_args;
	public static String WhiteSpaceTabPage_statements;
	public static String WhiteSpaceTabPage_blocks;
	public static String WhiteSpaceTabPage_switch;
	public static String WhiteSpaceTabPage_switch_before_case_colon;
	public static String WhiteSpaceTabPage_switch_before_default_colon;
	public static String WhiteSpaceTabPage_do;
	public static String WhiteSpaceTabPage_try;
	public static String WhiteSpaceTabPage_if;
	public static String WhiteSpaceTabPage_for;
	public static String WhiteSpaceTabPage_labels;
	public static String WhiteSpaceTabPage_template_arguments;
	public static String WhiteSpaceTabPage_template_parameters;
	public static String WhiteSpaceTabPage_conditionals;
	public static String WhiteSpaceTabPage_typecasts;
	public static String WhiteSpaceTabPage_parenexpr;
	public static String WhiteSpaceTabPage_declarations;
	public static String WhiteSpaceTabPage_expressions;
	public static String WhiteSpaceTabPage_arrays;
	public static String WhiteSpaceTabPage_templates;
	public static String WhiteSpaceTabPage_after_opening_brace;
	public static String WhiteSpaceTabPage_after_closing_brace;
	public static String WhiteSpaceTabPage_before_opening_brace;
	public static String WhiteSpaceTabPage_before_closing_brace;
	public static String WhiteSpaceTabPage_between_empty_braces;
	public static String WhiteSpaceTabPage_after_opening_paren;
	public static String WhiteSpaceTabPage_after_closing_paren;
	public static String WhiteSpaceTabPage_before_opening_paren;
	public static String WhiteSpaceTabPage_before_closing_paren;
	public static String WhiteSpaceTabPage_between_empty_parens;
	public static String WhiteSpaceTabPage_after_opening_bracket;
	public static String WhiteSpaceTabPage_before_opening_bracket;
	public static String WhiteSpaceTabPage_before_closing_bracket;
	public static String WhiteSpaceTabPage_between_empty_brackets;
	public static String WhiteSpaceTabPage_before_comma_in_params;
	public static String WhiteSpaceTabPage_after_comma_in_params;
	public static String WhiteSpaceTabPage_before_comma;
	public static String WhiteSpaceTabPage_after_comma;
	public static String WhiteSpaceTabPage_after_semicolon;
	public static String WhiteSpaceTabPage_before_semicolon;
	public static String WhiteSpaceTabPage_before_colon;
	public static String WhiteSpaceTabPage_after_colon;
	public static String WhiteSpaceTabPage_before_question;
	public static String WhiteSpaceTabPage_after_question;
	public static String WhiteSpaceTabPage_after_opening_angle_bracket;
	public static String WhiteSpaceTabPage_after_closing_angle_bracket;
	public static String WhiteSpaceTabPage_before_opening_angle_bracket;
	public static String WhiteSpaceTabPage_before_closing_angle_bracket;
//	public static String WhiteSpaceTabPage_before_parenthesized_expressions;
	public static String WhiteSpaceTabPage_insert_space;
	public static String WhiteSpaceTabPage_sort_by_c_element;
	public static String WhiteSpaceTabPage_sort_by_syntax_element;
//	public static String WhiteSpaceOptions_return;
//	public static String WhiteSpaceOptions_throw;
	public static String WhiteSpaceOptions_base_clause;
	public static String WhiteSpaceOptions_before;
	public static String WhiteSpaceOptions_after;
	public static String WhiteSpaceOptions_operator;
	public static String WhiteSpaceOptions_assignment_operator;
	public static String WhiteSpaceOptions_binary_operator;
	public static String WhiteSpaceOptions_unary_operator;
	public static String WhiteSpaceOptions_prefix_operator;
	public static String WhiteSpaceOptions_postfix_operator;
	public static String WhiteSpaceOptions_opening_paren;
	public static String WhiteSpaceOptions_catch;
	public static String WhiteSpaceOptions_for;
	public static String WhiteSpaceOptions_if;
	public static String WhiteSpaceOptions_switch;
	public static String WhiteSpaceOptions_while;
	public static String WhiteSpaceOptions_function_declaration;
	public static String WhiteSpaceOptions_exception_specification;
	public static String WhiteSpaceOptions_function;
	public static String WhiteSpaceOptions_function_call;
	public static String WhiteSpaceOptions_paren_expr;
	public static String WhiteSpaceOptions_type_cast;
	public static String WhiteSpaceOptions_template_arguments;
	public static String WhiteSpaceOptions_template_parameters;
	public static String WhiteSpaceOptions_closing_paren;
	public static String WhiteSpaceOptions_opening_brace;
	public static String WhiteSpaceOptions_closing_brace;
	public static String WhiteSpaceOptions_opening_bracket;
	public static String WhiteSpaceOptions_closing_bracket;
	public static String WhiteSpaceOptions_class_decl;
	public static String WhiteSpaceOptions_initializer_list;
	public static String WhiteSpaceOptions_block;
	public static String WhiteSpaceOptions_arrays;
	public static String WhiteSpaceOptions_arguments;
	public static String WhiteSpaceOptions_parameters;
	public static String WhiteSpaceOptions_lists;
	public static String WhiteSpaceOptions_expression_list;
	public static String WhiteSpaceOptions_declarator_list;
	public static String WhiteSpaceOptions_colon;
	public static String WhiteSpaceOptions_conditional;
	public static String WhiteSpaceOptions_label;
	public static String WhiteSpaceOptions_comma;
	public static String WhiteSpaceOptions_semicolon;
	public static String WhiteSpaceOptions_question_mark;
	public static String WhiteSpaceOptions_between_empty_parens;
	public static String WhiteSpaceOptions_between_empty_braces;
	public static String WhiteSpaceOptions_between_empty_brackets;
	public static String WhiteSpaceOptions_function_decl;
	public static String WhiteSpaceOptions_case;
	public static String WhiteSpaceOptions_default;
	public static String WhiteSpaceOptions_statements;
	public static String WhiteSpaceOptions_before_opening_paren;
	public static String WhiteSpaceOptions_after_opening_paren;
	public static String WhiteSpaceOptions_before_closing_paren;
	public static String WhiteSpaceOptions_after_closing_paren;
	public static String WhiteSpaceOptions_before_opening_brace;
	public static String WhiteSpaceOptions_after_opening_brace;
	public static String WhiteSpaceOptions_after_closing_brace;
	public static String WhiteSpaceOptions_before_closing_brace;
	public static String WhiteSpaceOptions_before_opening_bracket;
	public static String WhiteSpaceOptions_after_opening_bracket;
	public static String WhiteSpaceOptions_before_closing_bracket;
	public static String WhiteSpaceOptions_before_opening_angle_bracket;
	public static String WhiteSpaceOptions_after_opening_angle_bracket;
	public static String WhiteSpaceOptions_before_closing_angle_bracket;
	public static String WhiteSpaceOptions_after_closing_angle_bracket;
	public static String WhiteSpaceOptions_before_operator;
	public static String WhiteSpaceOptions_after_operator;
	public static String WhiteSpaceOptions_before_comma;
	public static String WhiteSpaceOptions_after_comma;
	public static String WhiteSpaceOptions_after_colon;
	public static String WhiteSpaceOptions_before_colon;
	public static String WhiteSpaceOptions_before_semicolon;
	public static String WhiteSpaceOptions_after_semicolon;
	public static String WhiteSpaceOptions_before_question_mark;
	public static String WhiteSpaceOptions_after_question_mark;
//	public static String WhiteSpaceOptions_before_ellipsis;
//	public static String WhiteSpaceOptions_after_ellipsis;
//	public static String WhiteSpaceOptions_return_with_parenthesized_expression;
//	public static String WhiteSpaceOptions_throw_with_parenthesized_expression;
	public static String LineWrappingTabPage_base_clause;
//	public static String LineWrappingTabPage_compact_if_else;
	public static String LineWrappingTabPage_parameters;
	public static String LineWrappingTabPage_arguments;
	public static String LineWrappingTabPage_throws_clause;
	public static String LineWrappingTabPage_constructor_initializer_list;
	public static String LineWrappingTabPage_enum_decls;
	public static String LineWrappingTabPage_enumerator_list;
	public static String LineWrappingTabPage_initializer_list;
	public static String LineWrappingTabPage_binary_exprs;
	public static String LineWrappingTabPage_conditionals;
	public static String LineWrappingTabPage_member_access;
	public static String LineWrappingTabPage_stream_output;
	public static String LineWrappingTabPage_indentation_default;
	public static String LineWrappingTabPage_indentation_on_column;
	public static String LineWrappingTabPage_indentation_by_one;
	public static String LineWrappingTabPage_class_decls;
	public static String LineWrappingTabPage_function_decls;
	public static String LineWrappingTabPage_function_calls;
	public static String LineWrappingTabPage_expressions;
//	public static String LineWrappingTabPage_statements;
	public static String LineWrappingTabPage_do_not_join_lines;
	
	public static String LineWrappingTabPage_base_clause_lowercase;
//	public static String LineWrappingTabPage_compact_if_else_lowercase;
	public static String LineWrappingTabPage_parameters_lowercase;
	public static String LineWrappingTabPage_arguments_lowercase;
	public static String LineWrappingTabPage_throws_clause_lowercase;
	public static String LineWrappingTabPage_constructor_initializer_list_lowercase;
	public static String LineWrappingTabPage_enum_decls_lowercase;
	public static String LineWrappingTabPage_enumerator_list_lowercase;
	public static String LineWrappingTabPage_initializer_list_lowercase;
	public static String LineWrappingTabPage_binary_exprs_lowercase;
	public static String LineWrappingTabPage_conditionals_lowercase;
	public static String LineWrappingTabPage_member_access_lowercase;
	public static String LineWrappingTabPage_stream_output_lowercase;
	public static String LineWrappingTabPage_indentation_default_lowercase;
	public static String LineWrappingTabPage_indentation_on_column_lowercase;
	public static String LineWrappingTabPage_indentation_by_one_lowercase;
	public static String LineWrappingTabPage_class_decls_lowercase;
	public static String LineWrappingTabPage_function_decls_lowercase;
	public static String LineWrappingTabPage_function_calls_lowercase;
	public static String LineWrappingTabPage_expressions_lowercase;
//	public static String LineWrappingTabPage_statements_lowercase;
	public static String LineWrappingTabPage_assignment_alignment_lowercase;

	public static String LineWrappingTabPage_wrapping_policy_label_text;
	public static String LineWrappingTabPage_indentation_policy_label_text;
	public static String LineWrappingTabPage_force_split_checkbox_text;
	public static String LineWrappingTabPage_force_split_checkbox_multi_text;
	public static String LineWrappingTabPage_line_width_for_preview_label_text;
	public static String LineWrappingTabPage_line_width_for_preview_label_unit_text;
	public static String LineWrappingTabPage_group;
	public static String LineWrappingTabPage_multi_group;
	public static String LineWrappingTabPage_multiple_selections;
	public static String LineWrappingTabPage_occurences;
	public static String LineWrappingTabPage_splitting_do_not_split;
	public static String LineWrappingTabPage_splitting_wrap_when_necessary;
	public static String LineWrappingTabPage_splitting_always_wrap_first_others_when_necessary;
	public static String LineWrappingTabPage_splitting_wrap_always;
	public static String LineWrappingTabPage_splitting_wrap_always_indent_all_but_first;
	public static String LineWrappingTabPage_splitting_wrap_always_except_first_only_if_necessary;
	public static String LineWrappingTabPage_width_indent;
	public static String LineWrappingTabPage_width_indent_option_max_line_width;
	public static String LineWrappingTabPage_width_indent_option_default_indent_wrapped;
	public static String LineWrappingTabPage_width_indent_option_default_indent_array;
	public static String LineWrappingTabPage_error_invalid_value;
	public static String LineWrappingTabPage_assignment_alignment;
	public static String AlreadyExistsDialog_message_profile_already_exists;
	public static String AlreadyExistsDialog_message_profile_name_empty;
	public static String AlreadyExistsDialog_dialog_title;
	public static String AlreadyExistsDialog_dialog_label;
	public static String AlreadyExistsDialog_rename_radio_button_desc;
	public static String AlreadyExistsDialog_overwrite_radio_button_desc;
//	public static String BlankLinesTabPage_preview_header;
//	public static String BlankLinesTabPage_compilation_unit_group_title;
//	public static String BlankLinesTabPage_compilation_unit_option_before_package;
//	public static String BlankLinesTabPage_compilation_unit_option_after_package;
//	public static String BlankLinesTabPage_compilation_unit_option_before_import;
//	public static String BlankLinesTabPage_compilation_unit_option_after_import;
//	public static String BlankLinesTabPage_compilation_unit_option_between_type_declarations;
//	public static String BlankLinesTabPage_class_group_title;
//	public static String BlankLinesTabPage_class_option_before_first_decl;
//	public static String BlankLinesTabPage_class_option_before_decls_of_same_kind;
//	public static String BlankLinesTabPage_class_option_before_member_class_decls;
//	public static String BlankLinesTabPage_class_option_before_field_decls;
//	public static String BlankLinesTabPage_class_option_before_method_decls;
//	public static String BlankLinesTabPage_class_option_at_beginning_of_method_body;
//	public static String BlankLinesTabPage_blank_lines_group_title;
//	public static String BlankLinesTabPage_blank_lines_option_empty_lines_to_preserve;
	public static String BracesTabPage_preview_header;
	public static String BracesTabPage_position_same_line;
	public static String BracesTabPage_position_next_line;
	public static String BracesTabPage_position_next_line_indented;
	public static String BracesTabPage_position_next_line_on_wrap;
	public static String BracesTabPage_group_brace_positions_title;
	public static String BracesTabPage_option_class_declaration;
	public static String BracesTabPage_option_namespace_declaration;
	public static String BracesTabPage_option_function_declaration;
	public static String BracesTabPage_option_blocks;
	public static String BracesTabPage_option_blocks_in_case;
	public static String BracesTabPage_option_switch_case;
	public static String BracesTabPage_option_initializer_list;
	public static String BracesTabPage_option_keep_empty_initializer_list_on_one_line;
	public static String CodingStyleConfigurationBlock_save_profile_dialog_title;
	public static String CodingStyleConfigurationBlock_save_profile_error_title;
	public static String CodingStyleConfigurationBlock_save_profile_error_message;
	public static String CodingStyleConfigurationBlock_load_profile_dialog_title;
	public static String CodingStyleConfigurationBlock_load_profile_error_title;
	public static String CodingStyleConfigurationBlock_load_profile_error_message;
	public static String CodingStyleConfigurationBlock_load_profile_error_too_new_title;
	public static String CodingStyleConfigurationBlock_load_profile_error_too_new_message;
	public static String CodingStyleConfigurationBlock_preview_title;
	public static String CodingStyleConfigurationBlock_save_profile_overwrite_title;
	public static String CodingStyleConfigurationBlock_save_profile_overwrite_message;
	public static String CodingStyleConfigurationBlock_edit_button_desc;
	public static String CodingStyleConfigurationBlock_remove_button_desc;
	public static String CodingStyleConfigurationBlock_new_button_desc;
	public static String CodingStyleConfigurationBlock_load_button_desc;
	public static String CodingStyleConfigurationBlock_preview_label_text;
	public static String CodingStyleConfigurationBlock_error_reading_xml_message;
	public static String CodingStyleConfigurationBlock_error_serializing_xml_message;
	public static String CodingStyleConfigurationBlock_delete_confirmation_title;
	public static String CodingStyleConfigurationBlock_delete_confirmation_question;
	public static String CommentsTabPage_preview_header;
	public static String CommentsTabPage_group1_title;
	public static String CommentsTabPage_preserve_white_space_before_line_comment;
	public static String CommentsTabPage_line_up_line_comment_in_blocks_on_first_column;
	public static String CommentsTabPage_line_width;
	public static String CustomCodeFormatterBlock_formatter_name;
	public static String CustomCodeFormatterBlock_default_formatter;
	public static String CustomCodeFormatterBlock_formatter_note;
	public static String CustomCodeFormatterBlock_contributed_formatter_warning;
	public static String ControlStatementsTabPage_preview_header;
	public static String ControlStatementsTabPage_general_group_title;
	public static String ControlStatementsTabPage_general_group_insert_new_line_before_else_statements;
	public static String ControlStatementsTabPage_general_group_insert_new_line_before_catch_statements;
	public static String ControlStatementsTabPage_general_group_insert_new_line_before_while_in_do_statements;
	public static String ControlStatementsTabPage_if_else_group_title;
	public static String ControlStatementsTabPage_if_else_group_keep_then_on_same_line;
	public static String ControlStatementsTabPage_if_else_group_keep_simple_if_on_one_line;
	public static String ControlStatementsTabPage_if_else_group_keep_else_on_same_line;
	public static String ControlStatementsTabPage_if_else_group_keep_else_if_on_one_line;
//	public static String ControlStatementsTabPage_if_else_group_keep_guardian_clause_on_one_line;
	public static String CreateProfileDialog_status_message_profile_with_this_name_already_exists;
	public static String CreateProfileDialog_status_message_profile_name_is_empty;
	public static String CreateProfileDialog_dialog_title;
	public static String CreateProfileDialog_profile_name_label_text;
	public static String CreateProfileDialog_base_profile_label_text;
	public static String CreateProfileDialog_open_edit_dialog_checkbox_text;
	public static String IndentationTabPage_preview_header;
	public static String IndentationTabPage_general_group_title;
	public static String IndentationTabPage_general_group_option_tab_policy;
	public static String IndentationTabPage_general_group_option_tab_policy_SPACE;
	public static String IndentationTabPage_general_group_option_tab_policy_TAB;
	public static String IndentationTabPage_general_group_option_tab_policy_MIXED;
	public static String IndentationTabPage_general_group_option_tab_size;
	public static String IndentationTabPage_general_group_option_indent_size;
//	public static String IndentationTabPage_field_alignment_group_title;
//	public static String IndentationTabPage_field_alignment_group_align_fields_in_columns;
	public static String IndentationTabPage_indent_group_title;
	public static String IndentationTabPage_class_group_option_indent_access_specifiers_within_class_body;
	public static String IndentationTabPage_class_group_option_indent_declarations_compare_to_access_specifiers;
	public static String IndentationTabPage_block_group_option_indent_statements_compare_to_body;
	public static String IndentationTabPage_block_group_option_indent_statements_compare_to_block;
	public static String IndentationTabPage_switch_group_option_indent_statements_within_switch_body;
	public static String IndentationTabPage_switch_group_option_indent_statements_within_case_body;
	public static String IndentationTabPage_switch_group_option_indent_break_statements;
	public static String IndentationTabPage_namespace_group_option_indent_declarations_within_namespace;
    public static String IndentationTabPage_indent_empty_lines;
	public static String IndentationTabPage_use_tabs_only_for_leading_indentations;
	public static String ModifyDialog_dialog_title;
	public static String ModifyDialog_apply_button;
	public static String ModifyDialog_tabpage_braces_title;
	public static String ModifyDialog_tabpage_indentation_title;
	public static String ModifyDialog_tabpage_whitespace_title;
//	public static String ModifyDialog_tabpage_blank_lines_title;
	public static String ModifyDialog_tabpage_new_lines_title;
	public static String ModifyDialog_tabpage_control_statements_title;
	public static String ModifyDialog_tabpage_line_wrapping_title;
	public static String ModifyDialog_tabpage_comments_title;
	public static String ModifyDialogTabPage_preview_label_text;
	public static String ModifyDialogTabPage_error_msg_values_text_unassigned;
	public static String ModifyDialogTabPage_error_msg_values_items_text_unassigned;
	public static String ModifyDialogTabPage_NumberPreference_error_invalid_key;
	public static String ModifyDialogTabPage_NumberPreference_error_invalid_value;
	public static String NewLinesTabPage_preview_header;
	public static String NewLinesTabPage_newlines_group_title;
	public static String NewLinesTabPage_newlines_group_option_before_colon_in_constructor_initializer_list;
//	public static String NewLinesTabPage_newlines_group_option_empty_class_body;
//	public static String NewLinesTabPage_newlines_group_option_empty_method_body;
//	public static String NewLinesTabPage_newlines_group_option_empty_block;
//	public static String NewLinesTabPage_newlines_group_option_empty_end_of_file;
//	public static String NewLinesTabPage_empty_statement_group_title;
//	public static String NewLinesTabPage_emtpy_statement_group_option_empty_statement_on_new_line;
//	public static String NewLinesTabPage_arrayInitializer_group_title;
//	public static String NewLinesTabPage_array_group_option_after_opening_brace_of_array_initializer;
//	public static String NewLinesTabPage_array_group_option_before_closing_brace_of_array_initializer;
//	public static String NewLinesTabPage_annotations_group_title;
//	public static String NewLinesTabPage_annotations_group_option_after_annotation;
	public static String ProfileManager_kandr_profile_name;
	public static String ProfileManager_allman_profile_name;
	public static String ProfileManager_gnu_profile_name;
	public static String ProfileManager_whitesmiths_profile_name;
	public static String ProfileManager_unmanaged_profile;
	public static String ProfileManager_unmanaged_profile_with_name;

	public static String CPreview_formatter_exception;

	private FormatterMessages() {
		// Do not instantiate
	}

	static {
		NLS.initializeMessages(FormatterMessages.class.getName(), FormatterMessages.class);
	}
}
