/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.editors.pages;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.designer.core.mediator.IMediatorRequest;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.core.util.mediator.request.ReportRequest;
import org.eclipse.birt.report.designer.internal.ui.editors.xml.XMLEditor;
import org.eclipse.birt.report.designer.internal.ui.util.Policy;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.editors.IReportEditorPage;
import org.eclipse.birt.report.designer.ui.editors.IReportProvider;
import org.eclipse.birt.report.designer.ui.editors.MultiPageReportEditor;
import org.eclipse.birt.report.designer.ui.util.ExceptionUtil;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.ErrorDetail;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ModuleUtil;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;

public class ReportXMLSourceEditorFormPage
extends XMLEditor
implements IReportEditorPage {
    public static final String ID = "org.eclipse.birt.report.designer.ui.editors.xmlsource";
    private ActionRegistry registry;
    private FormEditor editor;
    private Control control;
    private int staleType;
    private int index;
    private ErrorDetail errorDetail;

    public void initialize(FormEditor editor) {
        this.editor = editor;
        this.setRangeIndicator(new Annotation(){});
    }

    public FormEditor getEditor() {
        return this.editor;
    }

    public void doSave(IProgressMonitor progressMonitor) {
        super.doSave(progressMonitor);
        IReportProvider provider = this.getProvider();
        if (provider != null && this.getErrorLIine(false) == -1) {
            ModuleHandle model = provider.getReportModuleHandle((Object)this.getEditorInput(), true);
            SessionHandleAdapter.getInstance().setReportDesignHandle(model);
            UIUtil.processSessionResourceFolder((IEditorInput)this.getEditorInput(), (IProject)UIUtil.getProjectFromInput((IEditorInput)this.getEditorInput()), (ModuleHandle)model);
            UIUtil.doFinishSave((ModuleHandle)model);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int getErrorLIine(boolean checkReport) {
        this.errorDetail = null;
        IEditorInput input = this.getEditorInput();
        try {
            IPath path = this.getProvider().getInputPath(input);
            if (path.toOSString().endsWith(".rptlibrary")) {
                LibraryHandle library = null;
                try {
                    library = SessionHandleAdapter.getInstance().getSessionHandle().openLibrary(path.toOSString());
                    if (!checkReport) return -1;
                    int n = this.getErrorLineFromModuleHandle((ModuleHandle)library);
                    return n;
                }
                catch (DesignFileException e) {
                    int n = this.getExpetionErrorLine(e);
                    return n;
                }
                finally {
                    if (library != null) {
                        library.close();
                    }
                }
            }
            if (path.toOSString().endsWith(".rptdesign") || path.toOSString().endsWith(".rpttemplate")) {
                ReportDesignHandle report = null;
                try {
                    report = SessionHandleAdapter.getInstance().getSessionHandle().openDesign(path.toOSString(), (InputStream)new FileInputStream(path.toFile()));
                    if (!checkReport) return -1;
                    int n = this.getErrorLineFromModuleHandle((ModuleHandle)report);
                    return n;
                }
                catch (DesignFileException e) {
                    int n = this.getExpetionErrorLine(e);
                    return n;
                }
                finally {
                    if (report != null) {
                        report.close();
                    }
                }
            }
            ModuleHandle report = null;
            try {
                report = SessionHandleAdapter.getInstance().getSessionHandle().openModule(path.toOSString(), (InputStream)new FileInputStream(path.toFile()));
                if (!checkReport) return -1;
                int n = this.getErrorLineFromModuleHandle(report);
                return n;
            }
            catch (DesignFileException e) {
                int n = this.getExpetionErrorLine(e);
                return n;
            }
            finally {
                if (report != null) {
                    report.close();
                }
            }
        }
        catch (Exception exception) {
            return 0;
        }
    }

    private int getExpetionErrorLine(DesignFileException e) {
        List errorList = e.getErrorList();
        for (Object element : errorList) {
            if (!(element instanceof ErrorDetail)) continue;
            this.errorDetail = (ErrorDetail)element;
            return ((ErrorDetail)element).getLineNo();
        }
        return 0;
    }

    private int getErrorLineFromModuleHandle(ModuleHandle handle) {
        handle.checkReport();
        List list = handle.getErrorList();
        if (list != null) {
            int i = 0;
            int m = list.size();
            while (i < m) {
                Object obj = list.get(i);
                if (obj instanceof ErrorDetail) {
                    ErrorDetail errorDetail;
                    this.errorDetail = errorDetail = (ErrorDetail)list.get(i);
                    return errorDetail.getLineNo();
                }
                ++i;
            }
        }
        return 0;
    }

    public IManagedForm getManagedForm() {
        return null;
    }

    public void setActive(boolean active) {
        int errorLine = this.getErrorLIine(true);
        if (errorLine > -1) {
            this.setFocus();
            this.setHighlightLine(errorLine);
        }
    }

    public boolean isActive() {
        return false;
    }

    public boolean canLeaveThePage() {
        int errorLine;
        if (this.isDirty()) {
            MessageDialog prefDialog = new MessageDialog(UIUtil.getDefaultShell(), Messages.getString((String)"XMLSourcePage.Error.Dialog.title"), null, Messages.getString((String)"XMLSourcePage.Error.Dialog.Message.PromptMsg"), 2, new String[]{Messages.getString((String)"XMLSourcePage.Error.Dialog.Message.Yes"), Messages.getString((String)"XMLSourcePage.Error.Dialog.Message.No"), Messages.getString((String)"XMLSourcePage.Error.Dialog.Message.Cancel")}, 0);
            int ret = prefDialog.open();
            switch (ret) {
                case 0: {
                    this.getEditor().doSave(null);
                    break;
                }
                case 1: {
                    if (this.getEditorInput() == null) break;
                    this.setInput(this.getEditorInput());
                    break;
                }
                case 2: {
                    return false;
                }
            }
        }
        if ((errorLine = this.getErrorLIine(false)) > -1) {
            if (this.errorDetail != null && this.errorDetail.getErrorCode().equals("Error.DesignParserException.UNSUPPORTED_VERSION")) {
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Messages.getString((String)"XMLSourcePage.Error.Dialog.title"), (String)this.errorDetail.getMessage());
            } else {
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Messages.getString((String)"XMLSourcePage.Error.Dialog.title"), (String)Messages.getString((String)"XMLSourcePage.Error.Dialog.Message.InvalidFile"));
            }
            this.setFocus();
            this.setHighlightLine(errorLine);
            return false;
        }
        return true;
    }

    private void setHighlightLine(int errorLine) {
        try {
            IRegion region = this.getDocumentProvider().getDocument((Object)this.getEditorInput()).getLineInformation(errorLine);
            this.setHighlightRange(region.getOffset(), region.getLength(), true);
        }
        catch (BadLocationException badLocationException) {}
    }

    public Control getPartControl() {
        return this.control;
    }

    public String getId() {
        return ID;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public boolean isEditor() {
        return true;
    }

    public boolean selectReveal(Object marker) {
        return true;
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        Control[] children = parent.getChildren();
        this.control = children[children.length - 1];
    }

    public boolean onBroughtToTop(IReportEditorPage prePage) {
        if (this.getEditorInput() != prePage.getEditorInput()) {
            this.setInput(prePage.getEditorInput());
        }
        if (this.getStaleType() == 4) {
            this.reloadEditorInput();
            this.doSave(null);
        } else if (prePage != this && (prePage.isDirty() || prePage.getStaleType() != 0)) {
            ModuleHandle model = this.getModel();
            if (model != null && ModuleUtil.compareReportVersion((String)ModuleUtil.getReportVersion(), (String)model.getVersion()) > 0 && !MessageDialog.openConfirm((Shell)UIUtil.getDefaultShell(), (String)Messages.getString((String)"MultiPageReportEditor.ConfirmVersion.Dialog.Title"), (String)Messages.getString((String)"MultiPageReportEditor.ConfirmVersion.Dialog.Message"))) {
                return false;
            }
            prePage.doSave(null);
            UIUtil.doFinishSave((ModuleHandle)model);
            prePage.markPageStale(0);
            this.refreshDocument();
            this.markPageStale(0);
        }
        ReportRequest request = new ReportRequest((Object)this);
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(new Object());
        request.setSelectionObject(list);
        request.setType((Object)"selection");
        SessionHandleAdapter.getInstance().getMediator().notifyRequest((IMediatorRequest)request);
        this.setFocus();
        return true;
    }

    private void reloadEditorInput() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            this.getModel().serialize((OutputStream)out);
            String newInput = out.toString(this.getModel().getFileEncoding());
            this.getDocumentProvider().getDocument((Object)this.getEditorInput()).set(newInput);
            this.getEditor().editorDirtyStateChanged();
        }
        catch (IOException e) {
            ExceptionUtil.handle((Throwable)e);
        }
    }

    public MultiPageReportEditor getReportEditor() {
        return (MultiPageReportEditor)this.getEditor();
    }

    public ModuleHandle getModel() {
        IReportProvider provider = this.getProvider();
        if (provider != null) {
            return provider.queryReportModuleHandle();
        }
        return null;
    }

    public void markPageStale(int type) {
        this.staleType = type;
    }

    public int getStaleType() {
        return this.staleType;
    }

    protected void firePropertyChange(int type) {
        super.firePropertyChange(type);
        if (type == 257 && this.editor != null) {
            this.markPageStale(2);
            this.editor.editorDirtyStateChanged();
        }
    }

    public Object getAdapter(Class required) {
        if (required.equals(ActionRegistry.class)) {
            if (this.registry == null) {
                this.registry = new ActionRegistry();
            }
            return this.registry;
        }
        return super.getAdapter(required);
    }

    @Override
    protected IReportProvider getProvider() {
        return (IReportProvider)this.editor.getAdapter(IReportProvider.class);
    }

    protected void finalize() throws Throwable {
        if (Policy.TRACING_PAGE_CLOSE) {
            System.out.println("Report source page finalized");
        }
        super.finalize();
    }
}

