/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.lowvision.eval;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.actf.visualization.engines.lowvision.image.IPageImage;
import org.eclipse.actf.visualization.eval.EvaluationResultImpl;
import org.eclipse.actf.visualization.eval.guideline.GuidelineHolder;
import org.eclipse.actf.visualization.eval.problem.IProblemItem;
import org.eclipse.actf.visualization.eval.problem.IProblemItemImage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckResultLowVision
extends EvaluationResultImpl {
    private int count = 0;

    public CheckResultLowVision() {
        this.setSummaryReportUrl("about:blank");
        this.setShowAllGuidelineItems(true);
    }

    public void setFrameOffsetToProblems(IPageImage[] iPageImageArray) {
        if (iPageImageArray != null) {
            int[] nArray = new int[iPageImageArray.length];
            nArray[0] = 0;
            int n = 1;
            while (n < iPageImageArray.length) {
                nArray[n] = nArray[n - 1] + iPageImageArray[n - 1].getHeight();
                ++n;
            }
            Iterator iterator = this.getProblemList().iterator();
            while (iterator.hasNext()) {
                try {
                    IProblemItemImage iProblemItemImage = (IProblemItemImage)iterator.next();
                    int n2 = iProblemItemImage.getFrameId();
                    if (n2 <= -1 || n2 >= nArray.length) continue;
                    iProblemItemImage.setFrameOffset(nArray[n2]);
                    iProblemItemImage.setY(iProblemItemImage.getY() + nArray[n2]);
                }
                catch (Exception exception) {}
            }
        }
    }

    public void addProblemItems(Collection<IProblemItem> collection) {
        this.stripProblem(collection);
        super.addProblemItems(collection);
    }

    public void setProblemList(List<IProblemItem> list) {
        this.count = 0;
        this.stripProblem(list);
        super.setProblemList(list);
    }

    private void stripProblem(Collection<IProblemItem> collection) {
        GuidelineHolder guidelineHolder = GuidelineHolder.getInstance();
        Iterator<IProblemItem> iterator = collection.iterator();
        while (iterator.hasNext()) {
            try {
                IProblemItem iProblemItem = iterator.next();
                if (guidelineHolder.isMatchedCheckItem(iProblemItem.getEvaluationItem())) {
                    iProblemItem.setSerialNumber(this.count);
                    ++this.count;
                    continue;
                }
                iterator.remove();
            }
            catch (Exception exception) {
                iterator.remove();
            }
        }
    }
}

