/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.js.grunt.util;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.FunctionInvocation;
import org.eclipse.wst.jsdt.core.dom.ObjectLiteral;
import org.eclipse.wst.jsdt.core.dom.ObjectLiteralField;
import org.eclipse.wst.jsdt.js.common.build.system.BuildSystemVisitor;
import org.eclipse.wst.jsdt.js.common.build.system.ITask;
import org.eclipse.wst.jsdt.js.common.build.system.Location;
import org.eclipse.wst.jsdt.js.common.build.system.util.ASTUtil;
import org.eclipse.wst.jsdt.js.grunt.internal.GruntTask;

public class GruntVisitor
extends BuildSystemVisitor {
    private static final String GRUNT_INIT_CONFIG = "grunt.initConfig";
    private static final String GRUNT_REGISTER_TASK = "grunt.registerTask";
    private static final String GRUNT_TASK_REGISTER_TASK = "grunt.task.registerTask";
    private static final String GRUNT_REGISTER_MULTI_TASK = "grunt.registerMultiTask";
    private static final String GRUNT_TASK_REGISTER_MULTI_TASK = "grunt.task.registerMultiTask";
    private static final String GRUNT_PROPERTY_IGNORE = "pkg";
    private Set<ITask> tasks;
    private IFile file;

    public GruntVisitor(IFile file) {
        this.file = file;
        this.tasks = new HashSet<ITask>();
    }

    public boolean visit(FunctionInvocation node) {
        Expression expression = node.getExpression();
        List arguments = node.arguments();
        if (expression != null && arguments != null) {
            int argSize = arguments.size();
            String expressionName = expression.toString();
            if (GRUNT_REGISTER_TASK.equals(expressionName) || GRUNT_TASK_REGISTER_TASK.equals(expressionName) || GRUNT_REGISTER_MULTI_TASK.equals(expressionName) || GRUNT_TASK_REGISTER_MULTI_TASK.equals(expressionName)) {
                if (argSize == 2 || argSize == 3) {
                    Expression task = (Expression)arguments.get(0);
                    this.tasks.add((ITask)new GruntTask(ASTUtil.beautify((Expression)task), this.file, false, new Location(task.getStartPosition(), task.getLength())));
                }
                return false;
            }
            if (GRUNT_INIT_CONFIG.equals(expressionName)) {
                if (argSize == 1 && arguments.get(0) instanceof ObjectLiteral) {
                    ObjectLiteral jsObject = (ObjectLiteral)arguments.get(0);
                    List fields = jsObject.fields();
                    for (ObjectLiteralField f : fields) {
                        Expression field = f.getFieldName();
                        if (field.toString().equals(GRUNT_PROPERTY_IGNORE)) continue;
                        this.tasks.add((ITask)new GruntTask(field.toString(), this.file, false, new Location(field.getStartPosition(), field.getLength())));
                    }
                }
                return false;
            }
        }
        return true;
    }

    public Set<ITask> getTasks() {
        return this.tasks;
    }
}

