/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.js.cli.internal.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.wst.jsdt.js.cli.CLIPlugin;
import org.eclipse.wst.jsdt.js.cli.core.CLICommand;

public class ProcessUtil {
    private ProcessUtil() {
    }

    public static boolean isWindows() {
        String OS = System.getProperty("os.name", "unknown");
        return OS.toLowerCase().indexOf("win") > -1;
    }

    public static int terminateProcessById(String pid, Boolean includeChildProcesses, Boolean terminateProcessForcefully) {
        ArrayList<String> command = new ArrayList<String>();
        if (ProcessUtil.isWindows()) {
            command.add("taskkill");
            command.add("/PID");
            command.add(pid);
            if (includeChildProcesses.booleanValue()) {
                command.add("/T");
            }
            if (terminateProcessForcefully.booleanValue()) {
                command.add("/F");
            }
        } else {
            if (includeChildProcesses.booleanValue()) {
                command.add("pkill");
                if (terminateProcessForcefully.booleanValue()) {
                    command.add("-9");
                }
                command.add("-P");
            } else {
                command.add("kill");
                if (terminateProcessForcefully.booleanValue()) {
                    command.add("-9");
                }
            }
            command.add(pid);
        }
        ProcessBuilder processBuilder = new ProcessBuilder(command);
        int exit = 1;
        try {
            exit = processBuilder.start().waitFor();
        }
        catch (IOException | InterruptedException e) {
            exit = 1;
            CLIPlugin.logError(e);
        }
        return exit;
    }

    public static String getPID(CLICommand command, String path) {
        return ProcessUtil.isWindows() ? ProcessUtil.getPIDonWindows(command.getCommandName()) : ProcessUtil.getPIDonUnix(command.getToolName(), path);
    }

    private static String getPIDonWindows(String commandName) {
        String pid = null;
        String wmicCommand = "wmic process where 'caption^=\"node.exe\" and CommandLine like \"%" + commandName + "%\"' get processid";
        String[] command = new String[]{"cmd", "/c", "for /f \"usebackq skip=1\" %F in (`" + wmicCommand + "`) do @echo %F"};
        ProcessBuilder processBuilder = new ProcessBuilder(command);
        try {
            String line;
            Process process = processBuilder.start();
            InputStream inputStream = process.getInputStream();
            BufferedReader buffer = new BufferedReader(new InputStreamReader(inputStream));
            int exit = process.waitFor();
            if (exit == 0 && (line = buffer.readLine()) != null && !line.equals("ECHO is on.")) {
                pid = line;
            }
        }
        catch (IOException | InterruptedException e) {
            CLIPlugin.logError(e);
        }
        return pid;
    }

    private static String getPIDonUnix(String toolName, String path) {
        ArrayList<String> mathingPIDs = new ArrayList<String>();
        String[] command = new String[]{"/bin/sh", "-c", "ps axwww | grep -i " + toolName + ".* | grep -v grep | awk '{print $1}'"};
        ProcessBuilder processBuilder = new ProcessBuilder(command);
        try {
            Process process = processBuilder.start();
            InputStream inputStream = process.getInputStream();
            BufferedReader buffer = new BufferedReader(new InputStreamReader(inputStream));
            int exit = process.waitFor();
            if (exit == 0) {
                String line;
                while ((line = buffer.readLine()) != null && !line.equals("ECHO is on.")) {
                    mathingPIDs.add(line);
                }
            }
        }
        catch (IOException | InterruptedException e) {
            CLIPlugin.logError(e);
        }
        return mathingPIDs.size() == 1 ? (String)mathingPIDs.get(0) : ProcessUtil.findPID(mathingPIDs, path);
    }

    private static String findPID(List<String> mathingPIDs, String path) {
        String pid = null;
        for (String p : mathingPIDs) {
            ProcessBuilder processBuilder = new ProcessBuilder("pwdx", p);
            try {
                String line;
                Process process = processBuilder.start();
                InputStream inputStream = process.getInputStream();
                BufferedReader buffer = new BufferedReader(new InputStreamReader(inputStream));
                int exit = process.waitFor();
                if (exit != 0 || (line = buffer.readLine()) == null || !line.endsWith(path)) continue;
                pid = p;
                break;
            }
            catch (IOException | InterruptedException e) {
                CLIPlugin.logError(e);
            }
        }
        return pid;
    }
}

