/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.componentcore.internal.impl;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.impl.URIConverterImpl;
import org.eclipse.emf.ecore.resource.impl.URIMappingRegistryImpl;
import org.eclipse.jem.util.emf.workbench.ResourceSetWorkbenchSynchronizer;
import org.eclipse.jem.util.emf.workbench.WorkbenchResourceHelperBase;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.ModulecorePlugin;
import org.eclipse.wst.common.componentcore.internal.impl.ModuleURIUtil;
import org.eclipse.wst.common.componentcore.internal.impl.PlatformURLModuleConnection;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.internal.emfworkbench.CompatibilityWorkbenchURIConverterImpl;
import org.eclipse.wst.common.internal.emfworkbench.WorkbenchResourceHelper;

public class ComponentCoreURIConverter
extends CompatibilityWorkbenchURIConverterImpl {
    private IProject containingProject;

    public ComponentCoreURIConverter() {
    }

    public ComponentCoreURIConverter(IProject aContainingProject) {
        this.containingProject = aContainingProject;
    }

    public ComponentCoreURIConverter(IProject aContainingProject, ResourceSetWorkbenchSynchronizer aSynchronizer) {
        super((IContainer)aContainingProject, aSynchronizer);
        this.containingProject = aContainingProject;
    }

    public IVirtualComponent findComponent(IResource res) {
        if (res != null && res.exists()) {
            return ComponentCore.createComponent(res.getProject());
        }
        return null;
    }

    public URI normalize(URI aURI) {
        URI normalizedURI = null;
        if ("module".equals(aURI.scheme())) {
            try {
                normalizedURI = PlatformURLModuleConnection.resolve(aURI);
            }
            catch (IOException e) {
                ModulecorePlugin.logError(e);
            }
        } else {
            normalizedURI = super.normalize(aURI);
        }
        if (normalizedURI == null) {
            normalizedURI = this.newPlatformURI(aURI);
        } else if (normalizedURI.scheme() == null || normalizedURI.scheme().length() == 0) {
            normalizedURI = URI.createPlatformResourceURI((String)this.getInputContainer().getFullPath().append(normalizedURI.toString()).toString());
        }
        return normalizedURI;
    }

    private URI newPlatformURI(URI aNewURI) {
        try {
            IVirtualComponent component = ComponentCore.createComponent(this.containingProject);
            URI deployPathSegment = ModuleURIUtil.trimToDeployPathSegment(aNewURI);
            IVirtualFolder rootFolder = component.getRootFolder();
            IVirtualFile newFile = rootFolder.getFile((IPath)new Path(deployPathSegment.path()));
            return URI.createPlatformResourceURI((String)newFile.getWorkspaceRelativePath().toString());
        }
        catch (Exception e) {
            ModulecorePlugin.logError(e);
            return null;
        }
    }

    public URI deNormalize(URI uri) {
        IFile aFile;
        if (WorkbenchResourceHelperBase.isPlatformResourceURI((URI)uri) && (aFile = WorkbenchResourceHelper.getPlatformFile((URI)uri)) != null) {
            IVirtualComponent component = ComponentCore.createComponent(this.getContainingProject());
            if (component != null) {
                IProject fileProject = this.getContainingProject();
                if (this.resourceSetSynchronizer.getProject() == fileProject) {
                    List<IContainer> list = Arrays.asList(component.getRootFolder().getUnderlyingFolders());
                    IPath path = WorkbenchResourceHelperBase.getPathFromContainers(list, (IPath)aFile.getFullPath());
                    if (path != null) {
                        return URI.createURI((String)path.toString());
                    }
                    return null;
                }
            } else {
                return super.deNormalize(uri);
            }
        }
        return uri;
    }

    protected URI getContainerRelativeURI(IFile aFile) {
        IPath path = WorkbenchResourceHelperBase.getPathFromContainers((List)this.inputContainers, (IPath)aFile.getFullPath());
        if (path != null) {
            return URI.createURI((String)path.toString());
        }
        return null;
    }

    protected URI getArchiveRelativeURI(IFile aFile, IContainer aContainer) {
        IPath path = WorkbenchResourceHelperBase.getPathFromContainers(Collections.singletonList(aContainer), (IPath)aFile.getFullPath());
        if (path != null) {
            return URI.createURI((String)path.toString());
        }
        return null;
    }

    protected IProject getContainingProject() {
        return this.containingProject;
    }

    protected URIConverterImpl.URIMap getInternalURIMap() {
        if (this.uriMap == null) {
            URIMappingRegistryImpl mappingRegistryImpl = new URIMappingRegistryImpl(){
                private static final long serialVersionUID = 1L;

                protected URI delegatedGetURI(URI uri) {
                    if (ModuleURIUtil.hasContentTypeName(uri)) {
                        return ComponentCoreURIConverter.this.newPlatformURI(uri);
                    }
                    return URIMappingRegistryImpl.INSTANCE.getURI(uri);
                }
            };
            this.uriMap = (URIConverterImpl.URIMap)mappingRegistryImpl.map();
        }
        URIConverterImpl.URIMap uriConverterImplURIMap = null;
        if (this.uriMap instanceof URIConverterImpl.URIMap) {
            uriConverterImplURIMap = (URIConverterImpl.URIMap)this.uriMap;
        }
        return uriConverterImplURIMap;
    }
}

