/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.timing.core.callgraph;

import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.analysis.timing.core.callgraph.AbstractCalledFunction;
import org.eclipse.tracecompass.internal.analysis.timing.core.callgraph.CalledFunction;
import org.eclipse.tracecompass.internal.analysis.timing.core.callgraph.CalledStringFunction;
import org.eclipse.tracecompass.internal.analysis.timing.core.callgraph.ICalledFunction;
import org.eclipse.tracecompass.internal.analysis.timing.core.callgraph.Messages;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;

public final class CalledFunctionFactory {
    private static final String SEPARATOR = ": ";
    private static final String ERROR_MSG = "Cannot create a called function of type : ";

    private CalledFunctionFactory() {
    }

    public static AbstractCalledFunction create(long start, long end, int depth, ITmfStateValue stateValue, int processId, @Nullable ICalledFunction parent) {
        switch (stateValue.getType()) {
            case INTEGER: {
                return CalledFunctionFactory.create(start, end, depth, stateValue.unboxInt(), processId, parent);
            }
            case LONG: {
                return CalledFunctionFactory.create(start, end, depth, stateValue.unboxLong(), processId, parent);
            }
            case STRING: {
                return CalledFunctionFactory.create(start, end, depth, stateValue.unboxStr(), processId, parent);
            }
        }
        throw new IllegalArgumentException(ERROR_MSG + stateValue.getType() + SEPARATOR + stateValue.toString());
    }

    private static CalledFunction create(long start, long end, int depth, long value, int processId, @Nullable ICalledFunction parent) {
        if (start > end) {
            throw new IllegalArgumentException(String.valueOf(Messages.TimeError) + '[' + start + ',' + end + ']');
        }
        return new CalledFunction(start, end, value, depth, processId, parent);
    }

    public static CalledStringFunction create(long start, long end, int depth, String value, int processId, @Nullable ICalledFunction parent) {
        if (start > end) {
            throw new IllegalArgumentException(String.valueOf(Messages.TimeError) + '[' + start + ',' + end + ']');
        }
        return new CalledStringFunction(start, end, value, depth, processId, parent);
    }
}

