/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.wizard.shareproject;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.team.svn.core.connector.SVNChangeStatus;
import org.eclipse.team.svn.core.resource.IResourceProvider;
import org.eclipse.team.svn.core.utility.SVNUtility;
import org.eclipse.team.svn.ui.SVNTeamUIPlugin;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.utility.ColumnedViewerComparator;
import org.eclipse.team.svn.ui.wizard.AbstractVerifiedWizardPage;
import org.eclipse.ui.PlatformUI;

public class SelectProjectsGroupPage
extends AbstractVerifiedWizardPage
implements IResourceProvider {
    protected IProject[] allProjects;
    protected Map projectGroups;
    protected int analysisDepth;
    protected int maxURLLength;
    protected String selectedGroup;
    protected Combo groupsCombo;
    protected Combo analysisDepthCombo;
    protected TableViewer viewer;

    public SelectProjectsGroupPage(IProject[] projects) {
        super(SelectProjectsGroupPage.class.getName(), SVNUIMessages.SelectProjectsGroupPage_Title, SVNTeamUIPlugin.instance().getImageDescriptor("icons/wizards/newconnect.gif"));
        this.setDescription(SVNUIMessages.SelectProjectsGroupPage_Description);
        this.allProjects = projects;
        this.analysisDepth = 2;
        this.maxURLLength = 0;
        this.performAnalysis();
        this.selectedGroup = this.projectGroups.get(null) != null ? null : (String)this.projectGroups.keySet().iterator().next();
    }

    public boolean isGroupSelectionRequired() {
        return this.allProjects.length > 1;
    }

    public IResource[] getResources() {
        List group = this.getProjectsGroup(this.selectedGroup);
        return group.toArray(new IProject[group.size()]);
    }

    protected void performAnalysis() {
        this.projectGroups = new LinkedHashMap();
        int i = 0;
        while (i < this.allProjects.length) {
            SVNChangeStatus info = SVNUtility.getSVNInfoForNotConnected((IResource)this.allProjects[i]);
            if (info == null) {
                this.getProjectsGroup(null).add(this.allProjects[i]);
            } else {
                IPath url = SVNUtility.createPathForSVNUrl((String)SVNUtility.decodeURL((String)info.url));
                if (this.maxURLLength < url.segmentCount()) {
                    this.maxURLLength = url.segmentCount();
                }
                if (url.segmentCount() > this.analysisDepth) {
                    url = url.uptoSegment(this.analysisDepth);
                }
                this.getProjectsGroup(url.toString()).add(this.allProjects[i]);
            }
            ++i;
        }
        if (this.maxURLLength < this.analysisDepth) {
            this.analysisDepth = this.maxURLLength;
        }
    }

    protected List getProjectsGroup(Object key) {
        ArrayList retVal = (ArrayList)this.projectGroups.get(key);
        if (retVal == null) {
            retVal = new ArrayList();
            this.projectGroups.put(key, retVal);
        }
        return retVal;
    }

    protected void setGroupsComboItems() {
        ArrayList groups = new ArrayList(this.projectGroups.keySet());
        groups.remove(null);
        this.groupsCombo.setItems(groups.toArray(new String[groups.size()]));
        this.groupsCombo.select(0);
        if (groups.size() > 0) {
            this.selectedGroup = this.groupsCombo.getItem(0);
        }
    }

    protected Composite createControlImpl(Composite parent) {
        String[] allItems;
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        composite.setLayoutData((Object)data);
        this.initializeDialogUnits((Control)parent);
        Label label = new Label(composite, 64);
        data = new GridData(768);
        data.horizontalSpan = 2;
        data.heightHint = this.convertHeightInCharsToPixels(3);
        data.widthHint = 420;
        label.setLayoutData((Object)data);
        label.setText(SVNUIMessages.SelectProjectsGroupPage_Hint);
        Button shareProjectsButton = new Button(composite, 16);
        data = new GridData();
        data.horizontalSpan = 2;
        shareProjectsButton.setLayoutData((Object)data);
        shareProjectsButton.setText(SVNUIMessages.SelectProjectsGroupPage_ShareNew);
        boolean newEnabled = this.projectGroups.get(null) != null;
        shareProjectsButton.setEnabled(newEnabled);
        shareProjectsButton.setSelection(newEnabled);
        shareProjectsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (((Button)e.widget).getSelection()) {
                    SelectProjectsGroupPage.this.groupsCombo.setEnabled(false);
                    SelectProjectsGroupPage.this.analysisDepthCombo.setEnabled(false);
                    SelectProjectsGroupPage.this.selectedGroup = null;
                }
                SelectProjectsGroupPage.this.viewer.setInput((Object)SelectProjectsGroupPage.this.projectGroups);
            }
        });
        Button reconnectProjectsButton = new Button(composite, 16);
        data = new GridData();
        data.horizontalSpan = 2;
        reconnectProjectsButton.setLayoutData((Object)data);
        reconnectProjectsButton.setEnabled(this.projectGroups.size() > 1 || this.projectGroups.get(null) == null);
        reconnectProjectsButton.setText(SVNUIMessages.SelectProjectsGroupPage_Reconnect);
        reconnectProjectsButton.setSelection(!newEnabled);
        reconnectProjectsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (((Button)e.widget).getSelection()) {
                    SelectProjectsGroupPage.this.groupsCombo.setEnabled(true);
                    SelectProjectsGroupPage.this.analysisDepthCombo.setEnabled(true);
                    SelectProjectsGroupPage.this.selectedGroup = SelectProjectsGroupPage.this.groupsCombo.getItem(SelectProjectsGroupPage.this.groupsCombo.getSelectionIndex());
                }
                SelectProjectsGroupPage.this.viewer.setInput((Object)SelectProjectsGroupPage.this.projectGroups);
            }
        });
        this.analysisDepthCombo = new Combo(composite, 2056);
        data = new GridData();
        this.analysisDepthCombo.setLayoutData((Object)data);
        this.analysisDepthCombo.setVisibleItemCount(10);
        this.analysisDepthCombo.setEnabled(!newEnabled);
        this.analysisDepthCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectProjectsGroupPage.this.analysisDepth = ((Combo)e.widget).getSelectionIndex() + 1;
                SelectProjectsGroupPage.this.performAnalysis();
                SelectProjectsGroupPage.this.setGroupsComboItems();
                SelectProjectsGroupPage.this.viewer.setInput((Object)SelectProjectsGroupPage.this.projectGroups);
            }
        });
        String[] items = allItems = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9"};
        if (this.maxURLLength < 10) {
            items = new String[this.maxURLLength];
            System.arraycopy(allItems, 0, items, 0, this.maxURLLength);
        }
        this.analysisDepthCombo.setItems(items);
        this.analysisDepthCombo.select(1);
        this.groupsCombo = new Combo(composite, 2056);
        data = new GridData(768);
        this.groupsCombo.setLayoutData((Object)data);
        this.setGroupsComboItems();
        this.groupsCombo.setEnabled(!newEnabled);
        this.groupsCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Combo c = (Combo)e.widget;
                SelectProjectsGroupPage.this.selectedGroup = c.getItem(c.getSelectionIndex());
                SelectProjectsGroupPage.this.viewer.setInput((Object)SelectProjectsGroupPage.this.projectGroups);
            }
        });
        label = new Label(composite, 0);
        data = new GridData();
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        label.setText(SVNUIMessages.SelectProjectsGroupPage_ProjectsList);
        this.viewer = new TableViewer(composite, 68356);
        Table table = this.viewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        data = new GridData(1808);
        data.widthHint = 420;
        data.horizontalSpan = 2;
        table.setLayoutData((Object)data);
        this.viewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                List group = SelectProjectsGroupPage.this.getProjectsGroup(SelectProjectsGroupPage.this.selectedGroup);
                return group.toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.viewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public void removeListener(ILabelProviderListener listener) {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void dispose() {
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                return ((IProject)element).getName();
            }
        });
        ColumnedViewerComparator comparator = new ColumnedViewerComparator((Viewer)this.viewer){

            public int compareImpl(Viewer viewer, Object row1, Object row2) {
                return ColumnedViewerComparator.compare(row1.toString(), row2.toString());
            }
        };
        TableColumn col = new TableColumn(table, 0);
        col.setResizable(false);
        col.setText(SVNUIMessages.SelectProjectsGroupPage_ProjectName);
        col.addSelectionListener((SelectionListener)comparator);
        TableLayout tLayout = new TableLayout();
        tLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(100));
        table.setLayout((Layout)tLayout);
        this.viewer.getTable().setSortDirection(128);
        this.viewer.getTable().setSortColumn(this.viewer.getTable().getColumn(0));
        this.selectedGroup = this.projectGroups.get(null) != null ? null : (String)this.projectGroups.keySet().iterator().next();
        this.viewer.setInput((Object)this.projectGroups);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.team.svn.help.projectGroupContext");
        return composite;
    }
}

