/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.gef.commands;

import java.util.List;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.sapphire.ui.Point;
import org.eclipse.sapphire.ui.diagram.DiagramConnectionPart;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodeBounds;
import org.eclipse.sapphire.ui.swt.gef.SapphireDiagramEditor;
import org.eclipse.sapphire.ui.swt.gef.model.DiagramConnectionModel;
import org.eclipse.sapphire.ui.swt.gef.model.DiagramNodeModel;
import org.eclipse.sapphire.ui.swt.gef.parts.DiagramNodeEditPart;

public class MoveNodeCommand
extends Command {
    private DiagramNodeModel node;
    private Rectangle rectangle;

    public MoveNodeCommand(DiagramNodeModel node, Rectangle rectangle) {
        this.node = node;
        this.rectangle = rectangle;
    }

    public void execute() {
        this.moveBendpoints();
        this.node.getModelPart().setNodeBounds(this.rectangle.x, this.rectangle.y, this.rectangle.width, this.rectangle.height);
    }

    private void moveBendpoints() {
        DiagramNodeBounds bounds = this.node.getModelPart().getNodeBounds();
        int deltaX = this.rectangle.x - bounds.getX();
        int deltaY = this.rectangle.y - bounds.getY();
        if (deltaX != 0 || deltaY != 0) {
            SapphireDiagramEditor editor = this.node.getDiagramModel().getSapphireDiagramEditor();
            List<DiagramConnectionModel> srcConnections = this.node.getSourceConnections();
            for (GraphicalEditPart part : editor.getSelectedEditParts()) {
                if (!(part instanceof DiagramNodeEditPart)) continue;
                DiagramNodeModel otherNode = ((DiagramNodeEditPart)part).getCastedModel();
                List<DiagramConnectionModel> targetConnections = otherNode.getTargetConnections();
                for (DiagramConnectionModel conn : targetConnections) {
                    if (!srcConnections.contains(conn)) continue;
                    this.moveAllBendpoints(conn, deltaX, deltaY);
                }
            }
        }
    }

    private void moveAllBendpoints(DiagramConnectionModel conn, int deltaX, int deltaY) {
        DiagramConnectionPart part = conn.getModelPart();
        List pts = part.getBendpoints();
        int i = 0;
        while (i < pts.size()) {
            Point current = (Point)pts.get(i);
            part.updateBendpoint(i, current.getX() + deltaX, current.getY() + deltaY);
            ++i;
        }
    }
}

