/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.internal;

import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.Length;
import org.eclipse.sapphire.ListProperty;
import org.eclipse.sapphire.PropertyDef;
import org.eclipse.sapphire.internal.LengthFactsServiceForList;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.services.ServiceCondition;
import org.eclipse.sapphire.services.ServiceContext;
import org.eclipse.sapphire.services.ValidationService;

public final class LengthValidationServiceForList
extends ValidationService {
    private int min;
    private int max;

    @Override
    protected void initValidationService() {
        PropertyDef property = this.context(PropertyDef.class);
        Length length = property.getAnnotation(Length.class);
        this.min = length.min();
        this.max = length.max();
    }

    @Override
    protected Status compute() {
        int length = this.context(ElementList.class).size();
        if (length < this.min) {
            if (this.min == 1) {
                return Status.createErrorStatus(LengthFactsServiceForList.atLeastOneStatement.text());
            }
            String msg = LengthFactsServiceForList.minLengthStatement.format(this.min);
            return Status.createErrorStatus(msg);
        }
        if (length > this.max) {
            String msg = LengthFactsServiceForList.maxLengthStatement.format(this.max);
            return Status.createErrorStatus(msg);
        }
        return Status.createOkStatus();
    }

    public static final class Condition
    extends ServiceCondition {
        @Override
        public boolean applicable(ServiceContext context) {
            ListProperty property = context.find(ListProperty.class);
            if (property != null) {
                Length length = property.getAnnotation(Length.class);
                return length != null && (length.min() > 0 || length.max() < Integer.MAX_VALUE);
            }
            return false;
        }
    }
}

