/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.remote.internal.console;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.remote.console";
    private static Activator plugin;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    protected void initializeImageRegistry(ImageRegistry imageRegistry) {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            map.put("TerminalViewNewTerminal", "newterminal.gif");
            map.put("ImageClclConnect", "connect_co.gif");
            map.put("ImageClclDisconnect", "disconnect_co.gif");
            map.put("ImageClclSettings", "properties_tsk.gif");
            map.put("ImageClclCommandInputField", "command_input_field.gif");
            map.put("ImageClclScrollLock", "lock_co.gif");
            this.loadImageRegistry(imageRegistry, "clcl16/", map);
            map.clear();
            map.put("TerminalViewNewTerminal", "newterminal.gif");
            map.put("ImageElclConnect", "connect_co.gif");
            map.put("ImageElclDisconnect", "disconnect_co.gif");
            map.put("ImageElclSettings", "properties_tsk.gif");
            map.put("ImageDlclCommandInputField", "command_input_field.gif");
            map.put("ImageElclScrollLock", "lock_co.gif");
            map.put("ImageElclRemove", "rem_co.gif");
            this.loadImageRegistry(imageRegistry, "elcl16/", map);
            map.clear();
            map.put("TerminalViewNewTerminal", "newterminal.gif");
            map.put("ImageDlclConnect", "connect_co.gif");
            map.put("ImageDlclDisconnect", "disconnect_co.gif");
            map.put("ImageDlclSettings", "properties_tsk.gif");
            map.put("ImageDlclCommandInputField", "command_input_field.gif");
            map.put("ImageDlclScrollLock", "lock_co.gif");
            map.put("ImageDlclRemove", "rem_co.gif");
            this.loadImageRegistry(imageRegistry, "dlcl16/", map);
            map.clear();
            map.put("TerminalView", "terminal_view.gif");
            this.loadImageRegistry(imageRegistry, "eview16/", map);
            map.clear();
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
    }

    protected void loadImageRegistry(ImageRegistry imageRegistry, String strDir, HashMap<String, String> map) throws MalformedURLException {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            URL url = plugin.getBundle().getEntry("icons/" + strDir + entry.getValue());
            ImageDescriptor imageDescriptor = ImageDescriptor.createFromURL((URL)url);
            imageRegistry.put(entry.getKey(), imageDescriptor);
        }
    }

    public static void log(IStatus status) {
        Activator.getDefault().getLog().log(status);
    }

    public static void log(String msg) {
        Activator.log((IStatus)new Status(4, PLUGIN_ID, 4, msg, null));
    }

    public static void log(Throwable e) {
        Activator.log((IStatus)new Status(4, PLUGIN_ID, 4, e.getMessage(), e));
    }

    public static <T> T getService(Class<T> service) {
        BundleContext context = plugin.getBundle().getBundleContext();
        ServiceReference ref = context.getServiceReference(service);
        return (T)(ref != null ? context.getService(ref) : null);
    }
}

