/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.lml.ui.providers;

import org.eclipse.ptp.rm.lml.core.elements.Nodedisplay;
import org.eclipse.ptp.rm.lml.core.events.INodedisplayZoomEvent;
import org.eclipse.ptp.rm.lml.core.events.IRectangleSizeChangeEvent;
import org.eclipse.ptp.rm.lml.core.listeners.INodedisplayZoomListener;
import org.eclipse.ptp.rm.lml.core.listeners.IRectangleSizeChangeListener;
import org.eclipse.ptp.rm.lml.core.model.ILguiItem;
import org.eclipse.ptp.rm.lml.ui.providers.AbstractNodedisplayView;
import org.eclipse.ptp.rm.lml.ui.providers.NodedisplayViewDecorator;
import org.eclipse.swt.widgets.Composite;

public abstract class NodedisplayViewZoomable
extends NodedisplayViewDecorator {
    private int rectangleSize = 7;

    public NodedisplayViewZoomable(AbstractNodedisplayView nodedisplay, Composite parent) {
        super(nodedisplay, parent);
        this.addZoomListener();
        this.setRectangleSize(this.rectangleSize);
    }

    @Override
    public void update() {
        super.update();
        this.nodedisplayView.setMinimalRectangleSize(this.getRectangleSize());
    }

    @Override
    public void update(ILguiItem lguiItem) {
        super.update(lguiItem);
        this.nodedisplayView.setMinimalRectangleSize(this.getRectangleSize());
    }

    @Override
    public void update(ILguiItem lguiItem, Nodedisplay nodedislay) {
        super.update(lguiItem, nodedislay);
        this.nodedisplayView.setMinimalRectangleSize(this.getRectangleSize());
    }

    private void addZoomListener() {
        this.nodedisplayView.addZoomListener(new INodedisplayZoomListener(){

            public void handleEvent(INodedisplayZoomEvent event) {
                NodedisplayViewZoomable.this.nodedisplayView.setMinimalRectangleSize(NodedisplayViewZoomable.this.getRectangleSize());
            }
        });
        this.nodedisplayView.addRectangleListener(new IRectangleSizeChangeListener(){

            public void handleEvent(IRectangleSizeChangeEvent event) {
                NodedisplayViewZoomable.this.handleNewRectangleSize(NodedisplayViewZoomable.this.nodedisplayView.getMinimalRectangleSize());
                NodedisplayViewZoomable.this.rectangleSize = NodedisplayViewZoomable.this.nodedisplayView.getMinimalRectangleSize();
            }
        });
    }

    protected int getRectangleSize() {
        return this.rectangleSize;
    }

    protected abstract void handleNewRectangleSize(int var1);

    protected void setRectangleSize(int rectangleSize) {
        this.rectangleSize = rectangleSize;
        this.nodedisplayView.setMinimalRectangleSize(this.getRectangleSize());
    }
}

