/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.debug.core.sourcelookup;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.sourcelookup.ISourceContainerType;
import org.eclipse.debug.core.sourcelookup.containers.AbstractSourceContainer;
import org.eclipse.debug.core.sourcelookup.containers.LocalFileStorage;
import org.eclipse.ptp.internal.debug.core.PTPDebugCorePlugin;
import org.eclipse.ptp.internal.debug.core.messages.Messages;

public class AbsolutePathSourceContainer
extends AbstractSourceContainer {
    public static final String TYPE_ID = String.valueOf(PTPDebugCorePlugin.getUniqueIdentifier()) + ".containerType.absolutePath";

    public Object[] findSourceElements(String name) throws CoreException {
        File file;
        if (name != null && this.isValidAbsoluteFilePath(file = new File(name))) {
            return this.findSourceElementByFile(file);
        }
        return new Object[0];
    }

    public String getName() {
        return Messages.AbsolutePathSourceContainer_2;
    }

    public ISourceContainerType getType() {
        return this.getSourceContainerType(TYPE_ID);
    }

    public boolean isValidAbsoluteFilePath(File file) {
        return file.isAbsolute() && file.exists() && file.isFile();
    }

    public boolean isValidAbsoluteFilePath(String name) {
        return this.isValidAbsoluteFilePath(new File(name));
    }

    private Object[] findSourceElementByFile(File file) {
        Object[] wfiles = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocation((IPath)new Path(file.getAbsolutePath()));
        if (wfiles.length > 0) {
            return wfiles;
        }
        try {
            wfiles = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocation((IPath)new Path(file.getCanonicalPath()));
            if (wfiles.length > 0) {
                return wfiles;
            }
            String projectName = this.getDirector().getLaunchConfiguration().getAttribute("org.eclipse.ptp.launch.PROJECT_ATTR", "");
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            if (project != null) {
                IPath iPath = Path.fromOSString((String)file.getCanonicalPath());
            }
        }
        catch (IOException iOException) {
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return new LocalFileStorage[]{new LocalFileStorage(file)};
    }
}

