/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.debug.core.pdi.manager;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.debug.core.TaskSet;
import org.eclipse.ptp.debug.core.pdi.IPDISession;
import org.eclipse.ptp.debug.core.pdi.PDIException;
import org.eclipse.ptp.debug.core.pdi.event.IPDIChangedEvent;
import org.eclipse.ptp.debug.core.pdi.event.IPDIDestroyedEvent;
import org.eclipse.ptp.debug.core.pdi.event.IPDIEvent;
import org.eclipse.ptp.debug.core.pdi.manager.IPDIExpressionManager;
import org.eclipse.ptp.debug.core.pdi.model.IPDIExpression;
import org.eclipse.ptp.debug.core.pdi.model.IPDILocalVariable;
import org.eclipse.ptp.debug.core.pdi.model.IPDIMultiExpressions;
import org.eclipse.ptp.debug.core.pdi.model.IPDIStackFrame;
import org.eclipse.ptp.debug.core.pdi.model.IPDITarget;
import org.eclipse.ptp.debug.core.pdi.model.IPDITargetExpression;
import org.eclipse.ptp.debug.core.pdi.model.IPDIThread;
import org.eclipse.ptp.debug.core.pdi.model.IPDIVariable;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIF;
import org.eclipse.ptp.debug.core.pdi.request.IPDIDeleteVariableRequest;
import org.eclipse.ptp.debug.core.pdi.request.IPDIEvaluateExpressionRequest;
import org.eclipse.ptp.debug.core.pdi.request.IPDIEvaluatePartialExpressionRequest;
import org.eclipse.ptp.internal.debug.core.pdi.manager.AbstractPDIManager;
import org.eclipse.ptp.internal.debug.core.pdi.messages.Messages;

public class ExpressionManager
extends AbstractPDIManager
implements IPDIExpressionManager {
    static final IPDIExpression[] EMPTY_EXPRESSIONS = new IPDIExpression[0];
    Map<TaskSet, List<IPDIExpression>> expMap = new Hashtable<TaskSet, List<IPDIExpression>>();
    Map<TaskSet, List<IPDIVariable>> varMap = new Hashtable<TaskSet, List<IPDIVariable>>();
    Map<String, IPDIMultiExpressions> mutliExprMap = new HashMap<String, IPDIMultiExpressions>();

    public ExpressionManager(IPDISession session) {
        super(session, true);
    }

    @Override
    public void cleanMultiExpressions(TaskSet tasks, IProgressMonitor monitor) throws PDIException {
        IPDIMultiExpressions[] iPDIMultiExpressionsArray = this.getMultiExpressions();
        int n = iPDIMultiExpressionsArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPDIMultiExpressions mexpr = iPDIMultiExpressionsArray[n2];
            mexpr.cleanExpressionsValue(tasks, monitor);
            ++n2;
        }
    }

    @Override
    public void cleanMultiExpressions(String exprText, TaskSet tasks, IProgressMonitor monitor) throws PDIException {
        IPDIMultiExpressions mexpr = this.getMultiExpression(exprText);
        if (mexpr == null) {
            throw new PDIException(tasks, NLS.bind((String)Messages.ExpressionManager_0, (Object)exprText));
        }
        mexpr.cleanExpressionsValue(tasks, monitor);
    }

    @Override
    public IPDITargetExpression createExpression(TaskSet qTasks, String name) throws PDIException {
        IPDITargetExpression expression = this.session.getModelFactory().newExpression(this.session, qTasks, name);
        List<IPDIExpression> exprList = this.getExpressionList(qTasks);
        exprList.add(expression);
        return expression;
    }

    @Override
    public void createMutliExpressions(TaskSet tasks, String exprText, boolean enabled) {
        this.mutliExprMap.put(exprText, this.session.getModelFactory().newMultiExpressions(this.session, tasks, exprText, enabled));
    }

    @Override
    public IPDIVariable createVariable(IPDIStackFrame frame, String expr) throws PDIException {
        IPDITarget target = frame.getTarget();
        IPDIThread currentThread = target.getCurrentThread();
        IPDIStackFrame currentFrame = currentThread.getCurrentStackFrame();
        target.lockTarget();
        try {
            target.setCurrentThread(frame.getThread(), false);
            frame.getThread().setCurrentStackFrame(frame, false);
            IPDIEvaluatePartialExpressionRequest request = this.session.getRequestFactory().getEvaluatePartialExpressionRequest(target.getTasks(), expr, null, false);
            this.session.getEventRequestManager().addEventRequest(request);
            IAIF aif = request.getPartialAIF(target.getTasks());
            String varid = request.getId(target.getTasks());
            IPDILocalVariable v = this.session.getModelFactory().newLocalVariable(this.session, target.getTasks(), null, frame, expr, null, 0, 0, varid);
            v.setAIF(aif);
            List<IPDIVariable> varList = this.getVariableList(target.getTasks());
            varList.add(v);
            IPDILocalVariable iPDILocalVariable = v;
            return iPDILocalVariable;
        }
        finally {
            target.setCurrentThread(currentThread, false);
            currentThread.setCurrentStackFrame(currentFrame, false);
            target.releaseTarget();
        }
    }

    public void deleteAllVariables(TaskSet qTasks) throws PDIException {
        IPDIVariable[] variables;
        List<IPDIVariable> varList = this.getVariableList(qTasks);
        IPDIVariable[] iPDIVariableArray = variables = varList.toArray(new IPDIVariable[varList.size()]);
        int n = variables.length;
        int n2 = 0;
        while (n2 < n) {
            IPDIVariable variable = iPDIVariableArray[n2];
            this.deleteVariable(variable);
            ++n2;
        }
    }

    @Override
    public void deleteVariable(IPDIVariable variable) throws PDIException {
        IPDIDeleteVariableRequest request = this.session.getRequestFactory().getDeletePartialExpressionRequest(variable.getTasks(), variable.getId());
        this.session.getEventRequestManager().addEventRequest(request);
        request.waitUntilCompleted(variable.getTasks());
        List<IPDIVariable> varList = this.getVariableList(variable.getTasks());
        varList.remove(variable);
        ArrayList<IPDIDestroyedEvent> eventList = new ArrayList<IPDIDestroyedEvent>();
        IPDIVariable[] children = variable.getChildren();
        if (children != null) {
            IPDIVariable[] iPDIVariableArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IPDIVariable child = iPDIVariableArray[n2];
                if (children[0] instanceof IPDIVariable) {
                    eventList.add(this.session.getEventFactory().newDestroyedEvent(this.session.getEventFactory().newVariableInfo(this.session, variable.getTasks(), child.getId(), child)));
                }
                ++n2;
            }
        }
        eventList.add(this.session.getEventFactory().newDestroyedEvent(this.session.getEventFactory().newVariableInfo(this.session, variable.getTasks(), variable.getId(), variable)));
        this.session.getEventManager().fireEvents(eventList.toArray(new IPDIEvent[0]));
    }

    public void destroyAllExpressions(TaskSet qTasks) throws PDIException {
        IPDIExpression[] expressions = this.getExpressions(qTasks);
        this.destroyExpressions(qTasks, expressions);
    }

    @Override
    public void destroyExpressions(TaskSet qTasks, IPDIExpression[] expressions) throws PDIException {
        List<IPDIExpression> expList = this.getExpressionList(qTasks);
        IPDIExpression[] iPDIExpressionArray = expressions;
        int n = expressions.length;
        int n2 = 0;
        while (n2 < n) {
            IPDIExpression expression = iPDIExpressionArray[n2];
            expList.remove(expression);
            ++n2;
        }
    }

    public IAIF getAIF(TaskSet qTasks, String expr) throws PDIException {
        IPDIEvaluatePartialExpressionRequest request = this.session.getRequestFactory().getEvaluatePartialExpressionRequest(qTasks, expr, null, false);
        this.session.getEventRequestManager().addEventRequest(request);
        return request.getPartialAIF(qTasks);
    }

    public IPDIExpression[] getExpressions(TaskSet qTasks) throws PDIException {
        List<IPDIExpression> expList = this.expMap.get(qTasks);
        if (expList != null) {
            return expList.toArray(EMPTY_EXPRESSIONS);
        }
        return EMPTY_EXPRESSIONS;
    }

    @Override
    public IAIF getExpressionValue(TaskSet qTasks, String expr) throws PDIException {
        IPDIEvaluateExpressionRequest request = this.session.getRequestFactory().getEvaluateExpressionRequest(qTasks, expr);
        this.session.getEventRequestManager().addEventRequest(request);
        return request.getAIF(qTasks);
    }

    @Override
    public IPDIMultiExpressions getMultiExpression(String exprText) {
        return this.mutliExprMap.get(exprText);
    }

    @Override
    public IPDIMultiExpressions[] getMultiExpressions() {
        return this.mutliExprMap.values().toArray(new IPDIMultiExpressions[0]);
    }

    @Override
    public IPDIExpression[] getMultiExpressions(int task) {
        ArrayList<IPDIExpression> exprList = new ArrayList<IPDIExpression>();
        IPDIMultiExpressions[] iPDIMultiExpressionsArray = this.getMultiExpressions();
        int n = iPDIMultiExpressionsArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPDIExpression expr;
            IPDIMultiExpressions mexpr = iPDIMultiExpressionsArray[n2];
            if (mexpr.isEnabled() && (expr = mexpr.getExpression(task)) != null) {
                exprList.add(expr);
            }
            ++n2;
        }
        return exprList.toArray(new IPDIExpression[0]);
    }

    public IPDIVariable getVariable(TaskSet qTasks, String varid) {
        IPDIVariable[] vars;
        List<IPDIVariable> varList = this.getVariableList(qTasks);
        IPDIVariable[] iPDIVariableArray = vars = varList.toArray(new IPDIVariable[0]);
        int n = vars.length;
        int n2 = 0;
        while (n2 < n) {
            IPDIVariable var = iPDIVariableArray[n2];
            if (var.getId().equals(varid)) {
                return var;
            }
            IPDIVariable v = var.getChild(varid);
            if (v != null) {
                return v;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public void removeMutliExpressions(TaskSet tasks, String exprText) {
        IPDIMultiExpressions mexpr = this.getMultiExpression(exprText);
        if (mexpr != null) {
            mexpr.removeExpression(tasks);
        }
    }

    @Override
    public void removeMutliExpressions(String exprText) {
        IPDIMultiExpressions mexpr = this.getMultiExpression(exprText);
        if (mexpr != null) {
            mexpr.shutdown();
        }
        this.mutliExprMap.remove(exprText);
    }

    @Override
    public void shutdown() {
        this.expMap.clear();
        this.varMap.clear();
        this.mutliExprMap.clear();
    }

    @Override
    public void update(TaskSet qTasks) throws PDIException {
        this.update(qTasks, new String[0]);
    }

    @Override
    public void update(TaskSet qTasks, String[] varList) throws PDIException {
        ArrayList<IPDIChangedEvent> eventList = new ArrayList<IPDIChangedEvent>();
        String[] stringArray = varList;
        int n = varList.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            IPDIVariable variable = this.getVariable(qTasks, element);
            if (variable != null) {
                eventList.add(this.session.getEventFactory().newChangedEvent(this.session.getEventFactory().newVariableInfo(this.session, qTasks, element, variable)));
            }
            ++n2;
        }
        this.session.getEventManager().fireEvents(eventList.toArray(new IPDIEvent[0]));
    }

    @Override
    public void updateMultiExpressions(TaskSet tasks, IProgressMonitor monitor) throws PDIException {
        IPDIMultiExpressions[] iPDIMultiExpressionsArray = this.getMultiExpressions();
        int n = iPDIMultiExpressionsArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPDIMultiExpressions mexpr = iPDIMultiExpressionsArray[n2];
            if (mexpr.isEnabled()) {
                mexpr.updateExpressionsValue(tasks, monitor);
            }
            ++n2;
        }
    }

    @Override
    public void updateMultiExpressions(String exprText, TaskSet tasks, IProgressMonitor monitor) throws PDIException {
        IPDIMultiExpressions mexpr = this.getMultiExpression(exprText);
        if (mexpr == null) {
            throw new PDIException(tasks, NLS.bind((String)Messages.ExpressionManager_0, (Object)exprText));
        }
        if (mexpr.isEnabled()) {
            mexpr.updateExpressionsValue(tasks, monitor);
        }
    }

    @Override
    public void updateStatusMultiExpressions(String exprText, boolean enabled) {
        IPDIMultiExpressions mexpr = this.getMultiExpression(exprText);
        if (mexpr != null) {
            mexpr.setEnabled(enabled);
        }
    }

    private synchronized List<IPDIExpression> getExpressionList(TaskSet qTasks) {
        List<IPDIExpression> expList = this.expMap.get(qTasks);
        if (expList == null) {
            expList = Collections.synchronizedList(new ArrayList());
            this.expMap.put(qTasks, expList);
        }
        return expList;
    }

    private synchronized List<IPDIVariable> getVariableList(TaskSet qTasks) {
        List<IPDIVariable> varList = this.varMap.get(qTasks);
        if (varList == null) {
            varList = Collections.synchronizedList(new ArrayList());
            this.varMap.put(qTasks, varList);
        }
        return varList;
    }
}

