/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.profile.ui.views;

import org.eclipse.birt.chart.device.IDeviceRenderer;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.GeneratedChartState;
import org.eclipse.birt.chart.factory.Generator;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.impl.BoundsImpl;
import org.eclipse.birt.chart.util.PluginSettings;
import org.eclipse.php.profile.ui.ProfilerUiPlugin;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;

public class ChartViewer
extends Composite
implements PaintListener {
    private IDeviceRenderer fDeviceRenderer = null;
    private Chart fChartModel = null;
    private GeneratedChartState fGeneratedChartState = null;

    public ChartViewer(Composite parent, int style) {
        super(parent, style);
        PluginSettings ps = PluginSettings.instance();
        try {
            this.fDeviceRenderer = ps.getDevice("dv.SWT");
        }
        catch (ChartException ex) {
            ProfilerUiPlugin.log(ex);
        }
        this.addPaintListener(this);
    }

    public final void paintControl(PaintEvent e) {
        if (this.fChartModel == null) {
            return;
        }
        if (this.fDeviceRenderer == null) {
            return;
        }
        Rectangle d = this.getClientArea();
        Image imgChart = new Image((Device)this.getDisplay(), d);
        GC gcImage = new GC((Drawable)imgChart);
        this.fDeviceRenderer.setProperty("device.output.context", (Object)gcImage);
        Bounds bo = BoundsImpl.create((double)0.0, (double)0.0, (double)d.width, (double)d.height);
        bo.scale(72.0 / (double)this.fDeviceRenderer.getDisplayServer().getDpiResolution());
        Generator gr = Generator.instance();
        try {
            this.fGeneratedChartState = gr.build(this.fDeviceRenderer.getDisplayServer(), this.fChartModel, bo, null, null, null);
        }
        catch (ChartException ce) {
            ProfilerUiPlugin.log(ce);
        }
        try {
            gr.render(this.fDeviceRenderer, this.fGeneratedChartState);
            GC gc = e.gc;
            gc.drawImage(imgChart, d.x, d.y);
        }
        catch (ChartException gex) {
            ProfilerUiPlugin.log(gex);
        }
    }

    public void updateChartModel(Chart chartModel) {
        this.fChartModel = chartModel;
        this.redraw();
    }
}

