/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.profile.ui.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.php.internal.debug.core.zend.communication.IRemoteFileContentRequestor;
import org.eclipse.php.internal.debug.core.zend.debugger.RemoteDebugger;
import org.eclipse.php.internal.debug.ui.editor.OpenRemoteFileContentRequestor;
import org.eclipse.php.internal.ui.util.EditorUtility;
import org.eclipse.php.profile.core.data.ProfilerCallTraceLayer;
import org.eclipse.php.profile.core.data.ProfilerFunctionData;
import org.eclipse.php.profile.core.data.ProfilerGlobalData;
import org.eclipse.php.profile.ui.PHPProfileUIMessages;
import org.eclipse.php.profile.ui.ProfilerUIImages;
import org.eclipse.php.profile.ui.ProfilerUiPlugin;
import org.eclipse.php.profile.ui.actions.OpenFunctionInvocationStatisticsAction;
import org.eclipse.php.profile.ui.views.ExecutionFlowSorter;
import org.eclipse.php.profile.ui.views.ExecutionFlowTreeElement;
import org.eclipse.php.profile.ui.views.ExecutionFlowView;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionGroup;

public class ExecutionFlowActionGroup
extends ActionGroup {
    private ExecutionFlowView fView;
    private CollapseAllAction fCollapseAllAction;
    private ExpandAllAction fExpandAllAction;
    private SortAction fSortAction;
    private ViewFunctionCallAction fViewFunctionCallAction;
    private ViewFunctionDeclarationAction fViewFunctionDeclarationAction;
    private OpenFunctionInvocationStatisticsAction fOpenFunctionInvocationStatisticsAction;

    public ExecutionFlowActionGroup(ExecutionFlowView view) {
        this.fView = view;
        this.fExpandAllAction = new ExpandAllAction();
        this.fCollapseAllAction = new CollapseAllAction();
        this.fSortAction = new SortAction();
        this.fViewFunctionCallAction = new ViewFunctionCallAction();
        this.fViewFunctionDeclarationAction = new ViewFunctionDeclarationAction();
        this.fOpenFunctionInvocationStatisticsAction = new OpenFunctionInvocationStatisticsAction(this.fView);
    }

    public void fillActionBars(IActionBars actionBars) {
        super.fillActionBars(actionBars);
        IToolBarManager toolbarManager = actionBars.getToolBarManager();
        toolbarManager.add((IAction)this.fExpandAllAction);
        toolbarManager.add((IAction)this.fCollapseAllAction);
        toolbarManager.add((IContributionItem)new Separator());
        toolbarManager.add((IAction)this.fSortAction);
        toolbarManager.add((IContributionItem)new Separator());
    }

    public void fillContextMenu(IMenuManager menu) {
        menu.add((IAction)this.fViewFunctionCallAction);
        menu.add((IAction)this.fViewFunctionDeclarationAction);
        menu.add((IAction)this.fOpenFunctionInvocationStatisticsAction);
        menu.add((IContributionItem)new Separator("additions"));
    }

    public void viewFunctionCallInEditor(ExecutionFlowTreeElement element) {
        ExecutionFlowTreeElement caller = (ExecutionFlowTreeElement)element.getParent();
        if (caller != null) {
            ProfilerCallTraceLayer layer = element.getLayer();
            ProfilerFunctionData data = (ProfilerFunctionData)(caller.isRootElement() ? element.getData() : caller.getData());
            try {
                String url;
                if (EditorUtility.openLocalFile((String)data.getLocalFileName(), (int)layer.getLineNumber()) == null && !ProfilerGlobalData.URL_NOT_AVAILABLE_MSG.equals(url = this.fView.getInput().getGlobalData().getOriginalURL())) {
                    RemoteDebugger.requestRemoteFile((IRemoteFileContentRequestor)new OpenRemoteFileContentRequestor(), (String)data.getAbsoluteFileName(), (int)layer.getLineNumber(), (String)url);
                }
            }
            catch (CoreException coreException) {
                MessageDialog.openError((Shell)this.fView.getViewer().getControl().getShell(), (String)PHPProfileUIMessages.getString("ExecutionFlowActionGroup.0"), (String)NLS.bind((String)PHPProfileUIMessages.getString("ExecutionFlowActionGroup.1"), (Object)data.getLocalFileName()));
            }
        }
    }

    public void viewFunctionCallInEditor(ISelection selection) {
        IStructuredSelection sSelection;
        Object element;
        if (selection != null && selection instanceof IStructuredSelection && (element = (sSelection = (IStructuredSelection)selection).getFirstElement()) instanceof ExecutionFlowTreeElement) {
            ExecutionFlowTreeElement executionFlowElement = (ExecutionFlowTreeElement)element;
            this.viewFunctionCallInEditor(executionFlowElement);
        }
    }

    public void viewFunctionDeclarationInEditor(ExecutionFlowTreeElement element) {
        ProfilerFunctionData data = (ProfilerFunctionData)element.getData();
        try {
            String url;
            if (EditorUtility.openLocalFile((String)data.getLocalFileName(), (int)data.getLineNumber()) == null && !ProfilerGlobalData.URL_NOT_AVAILABLE_MSG.equals(url = this.fView.getInput().getGlobalData().getOriginalURL())) {
                RemoteDebugger.requestRemoteFile((IRemoteFileContentRequestor)new OpenRemoteFileContentRequestor(), (String)data.getAbsoluteFileName(), (int)data.getLineNumber(), (String)url);
            }
        }
        catch (CoreException coreException) {
            MessageDialog.openError((Shell)this.fView.getViewer().getControl().getShell(), (String)PHPProfileUIMessages.getString("ExecutionFlowActionGroup.2"), (String)NLS.bind((String)PHPProfileUIMessages.getString("ExecutionFlowActionGroup.3"), (Object)data.getLocalFileName()));
        }
    }

    public void viewFunctionDeclarationInEditor(ISelection selection) {
        IStructuredSelection sSelection;
        Object element;
        if (selection != null && selection instanceof IStructuredSelection && (element = (sSelection = (IStructuredSelection)selection).getFirstElement()) instanceof ExecutionFlowTreeElement) {
            ExecutionFlowTreeElement executionFlowElement = (ExecutionFlowTreeElement)element;
            this.viewFunctionDeclarationInEditor(executionFlowElement);
        }
    }

    class CollapseAllAction
    extends Action {
        public CollapseAllAction() {
            super(PHPProfileUIMessages.getString("ExecutionFlowActionGroup_0"));
            this.setDescription(PHPProfileUIMessages.getString("ExecutionFlowActionGroup_0"));
            this.setToolTipText(PHPProfileUIMessages.getString("ExecutionFlowActionGroup_0"));
            this.setImageDescriptor(ProfilerUIImages.getImageDescriptor("IMG_ELCL_COLLAPSE_ALL"));
        }

        public void run() {
            ExecutionFlowActionGroup.this.fView.getViewer().getControl().setRedraw(false);
            ExecutionFlowActionGroup.this.fView.getViewer().collapseAll();
            ExecutionFlowActionGroup.this.fView.getViewer().getControl().setRedraw(true);
        }
    }

    class ExpandAllAction
    extends Action {
        public ExpandAllAction() {
            super(PHPProfileUIMessages.getString("ExecutionFlowActionGroup_1"));
            this.setDescription(PHPProfileUIMessages.getString("ExecutionFlowActionGroup_1"));
            this.setToolTipText(PHPProfileUIMessages.getString("ExecutionFlowActionGroup_1"));
            this.setImageDescriptor(ProfilerUIImages.getImageDescriptor("IMG_ELCL_EXPAND_ALL"));
        }

        public void run() {
            ExecutionFlowActionGroup.this.fView.getViewer().getControl().setRedraw(false);
            ExecutionFlowActionGroup.this.fView.getViewer().expandAll();
            ExecutionFlowActionGroup.this.fView.getViewer().getControl().setRedraw(true);
        }
    }

    class SortAction
    extends Action
    implements IMenuCreator {
        private IPreferenceStore fStore;
        private Menu fMenu;

        public SortAction() {
            super(PHPProfileUIMessages.getString("ExecutionFlowActionGroup_2"), 4);
            this.setDescription(PHPProfileUIMessages.getString("ExecutionFlowActionGroup_2"));
            this.setToolTipText(PHPProfileUIMessages.getString("ExecutionFlowActionGroup_2"));
            this.setImageDescriptor(ProfilerUIImages.getImageDescriptor("IMG_ELCL_SORT"));
            this.setMenuCreator(this);
            this.fStore = ProfilerUiPlugin.getDefault().getPreferenceStore();
            ExecutionFlowActionGroup.this.fView.getViewer().setSorter((ViewerSorter)new ExecutionFlowSorter(this.fStore.getInt("executionFlowSortOrder")));
        }

        public void run() {
            final TreeViewer viewer = ExecutionFlowActionGroup.this.fView.getViewer();
            ((ExecutionFlowSorter)viewer.getSorter()).setMode(this.fStore.getInt("executionFlowSortOrder"));
            BusyIndicator.showWhile((Display)viewer.getControl().getDisplay(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    viewer.getControl().setRedraw(false);
                    viewer.refresh();
                    viewer.getControl().setRedraw(true);
                }
            });
        }

        public void dispose() {
            if (this.fMenu != null) {
                this.fMenu.dispose();
            }
        }

        public Menu getMenu(Control parent) {
            if (this.fMenu != null) {
                this.fMenu.dispose();
            }
            this.fMenu = new Menu(parent);
            ActionContributionItem item = new ActionContributionItem((IAction)new SortByAction(PHPProfileUIMessages.getString("ExecutionFlowActionGroup_3"), ExecutionFlowSorter.BY_ORDER));
            item.fill(this.fMenu, -1);
            item = new ActionContributionItem((IAction)new SortByAction(PHPProfileUIMessages.getString("ExecutionFlowActionGroup_4"), ExecutionFlowSorter.BY_DURATION_TIME));
            item.fill(this.fMenu, -1);
            return this.fMenu;
        }

        public Menu getMenu(Menu parent) {
            return null;
        }

        class SortByAction
        extends Action {
            private int fMode;

            public SortByAction(String label, int mode) {
                super(label);
                this.setDescription(label);
                this.setToolTipText(label);
                this.fMode = mode;
                this.setChecked(SortAction.this.fStore.getInt("executionFlowSortOrder") == this.fMode);
            }

            public void run() {
                SortAction.this.fStore.setValue("executionFlowSortOrder", this.fMode);
                SortAction.this.run();
            }
        }
    }

    class ViewFunctionCallAction
    extends Action {
        public ViewFunctionCallAction() {
            super(PHPProfileUIMessages.getString("ExecutionFlowActionGroup_6"));
            this.setDescription(PHPProfileUIMessages.getString("ExecutionFlowActionGroup_6"));
            this.setToolTipText(PHPProfileUIMessages.getString("ExecutionFlowActionGroup_6"));
        }

        public void run() {
            ExecutionFlowActionGroup.this.viewFunctionCallInEditor(ExecutionFlowActionGroup.this.fView.getViewer().getSelection());
        }
    }

    class ViewFunctionDeclarationAction
    extends Action {
        public ViewFunctionDeclarationAction() {
            super(PHPProfileUIMessages.getString("ExecutionFlowActionGroup_7"));
            this.setDescription(PHPProfileUIMessages.getString("ExecutionFlowActionGroup_7"));
            this.setToolTipText(PHPProfileUIMessages.getString("ExecutionFlowActionGroup_7"));
        }

        public void run() {
            ExecutionFlowActionGroup.this.viewFunctionDeclarationInEditor(ExecutionFlowActionGroup.this.fView.getViewer().getSelection());
        }
    }
}

