/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.vpg;

import java.io.Serializable;
import org.eclipse.photran.internal.core.preservation.ReplacementList;
import org.eclipse.photran.internal.core.vpg.IVPGNode;
import org.eclipse.photran.internal.core.vpg.VPG;

public final class VPGEdge<A, T, R extends IVPGNode<T>>
implements Comparable<VPGEdge<?, ?, ?>>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected final R source;
    protected final R sink;
    protected final int type;
    protected transient VPGEdge<A, T, R> origEdge;

    public VPGEdge(R source, R sink, int type) {
        this.source = source;
        this.sink = sink;
        this.type = type;
        this.origEdge = this;
    }

    public VPGEdge(R source, R sink, Enum<?> type) {
        this(source, sink, type.ordinal());
    }

    public R getSource() {
        return this.source;
    }

    public R getSink() {
        return this.sink;
    }

    public int getType() {
        return this.type;
    }

    public VPGEdge<A, T, R> getOriginalEdge() {
        return this.origEdge;
    }

    public T findSource() throws Exception {
        return this.source.getASTNode();
    }

    public T findSink() throws Exception {
        return this.sink.getASTNode();
    }

    @Override
    public int compareTo(VPGEdge<?, ?, ?> that) {
        int result = 0;
        if (this.type < that.type) {
            result = -1;
        } else if (this.type > that.type) {
            result = 1;
        }
        if (result != 0) {
            return result;
        }
        result = this.getClassification().compareTo(that.getClassification());
        if (result != 0) {
            return result;
        }
        if (this.source != null && that.source == null) {
            result = -1;
        } else if (this.source == null && that.source != null) {
            result = 1;
        } else if (this.source != null && that.source != null) {
            result = this.source.compareTo(that.source);
        }
        if (result != 0) {
            return result;
        }
        if (this.sink != null && that.sink == null) {
            result = -1;
        } else if (this.sink == null && that.sink != null) {
            result = 1;
        } else if (this.sink != null && that.sink != null) {
            result = this.sink.compareTo(that.sink);
        }
        return result;
    }

    public String toString() {
        return "Edge of type " + this.type + " from " + this.source + " to " + this.sink;
    }

    public VPGEdge<A, T, R> projectInitial(ReplacementList replacements, VPG<A, T, R> vpg) {
        R srcProj = replacements.projectInitial(this.source, vpg);
        R sinkProj = replacements.projectInitial(this.sink, vpg);
        VPGEdge<A, T, R> result = new VPGEdge<A, T, R>(srcProj, sinkProj, this.type);
        result.origEdge = this;
        return result;
    }

    public VPGEdge<A, T, R> projectFinal(ReplacementList replacements, VPG<A, T, R> vpg) {
        R srcProj = replacements.projectFinal(this.source, vpg);
        R sinkProj = replacements.projectFinal(this.sink, vpg);
        VPGEdge<A, T, R> result = new VPGEdge<A, T, R>(srcProj, sinkProj, this.type);
        result.origEdge = this;
        return result;
    }

    public Classification getClassification() {
        if (this.source != null && this.sink != null) {
            return Classification.EXTERNAL;
        }
        if (this.source != null && this.sink == null) {
            return Classification.INCOMING;
        }
        if (this.source == null && this.sink != null) {
            return Classification.OUTGOING;
        }
        return Classification.INTERNAL;
    }

    public static enum Classification {
        INCOMING,
        OUTGOING,
        INTERNAL,
        EXTERNAL;

    }
}

