/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.mappings;

import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.BasicCollectionAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;
import org.eclipse.persistence.internal.jpa.metadata.columns.ColumnMetadata;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;

public class BasicMapAccessor
extends BasicCollectionAccessor {
    private ColumnMetadata m_keyColumn;
    private String m_keyConverter;
    private String m_valueConverter;

    public BasicMapAccessor() {
        super("<basic-map>");
    }

    public BasicMapAccessor(MetadataAnnotation basicMap, MetadataAccessibleObject accessibleObject, ClassAccessor classAccessor) {
        super(basicMap, accessibleObject, classAccessor);
        MetadataAnnotation valueConvert;
        this.m_keyColumn = new ColumnMetadata(basicMap.getAttributeAnnotation("keyColumn"), this);
        MetadataAnnotation keyConvert = basicMap.getAttributeAnnotation("keyConverter");
        if (keyConvert != null) {
            this.m_keyConverter = keyConvert.getAttributeString("value");
        }
        if ((valueConvert = basicMap.getAttributeAnnotation("valueConverter")) != null) {
            this.m_valueConverter = valueConvert.getAttributeString("value");
        }
        this.setValueColumn(new ColumnMetadata(basicMap.getAttributeAnnotation("valueColumn"), this));
        this.setFetch(basicMap.getAttributeString("fetch"));
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (super.equals(objectToCompare) && objectToCompare instanceof BasicMapAccessor) {
            BasicMapAccessor basicMapAccessor = (BasicMapAccessor)objectToCompare;
            if (!this.valuesMatch(this.m_keyColumn, basicMapAccessor.getKeyColumn())) {
                return false;
            }
            if (!this.valuesMatch(this.m_keyConverter, basicMapAccessor.getKeyConverter())) {
                return false;
            }
            return this.valuesMatch(this.m_valueConverter, basicMapAccessor.getValueConverter());
        }
        return false;
    }

    @Override
    protected ColumnMetadata getColumn(String loggingCtx) {
        if (loggingCtx.equals("metadata_default_value_column")) {
            return super.getColumn(loggingCtx);
        }
        return this.m_keyColumn == null ? super.getColumn(loggingCtx) : this.m_keyColumn;
    }

    @Override
    protected String getDefaultCollectionTableName() {
        if (this.m_keyColumn != null && this.m_keyColumn.getTable() != null && !this.m_keyColumn.getTable().equals("")) {
            return this.m_keyColumn.getTable();
        }
        return super.getDefaultCollectionTableName();
    }

    public ColumnMetadata getKeyColumn() {
        return this.m_keyColumn;
    }

    @Override
    public String getKeyConverter() {
        return this.m_keyConverter;
    }

    @Override
    public MetadataClass getReferenceClass() {
        return this.getReferenceClassFromGeneric();
    }

    @Override
    public String getValueConverter() {
        return this.m_valueConverter;
    }

    @Override
    public boolean hasMapKey() {
        return true;
    }

    @Override
    public void initXMLObject(MetadataAccessibleObject accessibleObject, XMLEntityMappings entityMappings) {
        super.initXMLObject(accessibleObject, entityMappings);
        this.initXMLObject(this.m_keyColumn, accessibleObject);
    }

    @Override
    public boolean isBasicMap() {
        return true;
    }

    @Override
    public void process() {
        if (!this.isValidDirectMapType()) {
            throw ValidationException.invalidTypeForBasicMapAttribute((String)this.getAttributeName(), (Object)this.getRawClass(), (Object)this.getJavaClass());
        }
        this.processDirectMapMapping();
    }

    public void setKeyColumn(ColumnMetadata keyColumn) {
        this.m_keyColumn = keyColumn;
    }

    public void setKeyConverter(String keyConverter) {
        this.m_keyConverter = keyConverter;
    }

    public void setValueConverter(String valueConverter) {
        this.m_valueConverter = valueConverter;
    }
}

