/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.properties.xtext.widget;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParser;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.papyrus.infra.emf.gmf.command.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.ui.emf.dialog.NestedEditingDialogContext;
import org.eclipse.papyrus.infra.widgets.editors.StyledTextReferenceDialog;
import org.eclipse.papyrus.infra.widgets.editors.StyledTextStringEditor;
import org.eclipse.papyrus.infra.widgets.selectors.StringSelector;
import org.eclipse.papyrus.infra.widgets.validator.AbstractValidator;
import org.eclipse.papyrus.uml.properties.xtext.Activator;
import org.eclipse.papyrus.uml.xtext.integration.DefaultXtextDirectEditorConfiguration;
import org.eclipse.papyrus.uml.xtext.integration.StyledTextXtextAdapter;
import org.eclipse.papyrus.uml.xtext.integration.core.ContextElementAdapter;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;

public class UMLXtextReferenceValueEditor
extends StyledTextReferenceDialog
implements ContextElementAdapter.IContextElementProvider,
SelectionListener {
    private static final String EQUAL = "=";
    private static final String DEFAULT_VALIDATE_VALUE = "0";
    private StyledTextXtextAdapter xtextAdapter;
    private DefaultXtextDirectEditorConfiguration configuration;
    private final ContextElementAdapter contextElementAdapter = new ContextElementAdapter((ContextElementAdapter.IContextElementProvider)this);
    private boolean canParse = false;
    private String directEditorConfiguration;

    public UMLXtextReferenceValueEditor(Composite parent, int style) {
        this(parent, style, null);
    }

    public UMLXtextReferenceValueEditor(Composite parent, int style, AbstractValidator targetValidator) {
        super(parent, style, targetValidator);
        this.styledTextStringEditor.getText().addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                if (UMLXtextReferenceValueEditor.this.canParse) {
                    IParser parser = UMLXtextReferenceValueEditor.this.getParser();
                    if (!(UMLXtextReferenceValueEditor.this.xtextAdapter == null || UMLXtextReferenceValueEditor.this.xtextAdapter != null && UMLXtextReferenceValueEditor.this.xtextAdapter.getCompletionProposalAdapter() != null && UMLXtextReferenceValueEditor.this.xtextAdapter.getCompletionProposalAdapter().delayedIsPopupOpen())) {
                        UMLXtextReferenceValueEditor.this.manageParserCommand(parser);
                        UMLXtextReferenceValueEditor.this.styledTextStringEditor.notifyListeners(16, new Event());
                        UMLXtextReferenceValueEditor.this.styledTextStringEditor.changeColorField();
                        UMLXtextReferenceValueEditor.this.controlDecoration.hide();
                        UMLXtextReferenceValueEditor.this.canParse = false;
                    }
                }
            }

            public void focusGained(FocusEvent e) {
                UMLXtextReferenceValueEditor.this.canParse = true;
            }
        });
    }

    protected void manageParserCommand(IParser parser) {
        if (parser != null) {
            ICommand command = null;
            command = this.modelProperty != null && this.modelProperty.getValueType() instanceof EStructuralFeature ? parser.getParseCommand((IAdaptable)new EObjectAdapter((EObject)((EStructuralFeature)this.modelProperty.getValueType())), this.styledTextStringEditor.getText().getText(), 0) : parser.getParseCommand((IAdaptable)new EObjectAdapter((EObject)this.getValue()), this.styledTextStringEditor.getText().getText(), 0);
            TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((Object)this.getContextElement());
            if (domain == null) {
                ResourceSet rs = NestedEditingDialogContext.getInstance().getResourceSet();
                domain = TransactionUtil.getEditingDomain((ResourceSet)rs);
            }
            if (domain != null) {
                domain.getCommandStack().execute((Command)new GMFtoEMFCommandWrapper(command));
            }
        }
    }

    protected StyledTextStringEditor createStyledTextStringEditor(Composite parent, String initialValue, int style) {
        int createdStyle = style | 4;
        return new StyledTextStringEditor(parent, createdStyle, this.targetValidator){

            public StyledText createStyledText(Composite parent, String value, int createdStyle) {
                StyledText txt = new StyledText(parent, createdStyle);
                if (UMLXtextReferenceValueEditor.this.labelProvider != null) {
                    txt.setText(UMLXtextReferenceValueEditor.this.labelProvider.getText(this.getValue()));
                }
                return txt;
            }

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                    if ((this.text.getStyle() & 2) == 0) {
                        if (e.stateMask == 0) {
                            this.notifyChange();
                        }
                    } else if (e.stateMask == 262144) {
                        String str = this.text.getText();
                        if (str.endsWith(StringSelector.LINE_SEPARATOR)) {
                            int newLength = str.length() - StringSelector.LINE_SEPARATOR.length();
                            this.text.setText(str.substring(0, newLength));
                            this.text.setSelection(newLength);
                        }
                        this.notifyChange();
                    }
                }
            }

            protected void notifyChange() {
                if (UMLXtextReferenceValueEditor.this.xtextAdapter != null && UMLXtextReferenceValueEditor.this.xtextAdapter.getCompletionProposalAdapter() != null && UMLXtextReferenceValueEditor.this.xtextAdapter.getCompletionProposalAdapter().delayedIsPopupOpen()) {
                    return;
                }
                UMLXtextReferenceValueEditor.this.canParse = true;
                super.notifyChange();
            }

            public void keyReleased(KeyEvent e) {
            }

            protected String getTextToValidate() {
                String result = super.getTextToValidate();
                if (result.contains(UMLXtextReferenceValueEditor.EQUAL) && result.indexOf(UMLXtextReferenceValueEditor.EQUAL) != result.length() - 1) {
                    result = result.substring(result.indexOf(UMLXtextReferenceValueEditor.EQUAL) + 1, result.length());
                } else {
                    try {
                        Integer.parseInt(result);
                    }
                    catch (NumberFormatException exception) {
                        result = UMLXtextReferenceValueEditor.DEFAULT_VALIDATE_VALUE;
                    }
                }
                return result;
            }
        };
    }

    public void update() {
        super.update();
        this.updateControls();
    }

    protected void updateXtextAdapters(Control styledText) {
        ContextElementAdapter.IContextElementProvider provider;
        Object oldObjectToEdit = this.configuration != null ? this.configuration.getObjectToEdit() : null;
        DefaultXtextDirectEditorConfiguration newConfiguration = this.getConfigurationFromSelection();
        if (newConfiguration != null && newConfiguration != this.configuration) {
            if (this.xtextAdapter != null) {
                this.xtextAdapter.getFakeResourceContext().getFakeResource().eAdapters().remove((Object)this.contextElementAdapter);
            }
            this.configuration = newConfiguration;
            this.xtextAdapter = new StyledTextXtextAdapter(this.configuration.getInjector());
            EObject semanticElement = (EObject)this.getValue();
            if (semanticElement != null) {
                newConfiguration.preEditAction((Object)semanticElement);
            }
            this.xtextAdapter.getFakeResourceContext().getFakeResource().eAdapters().add((Object)this.contextElementAdapter);
            this.xtextAdapter.adapt((StyledText)styledText);
        }
        if (this.configuration != null && this.configuration.getObjectToEdit() != oldObjectToEdit && (provider = this.configuration.getContextProvider()) instanceof ContextElementAdapter.IContextElementProviderWithInit && this.xtextAdapter != null) {
            ((ContextElementAdapter.IContextElementProviderWithInit)provider).initResource(this.xtextAdapter.getFakeResourceContext().getFakeResource());
        }
    }

    protected DefaultXtextDirectEditorConfiguration getConfigurationFromSelection() {
        if (this.directEditorConfiguration != null && !this.directEditorConfiguration.isEmpty()) {
            try {
                Object classInstance;
                Class<?> directEditorConfigurationClass = Class.forName(this.directEditorConfiguration);
                if (directEditorConfigurationClass != null && (classInstance = directEditorConfigurationClass.newInstance()) instanceof DefaultXtextDirectEditorConfiguration) {
                    DefaultXtextDirectEditorConfiguration xtextConfiguration = (DefaultXtextDirectEditorConfiguration)classInstance;
                    if (this.modelProperty != null && this.getContextElement() instanceof EObject && this.modelProperty.getValueType() instanceof EStructuralFeature) {
                        xtextConfiguration.preEditAction(((EObject)this.getContextElement()).eGet((EStructuralFeature)this.modelProperty.getValueType()));
                    } else {
                        xtextConfiguration.preEditAction((Object)((EObject)this.getValue()));
                    }
                    return xtextConfiguration;
                }
            }
            catch (ClassNotFoundException e) {
                Activator.log.error((Throwable)e);
            }
            catch (InstantiationException e) {
                Activator.log.error((Throwable)e);
            }
            catch (IllegalAccessException e) {
                Activator.log.error((Throwable)e);
            }
        }
        return null;
    }

    protected IParser getParser() {
        EObject parentSemanticElement = null;
        Object contextElement = this.getContextElement();
        if (contextElement != null && contextElement instanceof EObject) {
            parentSemanticElement = (EObject)contextElement;
        }
        if (this.configuration != null && parentSemanticElement != null) {
            return this.configuration.createParser(parentSemanticElement);
        }
        return null;
    }

    protected void doBinding() {
        super.doBinding();
        this.updateXtextAdapters((Control)this.styledTextStringEditor.getText());
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                UMLXtextReferenceValueEditor.this.styledTextStringEditor.setValue((Object)UMLXtextReferenceValueEditor.this.labelProvider.getText(UMLXtextReferenceValueEditor.this.getValue()));
            }
        });
        this.updateLabel();
    }

    public void dispose() {
        if (this.styledTextStringEditor != null) {
            this.styledTextStringEditor.dispose();
        }
        if (this.xtextAdapter != null) {
            this.xtextAdapter.getFakeResourceContext().getFakeResource().eAdapters().remove((Object)this.contextElementAdapter);
            this.xtextAdapter.dispose();
            this.xtextAdapter = null;
        }
    }

    public EObject getContextObject() {
        Object value = this.getValue();
        return value instanceof EObject ? (EObject)value : null;
    }

    public void setDirectEditorConfiguration(String directEditorConfiguration) {
        this.directEditorConfiguration = directEditorConfiguration;
        this.updateXtextAdapters((Control)this.styledTextStringEditor.getText());
    }
}

