/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.activity.edit.policies;

import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.commands.CommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.diagram.ui.requests.EditCommandRequestWrapper;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.MoveRequest;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.editpolicies.DefaultCreationEditPolicy;
import org.eclipse.papyrus.uml.diagram.activity.commands.ActivityEdgeReparentCommand;
import org.eclipse.uml2.uml.ActivityEdge;
import org.eclipse.uml2.uml.ActivityNode;
import org.eclipse.uml2.uml.ActivityPartition;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.InterruptibleActivityRegion;
import org.eclipse.uml2.uml.Pin;

public class ActivityCompartmentCreationEditPolicy
extends DefaultCreationEditPolicy {
    protected ICommand getReparentCommand(IGraphicalEditPart gep) {
        CompositeCommand cc = new CompositeCommand(DiagramUIMessages.AddCommand_Label);
        View container = (View)this.getHost().getModel();
        EObject context = ViewUtil.resolveSemanticElement((View)container);
        View view = (View)gep.getModel();
        EObject element = ViewUtil.resolveSemanticElement((View)view);
        TransactionalEditingDomain editingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
        if (element != null) {
            Command moveSemanticCmd;
            MoveRequest req = new MoveRequest(editingDomain, context, element);
            EObject currentParentSemantic = ((IGraphicalEditPart)gep.getParent()).resolveSemanticElement();
            if (currentParentSemantic instanceof ActivityPartition) {
                req.setParameter("OUT_FROM_PARTITION", (Object)currentParentSemantic);
            }
            if (currentParentSemantic instanceof InterruptibleActivityRegion) {
                req.setParameter("OUT_FROM_REGION", (Object)currentParentSemantic);
            }
            if ((moveSemanticCmd = this.getHost().getCommand((Request)new EditCommandRequestWrapper((IEditCommandRequest)req))) == null) {
                return UnexecutableCommand.INSTANCE;
            }
            cc.compose((IUndoableOperation)new CommandProxy(moveSemanticCmd));
            if (context != null && this.shouldReparent(element, context) && element instanceof ActivityNode) {
                ActivityNode activityNode = (ActivityNode)element;
                for (ActivityEdge edge : activityNode.getOutgoings()) {
                    cc.compose((IUndoableOperation)new ActivityEdgeReparentCommand(editingDomain, edge));
                }
                for (ActivityEdge edge : activityNode.getIncomings()) {
                    cc.compose((IUndoableOperation)new ActivityEdgeReparentCommand(editingDomain, edge));
                }
                for (Element ownedElement : activityNode.getOwnedElements()) {
                    if (!(ownedElement instanceof Pin)) continue;
                    for (ActivityEdge edge : ((Pin)ownedElement).getOutgoings()) {
                        cc.compose((IUndoableOperation)new ActivityEdgeReparentCommand(editingDomain, edge));
                    }
                    for (ActivityEdge edge : ((Pin)ownedElement).getIncomings()) {
                        cc.compose((IUndoableOperation)new ActivityEdgeReparentCommand(editingDomain, edge));
                    }
                }
            }
        }
        cc.compose((IUndoableOperation)this.getReparentViewCommand(gep));
        return cc;
    }
}

