/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.codegen.java.types;

import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.codegen.generator.CodeGenerator;
import org.eclipse.ocl.examples.codegen.generator.TypeDescriptor;
import org.eclipse.ocl.examples.codegen.java.JavaStream;
import org.eclipse.ocl.examples.codegen.java.types.AbstractCollectionDescriptor;
import org.eclipse.ocl.examples.codegen.java.types.EcoreDescriptor;
import org.eclipse.ocl.examples.codegen.java.types.UnboxedDescriptor;
import org.eclipse.ocl.pivot.StandardLibrary;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.ids.CollectionTypeId;
import org.eclipse.ocl.pivot.utilities.ClassUtil;

public class UnboxedElementsDescriptor
extends AbstractCollectionDescriptor
implements UnboxedDescriptor {
    protected final @NonNull StandardLibrary standardLibrary;
    protected final @NonNull Type type;

    public UnboxedElementsDescriptor(@NonNull CollectionTypeId collectionTypeId, @NonNull StandardLibrary standardLibrary, @NonNull Type type) {
        super(collectionTypeId);
        this.standardLibrary = standardLibrary;
        this.type = type;
    }

    @Override
    public void append(@NonNull JavaStream javaStream, @Nullable Boolean isRequired) {
        javaStream.appendClassReference(List.class, true, Object.class);
    }

    @Override
    public @NonNull EcoreDescriptor getEcoreDescriptor(@NonNull CodeGenerator codeGenerator, @Nullable Class<?> instanceClass) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void appendElement(@NonNull JavaStream javaStream, boolean reClass) {
        javaStream.appendClassReference(this.getJavaClass());
    }

    @Override
    public @NonNull String getClassName() {
        return (String)ClassUtil.nonNullModel((Object)this.type.getName());
    }

    @Override
    public @NonNull Class<?> getJavaClass() {
        return Object.class;
    }

    @Override
    public @NonNull UnboxedDescriptor getUnboxedDescriptor(@NonNull CodeGenerator codeGenerator) {
        return this;
    }

    @Override
    public @Nullable Class<?> hasJavaClass() {
        return null;
    }

    @Override
    public final boolean isAssignableFrom(@NonNull TypeDescriptor typeDescriptor) {
        if (!(typeDescriptor instanceof UnboxedElementsDescriptor)) {
            return false;
        }
        Type thatType = ((UnboxedElementsDescriptor)typeDescriptor).type;
        return thatType.conformsTo(this.standardLibrary, this.type);
    }

    @Override
    public @NonNull String toString() {
        return this.elementId + " => List<Object/*" + this.type.getName() + "*/>";
    }
}

