/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.libra.framework.ui.internal.editor;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.debug.ui.StringVariableSelectionDialog;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;
import org.eclipse.jdt.launching.environments.IExecutionEnvironmentsManager;
import org.eclipse.libra.framework.core.FrameworkInstanceConfiguration;
import org.eclipse.libra.framework.core.IOSGIFrameworkInstance;
import org.eclipse.libra.framework.core.IOSGIFrameworkWorkingCopy;
import org.eclipse.libra.framework.core.TargetDefinitionUtil;
import org.eclipse.libra.framework.core.Trace;
import org.eclipse.libra.framework.ui.internal.editor.TargetChangedCommand;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.ITargetPlatformService;
import org.eclipse.pde.internal.core.util.VMUtil;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.SWTFactory;
import org.eclipse.pde.internal.ui.shared.target.ArgumentsFromContainerSelectionDialog;
import org.eclipse.pde.internal.ui.shared.target.ITargetChangedListener;
import org.eclipse.pde.internal.ui.shared.target.TargetContentsGroup;
import org.eclipse.pde.internal.ui.shared.target.TargetLocationsGroup;
import org.eclipse.pde.internal.ui.util.LocaleUtil;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.wst.server.ui.editor.ServerEditorPart;

public class TargetDefinitionEditorPart
extends ServerEditorPart {
    private static final String EMPTY_STRING = "";
    protected ITargetDefinition targetDefinition;
    protected IOSGIFrameworkWorkingCopy server2;
    protected FrameworkInstanceConfiguration configuration;
    private Text fNameText;
    private TabItem fLocationTab;
    private TargetLocationsGroup fLocationTree;
    private TargetContentsGroup fContentTree;
    protected PropertyChangeListener listener;
    private Button fDefaultJREButton;
    private Button fNamedJREButton;
    private Combo fNamedJREsCombo;
    private Button fExecEnvButton;
    private TreeSet fExecEnvChoices;
    private Combo fExecEnvsCombo;
    private TreeSet fOSChoices;
    private Combo fOSCombo;
    private Combo fWSCombo;
    private TreeSet fArchChoices;
    private Combo fArchCombo;
    private Combo fNLCombo;
    private Text fProgramArgs;
    private Text fVMArgs;
    private TreeSet fWSChoices;
    private TreeSet fNLChoices;

    public ITargetDefinition getTargetDefinition() {
        if (this.configuration != null && this.targetDefinition == null) {
            this.targetDefinition = this.configuration.getTargetDefinition();
        }
        return this.targetDefinition;
    }

    protected void addChangeListener() {
        this.listener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if ("ADD_BUNDLE".equals(event.getPropertyName())) {
                    TargetDefinitionEditorPart.this.initialize();
                } else if ("REMOVE_BUNDLE".equals(event.getPropertyName())) {
                    TargetDefinitionEditorPart.this.initialize();
                }
            }
        };
        this.configuration.addPropertyChangeListener(this.listener);
    }

    public IStatus resolveBundles(ITargetDefinition definition) {
        if (!definition.isResolved()) {
            definition.resolve((IProgressMonitor)new NullProgressMonitor());
        }
        this.fContentTree.setInput(definition);
        this.fLocationTree.setInput(definition);
        if (definition.isResolved() && definition.getStatus().getSeverity() == 4) {
            this.fLocationTab.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK"));
        } else {
            this.fLocationTab.setImage(null);
        }
        return Status.OK_STATUS;
    }

    protected void targetChanged(ITargetDefinition definition) {
        if (this.fContentTree == null || this.fLocationTree == null) {
            return;
        }
        if (definition != null) {
            String name = definition.getName();
            if (name == null) {
                name = EMPTY_STRING;
            }
            if (name.trim().length() > 0) {
                this.fNameText.setText(name);
            }
            this.fLocationTree.setInput(definition);
            this.fContentTree.setInput(definition);
            this.updateArgsEnv(definition);
        }
    }

    public void targetDefinitionContentsChanged(final ITargetDefinition definition, Object source, boolean resolve, boolean forceResolve) {
        boolean setCancelled = false;
        this.makeDirty(definition);
        this.targetDefinition = definition;
        try {
            new UIJob(PDEUIMessages.TargetDefinitionContentPage_0){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    return TargetDefinitionEditorPart.this.resolveBundles(definition);
                }
            }.schedule();
        }
        catch (Exception e) {
            Trace.trace((byte)2, (String)EMPTY_STRING, (Throwable)e);
        }
        if (this.fContentTree != source) {
            if (setCancelled) {
                this.fContentTree.setCancelled();
            } else {
                this.fContentTree.setInput(definition);
            }
        }
        if (this.fLocationTree != source) {
            this.fLocationTree.setInput(definition);
        }
        if (definition.isResolved() && definition.getStatus().getSeverity() == 4) {
            this.fLocationTab.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK"));
        } else {
            this.fLocationTab.setImage(null);
        }
        this.updateArgsEnv(definition);
    }

    void makeDirty(ITargetDefinition definition) {
        this.execute((IUndoableOperation)new TargetChangedCommand(definition));
    }

    private void updateArgsEnv(ITargetDefinition definition) {
        String presetValue = definition.getOS() == null ? EMPTY_STRING : definition.getOS();
        this.fOSCombo.setText(presetValue);
        presetValue = definition.getWS() == null ? EMPTY_STRING : definition.getWS();
        this.fWSCombo.setText(presetValue);
        presetValue = definition.getArch() == null ? EMPTY_STRING : definition.getArch();
        this.fArchCombo.setText(presetValue);
        presetValue = definition.getNL() == null ? EMPTY_STRING : LocaleUtil.expandLocaleName((String)definition.getNL());
        this.fNLCombo.setText(presetValue);
        IPath jrePath = definition.getJREContainer();
        if (jrePath == null || jrePath.equals((Object)JavaRuntime.newDefaultJREContainerPath())) {
            this.fDefaultJREButton.setSelection(true);
        } else {
            String ee = JavaRuntime.getExecutionEnvironmentId((IPath)jrePath);
            if (ee != null) {
                this.fExecEnvButton.setSelection(true);
                this.fExecEnvsCombo.select(this.fExecEnvsCombo.indexOf(ee));
            } else {
                String vm = JavaRuntime.getVMInstallName((IPath)jrePath);
                if (vm != null) {
                    this.fNamedJREButton.setSelection(true);
                    this.fNamedJREsCombo.select(this.fNamedJREsCombo.indexOf(vm));
                }
            }
        }
        if (this.fExecEnvsCombo.getSelectionIndex() == -1) {
            this.fExecEnvsCombo.setText(this.fExecEnvChoices.first().toString());
        }
        if (this.fNamedJREsCombo.getSelectionIndex() == -1) {
            this.fNamedJREsCombo.setText(VMUtil.getDefaultVMInstallName());
        }
        this.updateJREWidgets();
        presetValue = definition.getProgramArguments() == null ? EMPTY_STRING : definition.getProgramArguments();
        this.fProgramArgs.setText(presetValue);
        presetValue = definition.getVMArguments() == null ? EMPTY_STRING : definition.getVMArguments();
        this.fVMArgs.setText(presetValue);
    }

    private void addTargetListeners() {
        ITargetChangedListener listener2 = new ITargetChangedListener(){

            public void contentsChanged(ITargetDefinition definition, Object source, boolean resolve, boolean forceResolve) {
                TargetDefinitionEditorPart.this.targetDefinitionContentsChanged(definition, source, resolve, forceResolve);
            }
        };
        this.fContentTree.addTargetChangedListener(listener2);
        this.fLocationTree.addTargetChangedListener(listener2);
    }

    public void createPartControl(Composite parent) {
        FormToolkit toolkit = this.getFormToolkit(parent.getDisplay());
        this.targetChanged(this.getTargetDefinition());
        Composite comp = SWTFactory.createComposite((Composite)parent, (int)1, (int)1, (int)1808, (int)0, (int)0);
        Composite nameComp = SWTFactory.createComposite((Composite)comp, (int)2, (int)1, (int)768, (int)0, (int)0);
        SWTFactory.createLabel((Composite)nameComp, (String)PDEUIMessages.TargetDefinitionContentPage_4, (int)1);
        this.fNameText = SWTFactory.createSingleText((Composite)nameComp, (int)1);
        this.fNameText.setEditable(false);
        TabFolder tabs = new TabFolder(comp, 0);
        tabs.setLayoutData((Object)new GridData(1808));
        this.fLocationTab = new TabItem(tabs, 0);
        this.fLocationTab.setText(PDEUIMessages.LocationSection_0);
        Composite pluginTabContainer = SWTFactory.createComposite((Composite)tabs, (int)1, (int)1, (int)1808);
        SWTFactory.createWrapLabel((Composite)pluginTabContainer, (String)PDEUIMessages.TargetDefinitionContentPage_LocationDescription, (int)2, (int)400);
        this.fLocationTree = TargetLocationsGroup.createInForm((Composite)pluginTabContainer, (FormToolkit)toolkit);
        this.fLocationTab.setControl((Control)pluginTabContainer);
        TabItem contentTab = new TabItem(tabs, 0);
        contentTab.setText(PDEUIMessages.TargetDefinitionContentPage_6);
        Composite contentTabContainer = SWTFactory.createComposite((Composite)tabs, (int)1, (int)1, (int)1808);
        SWTFactory.createWrapLabel((Composite)contentTabContainer, (String)PDEUIMessages.ContentSection_1, (int)2, (int)400);
        this.fContentTree = TargetContentsGroup.createInForm((Composite)contentTabContainer, (FormToolkit)toolkit);
        contentTab.setControl((Control)contentTabContainer);
        TabItem envTab = new TabItem(tabs, 0);
        envTab.setText(PDEUIMessages.TargetDefinitionEnvironmentPage_3);
        Composite envTabContainer = SWTFactory.createComposite((Composite)tabs, (int)1, (int)1, (int)1808);
        this.createTargetEnvironmentGroup(envTabContainer);
        this.createJREGroup(envTabContainer);
        envTab.setControl((Control)envTabContainer);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)envTabContainer, "org.eclipse.pde.doc.user.edit_target_wizard_environment_tab");
        TabItem argsTab = new TabItem(tabs, 0);
        argsTab.setText(PDEUIMessages.TargetDefinitionEnvironmentPage_4);
        argsTab.setControl(this.createArgumentsGroup((Composite)tabs));
        PlatformUI.getWorkbench().getHelpSystem().setHelp(argsTab.getControl(), "org.eclipse.pde.doc.user.edit_target_wizard_argument_tab");
        this.initialize();
        this.addTargetListeners();
    }

    private void createJREGroup(Composite container) {
        Group group = SWTFactory.createGroup((Composite)container, (String)PDEUIMessages.EnvironmentBlock_jreTitle, (int)2, (int)1, (int)768);
        this.initializeJREValues();
        SWTFactory.createWrapLabel((Composite)group, (String)PDEUIMessages.JRESection_description, (int)2);
        this.fDefaultJREButton = SWTFactory.createRadioButton((Composite)group, (String)PDEUIMessages.JRESection_defaultJRE, (int)2);
        this.fDefaultJREButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TargetDefinitionEditorPart.this.updateJREWidgets();
                TargetDefinitionEditorPart.this.getTargetDefinition().setJREContainer(JavaRuntime.newDefaultJREContainerPath());
                TargetDefinitionEditorPart.this.makeDirty(TargetDefinitionEditorPart.this.getTargetDefinition());
            }
        });
        this.fNamedJREButton = SWTFactory.createRadioButton((Composite)group, (String)PDEUIMessages.JRESection_JREName);
        this.fNamedJREButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TargetDefinitionEditorPart.this.updateJREWidgets();
                TargetDefinitionEditorPart.this.getTargetDefinition().setJREContainer(JavaRuntime.newJREContainerPath((IVMInstall)VMUtil.getVMInstall((String)TargetDefinitionEditorPart.this.fNamedJREsCombo.getText())));
                TargetDefinitionEditorPart.this.makeDirty(TargetDefinitionEditorPart.this.getTargetDefinition());
            }
        });
        this.fNamedJREsCombo = SWTFactory.createCombo((Composite)group, (int)2060, (int)1, (String[])VMUtil.getVMInstallNames());
        this.fNamedJREsCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TargetDefinitionEditorPart.this.getTargetDefinition().setJREContainer(JavaRuntime.newJREContainerPath((IVMInstall)VMUtil.getVMInstall((String)TargetDefinitionEditorPart.this.fNamedJREsCombo.getText())));
                TargetDefinitionEditorPart.this.makeDirty(TargetDefinitionEditorPart.this.getTargetDefinition());
            }
        });
        this.fExecEnvButton = SWTFactory.createRadioButton((Composite)group, (String)PDEUIMessages.JRESection_ExecutionEnv);
        this.fExecEnvButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TargetDefinitionEditorPart.this.updateJREWidgets();
                TargetDefinitionEditorPart.this.getTargetDefinition().setJREContainer(JavaRuntime.newJREContainerPath((IExecutionEnvironment)VMUtil.getExecutionEnvironment((String)TargetDefinitionEditorPart.this.fExecEnvsCombo.getText())));
                TargetDefinitionEditorPart.this.makeDirty(TargetDefinitionEditorPart.this.getTargetDefinition());
            }
        });
        this.fExecEnvsCombo = SWTFactory.createCombo((Composite)group, (int)2060, (int)1, (String[])this.fExecEnvChoices.toArray(new String[this.fExecEnvChoices.size()]));
        this.fExecEnvsCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TargetDefinitionEditorPart.this.getTargetDefinition().setJREContainer(JavaRuntime.newJREContainerPath((IExecutionEnvironment)VMUtil.getExecutionEnvironment((String)TargetDefinitionEditorPart.this.fExecEnvsCombo.getText())));
                TargetDefinitionEditorPart.this.makeDirty(TargetDefinitionEditorPart.this.getTargetDefinition());
            }
        });
    }

    protected void initializeJREValues() {
        this.fExecEnvChoices = new TreeSet();
        IExecutionEnvironmentsManager manager = JavaRuntime.getExecutionEnvironmentsManager();
        IExecutionEnvironment[] envs = manager.getExecutionEnvironments();
        int i = 0;
        while (i < envs.length) {
            this.fExecEnvChoices.add(envs[i].getId());
            ++i;
        }
    }

    protected void updateJREWidgets() {
        this.fNamedJREsCombo.setEnabled(this.fNamedJREButton.getSelection());
        this.fExecEnvsCombo.setEnabled(this.fExecEnvButton.getSelection());
    }

    private void createTargetEnvironmentGroup(Composite container) {
        Group group = SWTFactory.createGroup((Composite)container, (String)PDEUIMessages.EnvironmentBlock_targetEnv, (int)2, (int)1, (int)768);
        this.initializeChoices();
        SWTFactory.createWrapLabel((Composite)group, (String)PDEUIMessages.EnvironmentSection_description, (int)2);
        SWTFactory.createLabel((Composite)group, (String)PDEUIMessages.Preferences_TargetEnvironmentPage_os, (int)1);
        this.fOSCombo = SWTFactory.createCombo((Composite)group, (int)2052, (int)1, (String[])this.fOSChoices.toArray(new String[this.fOSChoices.size()]));
        this.fOSCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String val = TargetDefinitionEditorPart.this.getModelValue(TargetDefinitionEditorPart.this.fOSCombo.getText());
                if (TargetDefinitionEditorPart.this.getTargetDefinition().getOS() != null && !TargetDefinitionEditorPart.this.getTargetDefinition().getOS().equals(val)) {
                    TargetDefinitionEditorPart.this.makeDirty(TargetDefinitionEditorPart.this.getTargetDefinition());
                }
                TargetDefinitionEditorPart.this.getTargetDefinition().setOS(val);
            }
        });
        SWTFactory.createLabel((Composite)group, (String)PDEUIMessages.Preferences_TargetEnvironmentPage_ws, (int)1);
        this.fWSCombo = SWTFactory.createCombo((Composite)group, (int)2052, (int)1, (String[])this.fWSChoices.toArray(new String[this.fWSChoices.size()]));
        this.fWSCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String val = TargetDefinitionEditorPart.this.getModelValue(TargetDefinitionEditorPart.this.fWSCombo.getText());
                if (TargetDefinitionEditorPart.this.getTargetDefinition().getWS() != null && !TargetDefinitionEditorPart.this.getTargetDefinition().getWS().equals(val)) {
                    TargetDefinitionEditorPart.this.makeDirty(TargetDefinitionEditorPart.this.getTargetDefinition());
                }
                TargetDefinitionEditorPart.this.getTargetDefinition().setWS(val);
            }
        });
        SWTFactory.createLabel((Composite)group, (String)PDEUIMessages.Preferences_TargetEnvironmentPage_arch, (int)1);
        this.fArchCombo = SWTFactory.createCombo((Composite)group, (int)2052, (int)1, (String[])this.fArchChoices.toArray(new String[this.fArchChoices.size()]));
        this.fArchCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String val = TargetDefinitionEditorPart.this.getModelValue(TargetDefinitionEditorPart.this.fArchCombo.getText());
                if (TargetDefinitionEditorPart.this.getTargetDefinition().getArch() != null && !TargetDefinitionEditorPart.this.getTargetDefinition().getArch().equals(val)) {
                    TargetDefinitionEditorPart.this.makeDirty(TargetDefinitionEditorPart.this.getTargetDefinition());
                }
                TargetDefinitionEditorPart.this.getTargetDefinition().setArch(val);
            }
        });
        SWTFactory.createLabel((Composite)group, (String)PDEUIMessages.Preferences_TargetEnvironmentPage_nl, (int)1);
        this.fNLCombo = SWTFactory.createCombo((Composite)group, (int)2052, (int)1, (String[])this.fNLChoices.toArray(new String[this.fNLChoices.size()]));
        this.fNLCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String value = TargetDefinitionEditorPart.this.fNLCombo.getText();
                int index = value.indexOf("-");
                if (index > 0) {
                    value = value.substring(0, index);
                }
                String val = TargetDefinitionEditorPart.this.getModelValue(value);
                if (TargetDefinitionEditorPart.this.getTargetDefinition().getNL() != null && !TargetDefinitionEditorPart.this.getTargetDefinition().getNL().equals(val)) {
                    TargetDefinitionEditorPart.this.makeDirty(TargetDefinitionEditorPart.this.getTargetDefinition());
                }
                TargetDefinitionEditorPart.this.getTargetDefinition().setNL(val);
            }
        });
    }

    private String getModelValue(String value) {
        if (value != null && (value = value.trim()).length() == 0) {
            return null;
        }
        return value;
    }

    private void addExtraChoices(Set set, String preference) {
        StringTokenizer tokenizer = new StringTokenizer(preference, ",");
        while (tokenizer.hasMoreTokens()) {
            set.add(tokenizer.nextToken().trim());
        }
    }

    private void initializeChoices() {
        IEclipsePreferences node = new InstanceScope().getNode("org.eclipse.pde.core");
        this.fOSChoices = new TreeSet();
        String[] os = Platform.knownOSValues();
        int i = 0;
        while (i < os.length) {
            this.fOSChoices.add(os[i]);
            ++i;
        }
        String pref = node.get("org.eclipse.pde.os.extra", EMPTY_STRING);
        if (!EMPTY_STRING.equals(pref)) {
            this.addExtraChoices(this.fOSChoices, pref);
        }
        this.fWSChoices = new TreeSet();
        String[] ws = Platform.knownWSValues();
        int i2 = 0;
        while (i2 < ws.length) {
            this.fWSChoices.add(ws[i2]);
            ++i2;
        }
        pref = node.get("org.eclipse.pde.ws.extra", EMPTY_STRING);
        if (!EMPTY_STRING.equals(pref)) {
            this.addExtraChoices(this.fWSChoices, pref);
        }
        this.fArchChoices = new TreeSet();
        String[] arch = Platform.knownOSArchValues();
        int i3 = 0;
        while (i3 < arch.length) {
            this.fArchChoices.add(arch[i3]);
            ++i3;
        }
        pref = node.get("org.eclipse.pde.arch.extra", EMPTY_STRING);
        if (!EMPTY_STRING.equals(pref)) {
            this.addExtraChoices(this.fArchChoices, pref);
        }
        this.fNLChoices = new TreeSet();
        String[] nl = LocaleUtil.getLocales();
        int i4 = 0;
        while (i4 < nl.length) {
            this.fNLChoices.add(nl[i4]);
            ++i4;
        }
        pref = node.get("org.eclipse.pde.nl.extra", EMPTY_STRING);
        if (!EMPTY_STRING.equals(pref)) {
            this.addExtraChoices(this.fNLChoices, pref);
        }
    }

    private Control createArgumentsGroup(Composite parent) {
        Composite container = SWTFactory.createComposite((Composite)parent, (int)1, (int)1, (int)1808);
        SWTFactory.createWrapLabel((Composite)container, (String)PDEUIMessages.JavaArgumentsTab_description, (int)1);
        Group programGroup = SWTFactory.createGroup((Composite)container, (String)PDEUIMessages.JavaArgumentsTab_progamArgsGroup, (int)1, (int)1, (int)768);
        this.fProgramArgs = SWTFactory.createText((Composite)programGroup, (int)2626, (int)1, (int)200, (int)60, (int)1808);
        this.fProgramArgs.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String val = TargetDefinitionEditorPart.this.fProgramArgs.getText().trim();
                if (TargetDefinitionEditorPart.this.getTargetDefinition().getProgramArguments() != null && !TargetDefinitionEditorPart.this.getTargetDefinition().getProgramArguments().equals(val)) {
                    TargetDefinitionEditorPart.this.makeDirty(TargetDefinitionEditorPart.this.getTargetDefinition());
                }
                TargetDefinitionEditorPart.this.getTargetDefinition().setProgramArguments(val);
            }
        });
        Composite programButtons = SWTFactory.createComposite((Composite)programGroup, (int)1, (int)1, (int)128, (int)0, (int)0);
        Button programVars = SWTFactory.createPushButton((Composite)programButtons, (String)PDEUIMessages.JavaArgumentsTab_programVariables, null, (int)128);
        programVars.addSelectionListener(this.getVariablesListener(this.fProgramArgs));
        Group vmGroup = new Group(container, 0);
        vmGroup.setLayout((Layout)new GridLayout(1, false));
        vmGroup.setLayoutData((Object)new GridData(768));
        vmGroup.setText(PDEUIMessages.JavaArgumentsTab_vmArgsGroup);
        this.fVMArgs = SWTFactory.createText((Composite)vmGroup, (int)2626, (int)1, (int)200, (int)60, (int)1808);
        this.fVMArgs.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String val = TargetDefinitionEditorPart.this.fVMArgs.getText().trim();
                if (TargetDefinitionEditorPart.this.getTargetDefinition().getVMArguments() != null && !TargetDefinitionEditorPart.this.getTargetDefinition().getVMArguments().equals(val)) {
                    TargetDefinitionEditorPart.this.makeDirty(TargetDefinitionEditorPart.this.getTargetDefinition());
                }
                TargetDefinitionEditorPart.this.getTargetDefinition().setVMArguments(val);
            }
        });
        Composite buttons = SWTFactory.createComposite((Composite)vmGroup, (int)2, (int)1, (int)128, (int)0, (int)0);
        Button vmArgs = SWTFactory.createPushButton((Composite)buttons, (String)PDEUIMessages.JavaArgumentsTab_addVMArgs, null, (int)128);
        vmArgs.addSelectionListener(this.getVMArgsListener(this.fVMArgs));
        Button vmVars = SWTFactory.createPushButton((Composite)buttons, (String)PDEUIMessages.JavaArgumentsTab_vmVariables, null, (int)128);
        vmVars.addSelectionListener(this.getVariablesListener(this.fVMArgs));
        return container;
    }

    private SelectionListener getVMArgsListener(Text textControl) {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String[] args;
                ArgumentsFromContainerSelectionDialog dialog = new ArgumentsFromContainerSelectionDialog(TargetDefinitionEditorPart.this.getEditorSite().getShell(), TargetDefinitionEditorPart.this.getTargetDefinition());
                if (dialog.open() == 0 && (args = dialog.getSelectedArguments()) != null && args.length > 0) {
                    StringBuffer resultBuffer = new StringBuffer();
                    int index = 0;
                    while (index < args.length) {
                        resultBuffer.append(String.valueOf(args[index]) + " ");
                        ++index;
                    }
                    TargetDefinitionEditorPart.this.fVMArgs.insert(resultBuffer.toString());
                }
            }
        };
    }

    private SelectionListener getVariablesListener(final Text textControl) {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StringVariableSelectionDialog dialog = new StringVariableSelectionDialog(TargetDefinitionEditorPart.this.getEditorSite().getShell());
                dialog.open();
                String variable = dialog.getVariableExpression();
                if (variable != null) {
                    textControl.insert(variable);
                }
            }
        };
    }

    public void dispose() {
        super.dispose();
        if (this.configuration != null) {
            this.configuration.removePropertyChangeListener(this.listener);
        }
    }

    public void init(IEditorSite site, IEditorInput input) {
        super.init(site, input);
        IOSGIFrameworkInstance ts = (IOSGIFrameworkInstance)this.server.loadAdapter(IOSGIFrameworkInstance.class, null);
        try {
            this.configuration = ts.getFrameworkInstanceConfiguration();
            if (this.configuration != null && this.configuration.getTargetDefinition() != null) {
                this.getTargetDefinition().resolve((IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (CoreException e) {
            Trace.trace((byte)2, (String)"cannot access configuration", (Throwable)e);
        }
        if (this.server != null) {
            this.server2 = (IOSGIFrameworkWorkingCopy)this.server.loadAdapter(IOSGIFrameworkWorkingCopy.class, null);
        }
        this.addChangeListener();
        this.initialize();
    }

    protected void initialize() {
        ITargetDefinition definition = this.getTargetDefinition();
        if (definition != null) {
            definition.resolve((IProgressMonitor)new NullProgressMonitor());
        }
        this.targetChanged(definition);
    }

    public void setFocus() {
    }

    public void doSave(IProgressMonitor monitor) {
        super.doSave(monitor);
        IOSGIFrameworkInstance runtimeInstance = (IOSGIFrameworkInstance)this.server.loadAdapter(IOSGIFrameworkInstance.class, null);
        try {
            runtimeInstance.getFrameworkInstanceConfiguration().setTargetDefinition(this.getTargetDefinition());
            ITargetPlatformService service = TargetDefinitionUtil.getTargetPlatformService();
            service.saveTargetDefinition(this.getTargetDefinition());
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }
}

