/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.libra.framework.core;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.libra.framework.core.IOSGIFramework;
import org.eclipse.libra.framework.core.IOSGIFrameworkInstance;
import org.eclipse.libra.framework.core.Messages;
import org.eclipse.libra.framework.core.PingThread;
import org.eclipse.libra.framework.core.Trace;
import org.eclipse.libra.framework.editor.core.IOSGiFrameworkAdmin;
import org.eclipse.libra.framework.editor.core.IOSGiFrameworkConsole;
import org.eclipse.libra.framework.editor.core.model.IBundle;
import org.eclipse.libra.framework.editor.integration.admin.osgijmx.LaunchOSGiJMXFrameworkAdmin;
import org.eclipse.libra.framework.editor.integration.console.basic.LaunchBasicOSGiFrameworkConsole;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.internal.IModulePublishHelper;
import org.eclipse.wst.server.core.model.IModuleFile;
import org.eclipse.wst.server.core.model.IModuleResource;
import org.eclipse.wst.server.core.model.IModuleResourceDelta;
import org.eclipse.wst.server.core.model.ServerBehaviourDelegate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OSGIFrameworkInstanceBehaviorDelegate
extends ServerBehaviourDelegate
implements IModulePublishHelper,
IOSGiFrameworkAdmin,
IOSGiFrameworkConsole {
    private static final String ATTR_STOP = "stop-server";
    protected transient PingThread ping = null;
    protected transient IDebugEventSetListener processListener;
    private IOSGiFrameworkAdmin admin = null;
    private IOSGiFrameworkConsole console = null;

    public abstract String[] getFrameworkProgramArguments(boolean var1);

    public abstract String[] getExcludedFrameworkProgramArguments(boolean var1);

    public abstract String[] getFrameworkVMArguments();

    public abstract String getFrameworkClass();

    protected static int getNextToken(String s, int start) {
        int i = start;
        int length = s.length();
        int lookFor = 32;
        while (i < length) {
            int c = s.charAt(i);
            if (lookFor == c) {
                if (lookFor == 34) {
                    return i + 1;
                }
                return i;
            }
            if (c == 34) {
                lookFor = 34;
            }
            ++i;
        }
        return -1;
    }

    public static String mergeArguments(String originalArg, String[] vmArgs, String[] excludeArgs, boolean keepActionLast) {
        if (vmArgs == null) {
            return originalArg;
        }
        if (originalArg == null) {
            originalArg = "";
        }
        originalArg = OSGIFrameworkInstanceBehaviorDelegate.concatArgs(originalArg, vmArgs, keepActionLast);
        originalArg = OSGIFrameworkInstanceBehaviorDelegate.excludeArgs(originalArg, excludeArgs);
        return originalArg;
    }

    private static String concatArgs(String initialArgs, String[] newArgs, boolean keepLast) {
        if (newArgs == null || newArgs.length <= 0) {
            return initialArgs;
        }
        StringBuffer args = new StringBuffer();
        List<String> initArgsList = Arrays.asList(DebugPlugin.parseArguments((String)initialArgs));
        int i = 0;
        if (initialArgs != null && initialArgs.length() > 0) {
            int last = keepLast ? initArgsList.size() - 1 : initArgsList.size();
            i = 0;
            while (i < last) {
                if (i != 0) {
                    args.append(' ');
                }
                args.append(initArgsList.get(i));
                ++i;
            }
        }
        String[] stringArray = newArgs;
        int n = newArgs.length;
        int n2 = 0;
        while (n2 < n) {
            String anArg = stringArray[n2];
            if (!initArgsList.contains(anArg)) {
                if (i++ != 0) {
                    args.append(' ');
                }
                args.append(anArg);
            }
            ++n2;
        }
        if (keepLast && initArgsList.size() > 0) {
            args.append(' ');
            args.append(initArgsList.get(initArgsList.size() - 1));
        }
        return args.toString();
    }

    private static String excludeArgs(String initialArgs, String[] excludeArgs) {
        if (excludeArgs == null || excludeArgs.length <= 0) {
            return initialArgs;
        }
        StringBuffer args = new StringBuffer();
        List<String> excludeArgsList = Arrays.asList(excludeArgs);
        if (initialArgs != null && initialArgs.length() > 0) {
            String[] initArgsArray = DebugPlugin.parseArguments((String)initialArgs);
            int i = 0;
            String[] stringArray = initArgsArray;
            int n = initArgsArray.length;
            int n2 = 0;
            while (n2 < n) {
                String anArg = stringArray[n2];
                if (!excludeArgsList.contains(anArg)) {
                    if (i++ != 0) {
                        args.append(' ');
                    }
                    args.append(anArg);
                }
                ++n2;
            }
        }
        return args.toString();
    }

    public static void replaceJREContainer(List cp, IRuntimeClasspathEntry entry) {
        int size = cp.size();
        int i = 0;
        while (i < size) {
            IRuntimeClasspathEntry entry2 = (IRuntimeClasspathEntry)cp.get(i);
            if (entry2.getPath().uptoSegment(2).isPrefixOf(entry.getPath())) {
                cp.set(i, entry);
                return;
            }
            ++i;
        }
        cp.add(0, entry);
    }

    public static void mergeClasspath(List cp, IRuntimeClasspathEntry entry) {
        for (IRuntimeClasspathEntry entry2 : cp) {
            if (!entry2.getPath().equals((Object)entry.getPath())) continue;
            return;
        }
        cp.add(entry);
    }

    public void setServerStarted() {
        this.setServerState(2);
    }

    public void stopImpl() {
        if (this.ping != null) {
            this.ping.stop();
            this.ping = null;
        }
        if (this.processListener != null) {
            DebugPlugin.getDefault().removeDebugEventListener(this.processListener);
            this.processListener = null;
        }
        this.admin = null;
        this.console = null;
        this.setServerState(4);
    }

    public void stop(boolean force) {
        if (force) {
            this.terminate();
            return;
        }
        int state = this.getServer().getServerState();
        if (state == 4 || state == 3) {
            return;
        }
        if (state == 1) {
            this.terminate();
            return;
        }
        try {
            if (Trace.isTraceEnabled()) {
                Trace.trace((byte)4, "Stopping OSGi Framework");
            }
            if (state != 4) {
                this.setServerState(3);
            }
            this.terminate();
        }
        catch (Exception e) {
            Trace.trace((byte)2, "Error stopping OSGi Framework", e);
        }
    }

    protected void terminate() {
        if (this.getServer().getServerState() == 4) {
            return;
        }
        try {
            ILaunch launch;
            this.setServerState(3);
            if (Trace.isTraceEnabled()) {
                Trace.trace((byte)4, "Killing the OSGi Framework process");
            }
            if ((launch = this.getServer().getLaunch()) != null) {
                launch.terminate();
                this.stopImpl();
            }
        }
        catch (Exception e) {
            Trace.trace((byte)2, "Error killing the process", e);
        }
    }

    public IPath getTempDirectory() {
        return super.getTempDirectory(false);
    }

    public IPath getBaseDirectory() {
        Path instanceDir;
        IPath confDir = this.getTempDirectory(true);
        String instancePathStr = this.getFrameworkInstance().getInstanceDirectory();
        if (instancePathStr != null && (instanceDir = new Path(this.getFrameworkInstance().getInstanceDirectory())) != null) {
            confDir = instanceDir;
        }
        return confDir;
    }

    public void initialize(IProgressMonitor monitor) {
    }

    public IOSGIFramework getFramework() {
        if (this.getServer().getRuntime() == null) {
            return null;
        }
        return (IOSGIFramework)this.getServer().getRuntime().loadAdapter(IOSGIFramework.class, null);
    }

    public IOSGIFrameworkInstance getFrameworkInstance() {
        return (IOSGIFrameworkInstance)this.getServer().loadAdapter(IOSGIFrameworkInstance.class, null);
    }

    public void addProcessListener(final IProcess newProcess) {
        if (this.processListener != null || newProcess == null) {
            return;
        }
        this.processListener = new IDebugEventSetListener(){

            public void handleDebugEvents(DebugEvent[] events) {
                if (events != null) {
                    int size = events.length;
                    int i = 0;
                    while (i < size) {
                        if (newProcess != null && newProcess.equals(events[i].getSource()) && events[i].getKind() == 8) {
                            OSGIFrameworkInstanceBehaviorDelegate.this.stopImpl();
                        }
                        ++i;
                    }
                }
            }
        };
        DebugPlugin.getDefault().addDebugEventListener(this.processListener);
    }

    public void setupLaunch(ILaunch launch, String launchMode, IProgressMonitor monitor) throws CoreException {
        if ("true".equals(launch.getLaunchConfiguration().getAttribute(ATTR_STOP, "false"))) {
            return;
        }
        if (this.getFramework() == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.libra.framework.core", "Can't launch for OSGi Framework"));
        }
        IStatus status = this.getFramework().validate();
        if (status != null && status.getSeverity() == 4) {
            throw new CoreException(status);
        }
        this.setServerRestartState(false);
        this.setServerState(1);
        this.setMode(launchMode);
        try {
            String url = "http://" + this.getServer().getHost();
            this.ping = new PingThread(launch, this.getServer(), url, -1, this);
        }
        catch (Exception exception) {
            Trace.trace((byte)2, "Can't ping for OSGi Framework startup.");
        }
    }

    public String toString() {
        return "OSGiFrameworkInstance";
    }

    public void setupLaunchConfiguration(ILaunchConfigurationWorkingCopy workingCopy, IProgressMonitor monitor) throws CoreException {
        String existingProgArgs = workingCopy.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, null);
        workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, OSGIFrameworkInstanceBehaviorDelegate.mergeArguments(existingProgArgs, this.getFrameworkProgramArguments(true), this.getExcludedFrameworkProgramArguments(true), true));
        String existingVMArgs = workingCopy.getAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, null);
        if (existingVMArgs != null) {
            DebugPlugin.parseArguments((String)existingVMArgs);
        }
        String[] configVMArgs = this.getFrameworkVMArguments();
        workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, OSGIFrameworkInstanceBehaviorDelegate.mergeArguments(existingVMArgs, configVMArgs, null, false));
        IOSGIFramework runtime = this.getFramework();
        IVMInstall vmInstall = runtime.getVMInstall();
        if (vmInstall != null) {
            workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_JRE_CONTAINER_PATH, JavaRuntime.newJREContainerPath((IVMInstall)vmInstall).toPortableString());
        }
        IRuntimeClasspathEntry[] originalClasspath = JavaRuntime.computeUnresolvedRuntimeClasspath((ILaunchConfiguration)workingCopy);
        int size = originalClasspath.length;
        ArrayList<IRuntimeClasspathEntry> oldCp = new ArrayList<IRuntimeClasspathEntry>(originalClasspath.length + 2);
        int i = 0;
        while (i < size) {
            oldCp.add(originalClasspath[i]);
            ++i;
        }
        List cp2 = runtime.getFrameworkClasspath(null);
        for (IRuntimeClasspathEntry entry : cp2) {
            OSGIFrameworkInstanceBehaviorDelegate.mergeClasspath(oldCp, entry);
        }
        if (vmInstall != null) {
            IPath toolsPath;
            try {
                String typeId = vmInstall.getVMInstallType().getId();
                OSGIFrameworkInstanceBehaviorDelegate.replaceJREContainer(oldCp, JavaRuntime.newRuntimeContainerClasspathEntry((IPath)new Path(JavaRuntime.JRE_CONTAINER).append(typeId).append(vmInstall.getName()), (int)2));
            }
            catch (Exception exception) {}
            Path jrePath = new Path(vmInstall.getInstallLocation().getAbsolutePath());
            if (jrePath != null && (toolsPath = jrePath.append("lib").append("tools.jar")).toFile().exists()) {
                IRuntimeClasspathEntry toolsJar = JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)toolsPath);
                int toolsIndex = 0;
                while (toolsIndex < oldCp.size()) {
                    IRuntimeClasspathEntry entry = (IRuntimeClasspathEntry)oldCp.get(toolsIndex);
                    if (entry.getType() == 2 && entry.getPath().lastSegment().equals("tools.jar")) break;
                    ++toolsIndex;
                }
                if (toolsIndex < oldCp.size()) {
                    oldCp.set(toolsIndex, toolsJar);
                } else {
                    OSGIFrameworkInstanceBehaviorDelegate.mergeClasspath(oldCp, toolsJar);
                }
            }
        }
        Iterator iterator = oldCp.iterator();
        ArrayList<String> list = new ArrayList<String>();
        while (iterator.hasNext()) {
            IRuntimeClasspathEntry entry = (IRuntimeClasspathEntry)iterator.next();
            try {
                list.add(entry.getMemento());
            }
            catch (Exception e) {
                Trace.trace((byte)2, "Could not resolve classpath entry: " + entry, e);
            }
        }
        workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH, list);
        workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_CLASSPATH, false);
    }

    protected IModuleResource[] getResources(IModule[] module) {
        return super.getResources(module);
    }

    protected IModuleResourceDelta[] getPublishedResourceDelta(IModule[] module) {
        return super.getPublishedResourceDelta(module);
    }

    public void handleResourceChange() {
        if (this.getServer().getServerRestartState()) {
            return;
        }
        for (IModule[] module : this.getAllModules()) {
            IModuleResourceDelta[] delta = this.getPublishedResourceDelta(module);
            if (delta == null || delta.length == 0 || !this.containsNonResourceChange(delta)) continue;
            this.setServerRestartState(true);
            return;
        }
    }

    protected boolean containsNonResourceChange(IModuleResourceDelta[] delta) {
        int size = delta.length;
        int i = 0;
        while (i < size) {
            IModuleResourceDelta d = delta[i];
            if (d.getModuleRelativePath().segmentCount() == 0) {
                if ("WEB-INF".equals(d.getModuleResource().getName())) {
                    return this.containsNonResourceChange(d.getAffectedChildren());
                }
            } else {
                if (d.getModuleResource() instanceof IModuleFile) {
                    return true;
                }
                boolean b = this.containsNonAddChange(d.getAffectedChildren());
                if (b) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    protected boolean containsNonAddChange(IModuleResourceDelta[] delta) {
        if (delta == null) {
            return false;
        }
        int size = delta.length;
        int i = 0;
        while (i < size) {
            IModuleResourceDelta d = delta[i];
            if (d.getModuleResource() instanceof IModuleFile && d.getKind() != 1) {
                return true;
            }
            boolean b = this.containsNonAddChange(d.getAffectedChildren());
            if (b) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public IStatus cleanFrameworkInstanceWorkDir(IProgressMonitor monitor) throws CoreException {
        return Status.OK_STATUS;
    }

    public IPath getPublishDirectory(IModule[] module) {
        return this.getServerDeployDirectory();
    }

    public IPath getServerDeployDirectory() {
        return new Path(this.getFrameworkInstance().getInstanceDirectory());
    }

    public IPath getModuleDeployDirectory(IModule module) {
        return this.getServerDeployDirectory().append(module.getName());
    }

    public void setModulePublishState2(IModule[] module, int state) {
        this.setModulePublishState(module, state);
    }

    public Properties loadModulePublishLocations() {
        Properties p;
        block11: {
            p = new Properties();
            IPath path = this.getTempDirectory().append("publish.txt");
            FileInputStream fin = null;
            try {
                try {
                    fin = new FileInputStream(path.toFile());
                    p.load(fin);
                }
                catch (Exception exception) {
                    try {
                        fin.close();
                    }
                    catch (Exception exception2) {}
                    break block11;
                }
            }
            catch (Throwable throwable) {
                try {
                    fin.close();
                }
                catch (Exception exception) {}
                throw throwable;
            }
            try {
                fin.close();
            }
            catch (Exception exception) {}
        }
        return p;
    }

    public void saveModulePublishLocations(Properties p) {
        block11: {
            IPath path = this.getTempDirectory().append("publish.txt");
            FileOutputStream fout = null;
            try {
                try {
                    fout = new FileOutputStream(path.toFile());
                    p.store(fout, "OSGi Framework publish data");
                }
                catch (Exception exception) {
                    try {
                        fout.close();
                    }
                    catch (Exception exception2) {}
                    break block11;
                }
            }
            catch (Throwable throwable) {
                try {
                    fout.close();
                }
                catch (Exception exception) {}
                throw throwable;
            }
            try {
                fout.close();
            }
            catch (Exception exception) {}
        }
    }

    public Map<Long, IBundle> getBundles(IProgressMonitor monitor) throws CoreException {
        return this.getAdmin().getBundles(monitor);
    }

    public void startBundle(long bundleId) throws CoreException {
        this.getAdmin().startBundle(bundleId);
    }

    public void stopBundle(long bundleId) throws CoreException {
        this.getAdmin().stopBundle(bundleId);
    }

    public void refreshBundle(long bundleId) throws CoreException {
        this.getAdmin().refreshBundle(bundleId);
    }

    public void updateBundle(long bundleId) throws CoreException {
        this.getAdmin().updateBundle(bundleId);
    }

    public String executeCommand(String command) throws CoreException {
        return this.getConsole().executeCommand(command);
    }

    private IOSGiFrameworkAdmin getAdmin() throws CoreException {
        if (this.admin == null) {
            this.admin = new LaunchOSGiJMXFrameworkAdmin(this.getLaunch());
        }
        return this.admin;
    }

    private IOSGiFrameworkConsole getConsole() throws CoreException {
        if (this.console == null) {
            this.console = new LaunchBasicOSGiFrameworkConsole(this.getLaunch());
        }
        return this.console;
    }

    private ILaunch getLaunch() throws CoreException {
        IServer server = this.getServer();
        if (server == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.libra.framework.core", Messages.OSGIFrameworkInstanceBehaviorDelegate_ServerNotInitialized));
        }
        ILaunch launch = server.getLaunch();
        if (launch == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.libra.framework.core", Messages.OSGIFrameworkInstanceBehaviorDelegate_ServerNotStarted));
        }
        return launch;
    }
}

