/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.transformations.internal.wizard;

import java.util.Collection;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jwt.transformations.api.Transformation;
import org.eclipse.jwt.transformations.api.io.ContentChangeListener;
import org.eclipse.jwt.transformations.api.io.IODefinition;
import org.eclipse.jwt.transformations.internal.TransformationsMessages;
import org.eclipse.jwt.transformations.internal.init.TransformationRegistry;
import org.eclipse.jwt.transformations.widgets.internal.IOGroup;
import org.eclipse.jwt.transformations.widgets.internal.TransformationGroup;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class TransformationWizardPage
extends WizardPage {
    private static final String JWT_TRANSFORMATION_BASE_PLUGIN_ID = "org.eclipse.jwt.transformations.baseTransformation";
    private final Transformation.Type transformationType;
    private final IStructuredSelection selection;
    private final String transformationComboText;
    private final String inputGroupText;
    private final String outputGroupText;
    private TransformationGroup transformationGroup;
    private IOGroup inputHandle;
    private IOGroup outputHandle;

    public TransformationWizardPage(Transformation.Type transformationType, IStructuredSelection selection, String pageName, String pageTitle, String transformationComboText, String pageDescription, String inputGroupText, String outputGroupText) {
        super(pageName);
        this.setTitle(pageTitle);
        this.setDescription(pageDescription);
        this.transformationType = transformationType;
        this.selection = selection;
        this.transformationComboText = transformationComboText;
        this.inputGroupText = inputGroupText;
        this.outputGroupText = outputGroupText;
    }

    public void createControl(Composite parent) {
        if (this.getControl() == null) {
            Composite mainControl = new Composite(parent, 0);
            mainControl.setLayoutData((Object)new GridData(1808));
            mainControl.setLayout((Layout)new GridLayout());
            this.transformationGroup = new TransformationGroup(mainControl, new TransformationChangedListener(), TransformationRegistry.getInstance().getTransformationsByType(this.transformationType), this.transformationComboText);
            this.transformationGroup.getControl().setLayoutData((Object)new GridData(1808));
            this.inputHandle = new IOGroup(mainControl, new CompletedPageListener(null, null), this.selection, this.inputGroupText, TransformationsMessages.inputTypeComboText){

                @Override
                protected Collection<IODefinition> extractIODefinitions(Transformation transformation) {
                    return transformation.getCompatibleInputDefinitions();
                }
            };
            this.inputHandle.getControl().setLayoutData((Object)new GridData(1808));
            this.outputHandle = new IOGroup(mainControl, new CompletedPageListener(null, null), this.selection, this.outputGroupText, TransformationsMessages.outputTypeComboText){

                @Override
                protected Collection<IODefinition> extractIODefinitions(Transformation transformation) {
                    return transformation.getCompatibleOutputDefinitions();
                }
            };
            this.outputHandle.getControl().setLayoutData((Object)new GridData(1808));
            this.setControl((Control)mainControl);
            this.setPageComplete(this.hasAllRequiredInfo());
        }
    }

    public boolean finish() {
        boolean cancelled = PlatformUI.getWorkbench().saveAllEditors(true);
        if (!cancelled) {
            return false;
        }
        try {
            Transformation transformation = this.transformationGroup.getTransformation();
            transformation.transform(this.inputHandle.getValue(), this.outputHandle.getValue());
            this.inputHandle.afterTransformation();
            this.outputHandle.afterTransformation();
        }
        catch (Exception e1) {
            Status status = new Status(4, JWT_TRANSFORMATION_BASE_PLUGIN_ID, e1.getMessage(), e1.getCause());
            ErrorDialog.openError((Shell)this.getShell(), (String)TransformationsMessages.transformationError_title, (String)TransformationsMessages.transformationError_details, (IStatus)status);
            return false;
        }
        return true;
    }

    private void updateSelectedTransformation() {
        Transformation selectedTransformation = this.transformationGroup.getTransformation();
        this.inputHandle.setTransformation(selectedTransformation);
        this.outputHandle.setTransformation(selectedTransformation);
    }

    private boolean hasAllRequiredInfo() {
        return this.transformationGroup.getTransformation() != null && this.inputHandle.hasAllRequiredInformation() && this.outputHandle.hasAllRequiredInformation();
    }

    private class CompletedPageListener
    implements ContentChangeListener {
        private CompletedPageListener() {
        }

        public void contentChanged() {
            TransformationWizardPage.this.setPageComplete(TransformationWizardPage.this.hasAllRequiredInfo());
        }

        /* synthetic */ CompletedPageListener(CompletedPageListener completedPageListener, CompletedPageListener completedPageListener2) {
            this();
        }
    }

    private class TransformationChangedListener
    extends CompletedPageListener {
        private TransformationChangedListener() {
        }

        public void contentChanged() {
            TransformationWizardPage.this.updateSelectedTransformation();
            super.contentChanged();
        }
    }
}

