/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.ui.internal.contentassist;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jst.jsp.core.internal.contentmodel.TaglibController;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.CMDocumentImpl;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.TLDCMDocumentManager;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.TaglibTracker;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.provisional.TLDFunction;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTExpression;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTFunctionInvocation;
import org.eclipse.jst.jsp.core.internal.java.jspel.FindFunctionInvocationVisitor;
import org.eclipse.jst.jsp.core.internal.java.jspel.JSPELParser;
import org.eclipse.jst.jsp.core.internal.java.jspel.JSPELParserTokenManager;
import org.eclipse.jst.jsp.core.internal.java.jspel.JSPELParserVisitor;
import org.eclipse.jst.jsp.core.internal.java.jspel.ParseException;
import org.eclipse.jst.jsp.core.internal.java.jspel.SimpleCharStream;
import org.eclipse.jst.jsp.core.internal.java.jspel.Token;
import org.eclipse.jst.jsp.ui.internal.contentassist.JSPCompletionProcessor;
import org.eclipse.jst.jsp.ui.internal.contentassist.JSPELCompletionProcessor;
import org.eclipse.jst.jsp.ui.internal.contentassist.JSPJavaContentAssistProcessor;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionContainer;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;
import org.eclipse.wst.sse.ui.internal.contentassist.ContentAssistUtils;
import org.eclipse.wst.sse.ui.internal.contentassist.CustomCompletionProposal;

public class JSPELContentAssistProcessor
extends JSPJavaContentAssistProcessor {
    protected char[] elCompletionProposalAutoActivationCharacters = new char[]{'.', ':'};

    protected JSPCompletionProcessor getJspCompletionProcessor() {
        if (this.fJspCompletionProcessor == null) {
            this.fJspCompletionProcessor = new JSPELCompletionProcessor();
        }
        return this.fJspCompletionProcessor;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int documentPosition) {
        ITextRegionContainer container;
        ITextRegion cursorRegion;
        IStructuredDocumentRegion flat;
        this.fJspCompletionProcessor = this.getJspCompletionProcessor();
        ICompletionProposal[] results = this.fJspCompletionProcessor.computeCompletionProposals(viewer, documentPosition);
        this.fErrorMessage = this.fJspCompletionProcessor.getErrorMessage();
        if (results.length == 0 && (this.fErrorMessage == null || this.fErrorMessage.length() == 0)) {
            this.fErrorMessage = UNKNOWN_CONTEXT;
        }
        if ((flat = ContentAssistUtils.getStructuredDocumentRegion((ITextViewer)viewer, (int)documentPosition)) != null && "XML_TAG_ATTRIBUTE_VALUE" == (cursorRegion = flat.getRegionAtCharacterOffset(documentPosition)).getType() && (cursorRegion = (container = (ITextRegionContainer)cursorRegion).getRegionAtCharacterOffset(documentPosition)).getType() == "JSP_EL_CONTENT") {
            String elText = container.getText(cursorRegion).trim();
            String prefix = this.getPrefix(documentPosition - container.getStartOffset(cursorRegion) - 1, elText);
            if (prefix != null) {
                List proposals = this.getFunctionProposals(prefix, (StructuredTextViewer)viewer, documentPosition);
                results = new ICompletionProposal[proposals.size()];
                proposals.toArray(results);
            }
        }
        return results;
    }

    /*
     * Handled impossible loop by duplicating code
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    protected String getPrefix(int relativePosition, String elText) {
        block6: {
            Token curToken;
            JSPELParserTokenManager scanner;
            block5: {
                StringReader reader = new StringReader(elText);
                scanner = new JSPELParserTokenManager(new SimpleCharStream((Reader)reader, 1, 1));
                curToken = null;
                Object var6_6 = null;
                if (!true) break block5;
                curToken = scanner.getNextToken();
                if (curToken.kind == 0) break block6;
            }
            do {
                void var6_7;
                if (29 == curToken.kind && curToken.endColumn == relativePosition && var6_7 != null) {
                    return var6_7.image;
                }
                if (47 == curToken.kind) {
                    Token token = curToken;
                } else {
                    Object var6_9 = null;
                }
                curToken = scanner.getNextToken();
            } while (curToken.kind != 0);
        }
        return null;
    }

    protected ASTFunctionInvocation getInvocation(int relativePosition, String elText) {
        FindFunctionInvocationVisitor visitor = new FindFunctionInvocationVisitor(relativePosition);
        JSPELParser parser = JSPELParser.createParser((String)elText);
        try {
            ASTExpression expression = parser.Expression();
            return (ASTFunctionInvocation)expression.jjtAccept((JSPELParserVisitor)visitor, null);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return this.elCompletionProposalAutoActivationCharacters;
    }

    protected List getFunctionProposals(String prefix, StructuredTextViewer viewer, int offset) {
        TLDCMDocumentManager docMgr = TaglibController.getTLDCMDocumentManager((IDocument)viewer.getDocument());
        ArrayList<CustomCompletionProposal> completionList = new ArrayList<CustomCompletionProposal>();
        if (docMgr == null) {
            return null;
        }
        for (TaglibTracker tracker : docMgr.getCMDocumentTrackers(offset)) {
            if (!tracker.getPrefix().equals(prefix)) continue;
            CMDocumentImpl doc = (CMDocumentImpl)tracker.getDocument();
            List functions = doc.getFunctions();
            for (TLDFunction function : functions) {
                CustomCompletionProposal proposal = new CustomCompletionProposal(String.valueOf(function.getName()) + "()", offset, 0, function.getName().length() + 1, null, String.valueOf(function.getName()) + " - " + function.getSignature(), null, null, 1);
                completionList.add(proposal);
            }
        }
        return completionList;
    }
}

