/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.pgm;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.eclipse.jgit.awtui.AwtAuthenticator;
import org.eclipse.jgit.awtui.AwtCredentialsProvider;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.lfs.CleanFilter;
import org.eclipse.jgit.lfs.SmudgeFilter;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryBuilder;
import org.eclipse.jgit.pgm.CommandCatalog;
import org.eclipse.jgit.pgm.CommandRef;
import org.eclipse.jgit.pgm.Die;
import org.eclipse.jgit.pgm.TextBuiltin;
import org.eclipse.jgit.pgm.Version;
import org.eclipse.jgit.pgm.internal.CLIText;
import org.eclipse.jgit.pgm.opt.CmdLineParser;
import org.eclipse.jgit.pgm.opt.SubcommandHandler;
import org.eclipse.jgit.transport.HttpTransport;
import org.eclipse.jgit.transport.http.HttpConnectionFactory;
import org.eclipse.jgit.transport.http.apache.HttpClientConnectionFactory;
import org.eclipse.jgit.util.CachedAuthenticator;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.ExampleMode;
import org.kohsuke.args4j.Option;

public class Main {
    @Option(name="--help", usage="usage_displayThisHelpText", aliases={"-h"})
    private boolean help;
    @Option(name="--version", usage="usage_displayVersion")
    private boolean version;
    @Option(name="--show-stack-trace", usage="usage_displayThejavaStackTraceOnExceptions")
    private boolean showStackTrace;
    @Option(name="--git-dir", metaVar="metaVar_gitDir", usage="usage_setTheGitRepositoryToOperateOn")
    private String gitdir;
    @Argument(index=0, metaVar="metaVar_command", required=true, handler=SubcommandHandler.class)
    private TextBuiltin subcommand;
    @Argument(index=1, metaVar="metaVar_arg")
    private List<String> arguments = new ArrayList<String>();
    PrintWriter writer;
    private ExecutorService gcExecutor;

    public Main() {
        HttpTransport.setConnectionFactory((HttpConnectionFactory)new HttpClientConnectionFactory());
        CleanFilter.register();
        SmudgeFilter.register();
        this.gcExecutor = Executors.newSingleThreadExecutor(new ThreadFactory(){
            private final ThreadFactory baseFactory = Executors.defaultThreadFactory();

            @Override
            public Thread newThread(Runnable taskBody) {
                Thread thr = this.baseFactory.newThread(taskBody);
                thr.setName("JGit-autoGc");
                return thr;
            }
        });
    }

    public static void main(String[] argv) throws Exception {
        new Main().run(argv);
    }

    protected void run(String[] argv) throws Exception {
        this.writer = this.createErrorWriter();
        try {
            if (!Main.installConsole()) {
                AwtAuthenticator.install();
                AwtCredentialsProvider.install();
            }
            Main.configureHttpProxy();
            this.execute(argv);
        }
        catch (Die err) {
            if (err.isAborted()) {
                this.exit(1, err);
            }
            this.writer.println(CLIText.fatalError(err.getMessage()));
            if (this.showStackTrace) {
                err.printStackTrace(this.writer);
            }
            this.exit(128, err);
        }
        catch (Exception err) {
            if (err.getClass() == IOException.class) {
                if (err.getMessage().equals("Broken pipe")) {
                    this.exit(0, err);
                }
                if (err.getMessage().equals("The pipe is being closed")) {
                    this.exit(0, err);
                }
            }
            if (!this.showStackTrace && err.getCause() != null && err instanceof TransportException) {
                this.writer.println(CLIText.fatalError(err.getCause().getMessage()));
            }
            if (err.getClass().getName().startsWith("org.eclipse.jgit.errors.")) {
                this.writer.println(CLIText.fatalError(err.getMessage()));
                if (this.showStackTrace) {
                    err.printStackTrace();
                }
                this.exit(128, err);
            }
            err.printStackTrace();
            this.exit(1, err);
        }
        if (System.out.checkError()) {
            this.writer.println(CLIText.get().unknownIoErrorStdout);
            this.exit(1, null);
        }
        if (this.writer.checkError()) {
            this.exit(1, null);
        }
        this.gcExecutor.shutdown();
        this.gcExecutor.awaitTermination(10L, TimeUnit.MINUTES);
    }

    PrintWriter createErrorWriter() {
        return new PrintWriter(new OutputStreamWriter((OutputStream)System.err, StandardCharsets.UTF_8));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(String[] argv) throws Exception {
        SubcommandLineParser clp;
        block15: {
            clp = new SubcommandLineParser(this);
            try {
                clp.parseArgument(argv);
            }
            catch (CmdLineException err) {
                if (argv.length <= 0 || this.help || this.version) break block15;
                this.writer.println(CLIText.fatalError(err.getMessage()));
                this.writer.flush();
                this.exit(1, (Exception)((Object)err));
            }
        }
        if (argv.length == 0 || this.help) {
            String ex = clp.printExample(ExampleMode.ALL, CLIText.get().resourceBundle());
            this.writer.println("jgit" + ex + " command [ARG ...]");
            if (this.help) {
                this.writer.println();
                clp.printUsage(this.writer, CLIText.get().resourceBundle());
                this.writer.println();
            } else if (this.subcommand == null) {
                this.writer.println();
                this.writer.println(CLIText.get().mostCommonlyUsedCommandsAre);
                CommandRef[] common = CommandCatalog.common();
                int width = 0;
                for (CommandRef c : common) {
                    width = Math.max(width, c.getName().length());
                }
                width += 2;
                for (CommandRef c : common) {
                    this.writer.print(' ');
                    this.writer.print(c.getName());
                    for (int i = c.getName().length(); i < width; ++i) {
                        this.writer.print(' ');
                    }
                    this.writer.print(CLIText.get().resourceBundle().getString(c.getUsage()));
                    this.writer.println();
                }
                this.writer.println();
            }
            this.writer.flush();
            this.exit(1, null);
        }
        if (this.version) {
            String cmdId = Version.class.getSimpleName().toLowerCase(Locale.ROOT);
            this.subcommand = CommandCatalog.get(cmdId).create();
        }
        TextBuiltin cmd = this.subcommand;
        this.init(cmd);
        try {
            cmd.execute(this.arguments.toArray(new String[this.arguments.size()]));
        }
        finally {
            if (cmd.outw != null) {
                cmd.outw.flush();
            }
            if (cmd.errw != null) {
                cmd.errw.flush();
            }
        }
    }

    void init(TextBuiltin cmd) throws IOException {
        if (cmd.requiresRepository()) {
            cmd.init(this.openGitDir(this.gitdir), null);
        } else {
            cmd.init(null, this.gitdir);
        }
    }

    void exit(int status, Exception t) throws Exception {
        this.writer.flush();
        System.exit(status);
    }

    protected Repository openGitDir(String aGitdir) throws IOException {
        RepositoryBuilder rb = (RepositoryBuilder)((RepositoryBuilder)((RepositoryBuilder)new RepositoryBuilder().setGitDir(aGitdir != null ? new File(aGitdir) : null)).readEnvironment()).findGitDir();
        if (rb.getGitDir() == null) {
            throw new Die(CLIText.get().cantFindGitDirectory);
        }
        return rb.build();
    }

    private static boolean installConsole() {
        try {
            Main.install("org.eclipse.jgit.console.ConsoleAuthenticator");
            Main.install("org.eclipse.jgit.console.ConsoleCredentialsProvider");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        catch (NoClassDefFoundError e) {
            return false;
        }
        catch (UnsupportedClassVersionError e) {
            return false;
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(CLIText.get().cannotSetupConsole, e);
        }
        catch (SecurityException e) {
            throw new RuntimeException(CLIText.get().cannotSetupConsole, e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(CLIText.get().cannotSetupConsole, e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(CLIText.get().cannotSetupConsole, e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(CLIText.get().cannotSetupConsole, e);
        }
    }

    private static void install(String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException, ClassNotFoundException {
        try {
            Class.forName(name).getMethod("install", new Class[0]).invoke(null, new Object[0]);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            if (e.getCause() instanceof Error) {
                throw (Error)e.getCause();
            }
            throw e;
        }
    }

    static void configureHttpProxy() throws MalformedURLException {
        for (String protocol : new String[]{"http", "https"}) {
            String userpass;
            if (System.getProperty(protocol + ".proxyHost") != null) continue;
            String s = System.getenv(protocol + "_proxy");
            if (s == null && protocol.equals("https")) {
                s = System.getenv("HTTPS_PROXY");
            }
            if (s == null || s.equals("")) continue;
            URL u = new URL(s.indexOf("://") == -1 ? protocol + "://" + s : s);
            if (!u.getProtocol().startsWith("http")) {
                throw new MalformedURLException(MessageFormat.format(CLIText.get().invalidHttpProxyOnlyHttpSupported, s));
            }
            String proxyHost = u.getHost();
            int proxyPort = u.getPort();
            System.setProperty(protocol + ".proxyHost", proxyHost);
            if (proxyPort > 0) {
                System.setProperty(protocol + ".proxyPort", String.valueOf(proxyPort));
            }
            if ((userpass = u.getUserInfo()) == null || !userpass.contains(":")) continue;
            int c = userpass.indexOf(58);
            String user = userpass.substring(0, c);
            String pass = userpass.substring(c + 1);
            CachedAuthenticator.add((CachedAuthenticator.CachedAuthentication)new CachedAuthenticator.CachedAuthentication(proxyHost, proxyPort, user, pass));
        }
    }

    static class SubcommandLineParser
    extends CmdLineParser {
        public SubcommandLineParser(Object bean) {
            super(bean);
        }

        @Override
        protected boolean containsHelp(String ... args) {
            return false;
        }
    }
}

